/* Copyright 2013 Akira Ohta (akohta001@gmail.com)
    This file is part of ntch.

    The ntch is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    The ntch is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ntch.  If not, see <http://www.gnu.org/licenses/>.
    
*/
#ifndef _TEXT_H_
#define _TEXT_H_

extern BOOL nt_w_str_move(wchar_t *buf, 
			size_t buf_len,int move_index, int offset);
extern wchar_t *nt_w_trim(const wchar_t *source);
extern wchar_t *nt_w_trim_quotes(const wchar_t *source);
extern char *nt_trim2(const char *source, char *buf, size_t buf_len);
#define nt_trim(a) nt_trim2((a), NULL,0)

extern wchar_t* nt_w_str_clone(const wchar_t *cptr);
extern char* nt_str_clone(const char *cptr);
extern char* nt_substr(const char *cptr, int start, int end);
extern wchar_t* nt_w_substr(const wchar_t* src, int start, int end);
extern BOOL nt_strtok(const char *str, char delim, 
		const char** start, const char **end);
extern BOOL nt_w_strtok(const wchar_t *str, wchar_t delim,
        const wchar_t** start, const wchar_t **end);
extern wchar_t* nt_w_str_resize(wchar_t *old_src, 
		size_t old_size, size_t new_size);

#endif /* _TEXT_H_ */
