<?php
/*
 nce (ntch cloud environment.)
 name: nc_delete_lines_file.php
 author: Akira Ohta (akohta001.gmail.com)
 date: 2013-apr-14th
 description:
 License: GPLv3
 */
include_once "account.php";
include_once "preference.php";
include_once "database.php";
include_once "log.php";
include_once "http_util.php";
include_once "error_code.php";

$user_id = $_POST['user'];
$hashed_passwd = $_POST['token'];
$file_name = $_POST['file_name'];
$num = $_POST['num'];

$user = chk_passwd( $user_id, $hashed_passwd);
if(FALSE === $user){
	echo $ERROR_MSG;
	exit;
}

if(!chk_file_name($file_name) || !$num || FALSE == is_numeric($num)){
	echo ERROR303;
	exit;
}

if($num <= 0 || $num > 50){
	echo ERROR304;
	exit;
}

$home_dir = OUTPUT_DIR."/{$user->home_dir}";

if(!is_dir($home_dir)){
	$rc = mkdir($home_dir, 0755, true);
	if(!$rc){
		nc_logging("Failed to create folders: $home_dir");
		echo ERROR400;
		exit;
	}
}

$delete_lines = array();
for($i= 1; $i <= $num; $i++){
	$s1 = $_POST['n'.$i];
	if(!isset($s1))
		continue;
	if(0 == strlen($s1))
		continue;
	$delete_lines[] = replace_urlencodeTo64symbol($s1);
}


$file_path = $home_dir.'/'.$file_name;

$org_lines = file($file_path);
if(!$org_lines){
	$org_lines = array();
}

@$fp=fopen($file_path, 'w');
if(!$fp){
	nc_logging("Failed to create files: $file_path");
	echo ERROR400;
	exit;
}
flock($fp, LOCK_EX);
$len = count($org_lines);

for($i = 0; $i < $len; $i++){
	$s1 = trim($org_lines[$i]);
	if(0 == strlen($s1))
		continue;
	if(!in_array($s1, $delete_lines)){
		fwrite($fp, $s1."\n");
	}
}

flock($fp, LOCK_UN);
fclose($fp);

echo SUCCESS100;

?>
