/* Copyright 2013 Akira Ohta (akohta001@gmail.com)
    This file is part of ntch.

    The ntch is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    The ntch is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ntch.  If not, see <http://www.gnu.org/licenses/>.
    
*/
#ifndef _NT_CONV_CHAR_H_
#define _NT_CONV_CHAR_H_

BOOL nt_conv_sjis2wc(iconv_t icd,
     const char *src, wchar_t *data, size_t data_len);
BOOL nt_conv_wc2sjis(iconv_t icd,
    const wchar_t *src, char *data, size_t data_len);
BOOL nt_conv_local2sjis(iconv_t icd,
    const char *src, char *data, size_t data_len);

#define nt_conv_local2wc(a,b,c,d) nt_conv_sjis2wc((a),(b),(c),(d))
#define nt_conv_wc2local(a,b,c,d) nt_conv_wc2sjis((a),(b),(c),(d))

#endif /* _NT_CONV_CHAR_H_ */
