<?php
/*
 * Nucleus: PHP/MySQL Weblog CMS (http://nucleuscms.org/)
 * Copyright (C) 2002-2007 The Nucleus Group
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * (see nucleus/documentation/index.html#license for more info)
 */
/**
 * @license http://nucleuscms.org/license.txt GNU General Public License
 * @copyright Copyright (C) 2002-2007 The Nucleus Group
 * @version $Id: index.php 846 2005-12-30 10:38:32Z dekarma $
 * $NucleusJP: index.php,v 1.11.2.1 2007/10/23 07:26:41 kimitake Exp $
 *
 */

include('upgrade.functions.php');

// check if logged in etc
if (!$member->isLoggedIn()) {
  upgrade_showLogin('index.php');
}

if (!$member->isAdmin()) {
  upgrade_error('Super-admin（最高管理者）のみがアップグレードを実行できます。');
}

upgrade_head();

?>

<h1>アップグレードスクリプト集</h1>

<div class="note">
<b>Note:</b> もし古いバージョンの Nuclues からアップグレードしようとしているのでなければ（つまりまっさらな状態からインストールしたのであれば）、これらのスクリプト集は必要ありません。
</div>

<p>
古いバージョンの Nucleus からアップグレードするとき、データベーステーブルのアップグレードが必要です。
このアップグレードスクリプトを実行することでそれが可能となります。
</p>

<?php  // calculate current version
	  if (!upgrade_checkinstall(96)) $current = 95;
  else  if (!upgrade_checkinstall(10)) $current = 96;
  else  if (!upgrade_checkinstall(11)) $current = 10;
  else  if (!upgrade_checkinstall(15)) $current = 11;
  else  if (!upgrade_checkinstall(20)) $current = 15;
  else  if (!upgrade_checkinstall(25)) $current = 20;
  else  if (!upgrade_checkinstall(30)) $current = 25;
  else  if (!upgrade_checkinstall(31)) $current = 30;
  else  if (!upgrade_checkinstall(32)) $current = 31;
  else  if (!upgrade_checkinstall(33)) $current = 32;
  else  $current = 33;

  if ($current == 33) {
	?>
	  <p class="ok">自動でできるアップグレードはありません。データベースは既に最新の Nucleus 用にアップデートされています。</p>
	<?php
  } else {
	?>
	  <p class="warning"><a href="upgrade.php?from=<?php echo $current?>">ここをクリックしてデータベースを Nucleus v3.31 用にアップグレードします</a></p>
	<?php
  }
?>

<div class="note">
<b>注意:</b> 作業中、各ステップごとにデータベースのバックアップを忘れないようにして下さい。
</div>

<h1>手動変更</h1>

<p>いくつかの変更は手動で行う必要があります。下記にその手順を示します。</p>

<?php
$sth = 0;
if (!$DIR_MEDIA) {
  upgrade_manual_96();
  $sth = 1;
}
if (!$DIR_SKINS) {
  upgrade_manual_20();
  $sth = 1;
}

// some manual code changes are needed in order to get Nucleus to work on php version
// lower than 4.0.6
if (phpversion() < '4.0.6') {
  upgrade_manual_php405();
  $sth = 1;
}

// from v3.3, atom feed supports 1.0 and blogsetting is added
$sth = upgrade_manual_atom1_0();

if ($sth == 0)
  echo "<p class='ok'>手動変更は必要ありません。今日はラッキーな日ですね!</p>";



upgrade_foot();

function upgrade_todo($ver) {
  return upgrade_checkinstall($ver) ? "(<span class='ok'>インストール済み</span>)" : "(<span class='warning'>インストールが必要</span>)";
}

function upgrade_manual_96() {
  global $DIR_NUCLEUS;

  $guess = str_replace("/nucleus/","/media/",$DIR_NUCLEUS);
?>
  <h2>Nucleus 0.96 用に必要な変更</h2>
  <p>
    メディア機能を使用するために<i>config.php</i>を手動で変更する必要があります。下記の通り追加します:
  </p>
  <pre>
  // path to media dir
  $DIR_MEDIA = '<b><?php echo htmlspecialchars($guess)?></b>';
  </pre>

  <p>
  また、ディレクトリもあなた自身の手で作る必要があります。もしファイルのアップロードを可能にしたいのであれば、media/ ディレクトリのパーミッションを777にします。（Nucleus 0.96+ のためのパーミッションの設定に関するクイックガイドが documentation/tips.html にあります）
  </p>

<?php }

function upgrade_manual_20() {
  global $DIR_NUCLEUS;

  $guess = str_replace("/nucleus/","/skins/",$DIR_NUCLEUS);
?>
  <h2>Nucleus 2.0 用に必要な変更</h2>
  <p>
    スキンの取り込み機能を使用するために<i>config.php</i>を手動で変更する必要があります。下記の通り追加します:
  </p>
  <pre>
  // extra skin files for imported skins
  $DIR_SKINS = '<b><?php echo htmlspecialchars($guess)?></b>';
  </pre>

  <p>また、ディレクトリもあなた自身の手で作る必要があります。これでダウンロードしたスキンを上記ディレクトリに展開したり、Nucleus 管理画面から取り込んだりできるようになります。</p>

  <h3>RSS 2.0 と RSD スキン</h3>

  <p>Nucleus 2.0 を新規にインストールしたとき、RSD(Really Simple Discovery) 用のスキンの他に、RSS 2.0(Really Simple Syndication)用のスキンもまたインストールされます。<code>xml-rss2.php</code> と <code>rsd.php</code> の両ファイルはアップグレードされますが、スキンに関しては手動でインストールする必要があります。<code>upgrade-files</code>の中身をアップロードしたあと、管理者画面を開き、管理ホームにあるスキンの「読込/書出」を開きます。そこから両スキンをインストールすることができます（もしインストールするつもりがなければ、しなくても結構です）。</p>

<?php }

function upgrade_manual_php405() {
?>
<h2>PHP のバージョンが 4.0.3, 4.0.4 または 4.0.5 の場合に必要となる変更</h2>
<p>
  PHP のバージョンが 4.0.6 より以前の場合、変更が必要なファイルが２つあります。PHP のバージョンを 4.0.6 や 4.2.2+以降のものにアップグレードした方がいいでしょう（4.0.6 や 4.2.2 以前のものにはセキュリティー問題があります）。もし PHP のアップグレードが困難もしくは、する予定がない場合は、以下のファイルを変更して下さい。
</p>
<ul>
  <li>nucleus/libs/PARSER.php のコードが下記のようになっていることを確認して下さい。（84行目から）:
	<pre>

  if (in_array($actionlc, $this-&gt;actions) || $this-&gt;norestrictions ) {
	<strong>$this-&gt;call_using_array($action, $this-&gt;handler, $params);</strong>
  } else {
	// redirect to plugin action if possible
	if (in_array('plugin', $this-&gt;actions)
	  && $manager-&gt;pluginInstalled('NP_'.$action))
	  $this-&gt;doAction('plugin('.$action.
		$this-&gt;pdelim.implode($this-&gt;pdelim,$params).')');
	else
	  echo '&lt;b&gt;DISALLOWED (' , $action , ')&lt;/b&gt;';
  }


}
	 </pre>
	</li>
	<li>nucleus/libs/PARSER.php のコードが下記のようになっていることを確認して下さい。（75行目から）:
	<pre>
// $params = array_map('trim',$params);
foreach ($params as $key =&gt; $value) { $params[$key] = trim($value); }
	</pre>
	</li>
  </ul>

<?php }

function upgrade_manual_atom1_0() {

	$sth = 0;

	// atom 1.0
	$query = 'SELECT sddesc FROM ' . sql_table('skin_desc')
		. ' WHERE sdname="feeds/atom"';
	$res = mysql_query($query);
	while ($o = mysql_fetch_object($res)) {
		if ($o->sddesc=='Atom 0.3 weblog syndication')
		{
			$sth = 1;
?>
<h2>Atom 1.0</h2>
<p>Nucleus 3.3 から atom feed が 1.0 対応になりましたので、次の手順でスキン・テンプレートのアップグレードをして下さい。</p>

<p>管理者画面を開き、管理ホームにあるスキンの「読込/書出」を開きます。そこから atom を選択し、読み込みボタンを押して上書きインストールしてください。</p>

<p>もし atom のスキンやテンプレートを変更している場合は、既存の内容をファイルに書き出して（skinbackup.xml というファイルが作成されます）、/skins/atom/skinbackup.xml （これが新しいファイル）と比較し、この新しいファイルを更新します。その後、前述の通り管理者画面からスキンの「読込/書出」を開いて同様にして上書きインストールして下さい。</p>

<?php
		}
	}

	// default skin
	$query = 'SELECT tdnumber FROM ' . sql_table('template_desc')
		   . ' WHERE tdname="default/index"';
	$res = mysql_query($query);
	$tdnumber = 0;
	while ($o = mysql_fetch_object($res)) {
		$tdnumber = $o->tdnumber;
	}
	if ($tdnumber>0)
	{
		$query = 'SELECT tpartname FROM ' . sql_table('template')
			   . ' WHERE tdesc=' . $tdnumber . ' AND tpartname="BLOGLIST_LISTITEM"';
		$res = mysql_query($query);
		if (!mysql_fetch_object($res)) {

			$sth = 1;
?>
<h2>Default スキン</h2>
<p>Nucleus 3.3 からいくつかのフォームの CSS が変更になっています。たとえば最初のページのログインフォームや、コメント投稿のためのフォームなど。このためフォームの表示が崩れるので、次の手順でDefault スキンのアップグレードをして下さい。</p>

<p>管理者画面を開き、管理ホームにあるスキンの「読込/書出」を開きます。そこから default を選択し、読み込みボタンを押して上書きインストールしてください。</p>

<p>もし default のスキンやテンプレートを変更している場合は、既存の内容をファイルに書き出して（skinbackup.xml というファイルが作成されます）、/skins/default/skinbackup.xml （これが新しいファイル）と比較し、この新しいファイルを更新します。その後、前述の通り管理者画面からスキンの「読込/書出」を開いて同様にして上書きインストールして下さい。</p>
<?php
		}
	}

	return $sth;
}

?>
