/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.kyutech.ai.ylab.shiva.utils.nativecapable;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;

public class Misc {
    public static byte[] fillup(byte[] ba, int size) {
        byte[] res = new byte[ba.length + size];
        System.arraycopy(ba, 0, res, 0, ba.length);
        return res;
    }

    public static byte[] readAll(InputStream is) {
        byte[] tmp = new byte[(int)Math.pow(2.0, 24.0)];
        int n = -1;
        byte[] result = new byte[]{};
        int idx = 0;
        BufferedInputStream bis = new BufferedInputStream(is);
        try {
            while ((n = bis.read(tmp)) != -1) {
                result = Misc.fillup(result, n);
                System.arraycopy(tmp, 0, result, idx, n);
                idx += n;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static File getRootDirAccess(Class<?> targetClass, File installDir) throws IOException {
        URL url = targetClass.getResource(targetClass.getSimpleName() + ".class");
        System.out.println("finding root dir for : " + targetClass.getSimpleName() + ".class");
        System.out.println(url);
        File dir = null;
        String protocol = url.getProtocol();
        if (protocol.equals("jar")) {
            installDir.mkdirs();
            File jarFile = null;
            Pattern p = Pattern.compile("(http:/.*)!/");
            Matcher m = p.matcher(url.toString());
            if (m.find()) {
                URL u = new URL(m.group(1));
                byte[] ba = Misc.readAll(new BufferedInputStream(u.openStream()));
                File f = new File(installDir, UUID.randomUUID() + ".jar");
                BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(f));
                bos.write(ba);
                jarFile = f;
            } else {
                p = Pattern.compile("(file:/.*)!/");
                m = p.matcher(url.toString());
                if (m.find()) {
                    try {
                        jarFile = new File(new URI(m.group(1)));
                    }
                    catch (URISyntaxException ex) {
                        ex.printStackTrace();
                    }
                }
            }
            if (jarFile == null) {
                System.out.println("Couldn't find : " + url);
                return null;
            }
            Misc.tryUnZip(jarFile, installDir);
            return installDir;
        }
        if (protocol.equals("file")) {
            File classFile = null;
            try {
                classFile = new File(new URI(url.toString()));
            }
            catch (URISyntaxException ex) {
                ex.printStackTrace();
            }
            Package pack = targetClass.getPackage();
            if (pack == null) {
                dir = classFile.getParentFile();
            } else {
                String packName = pack.getName();
                String[] words = packName.split("\\.");
                dir = classFile.getParentFile();
                for (int i = 0; i < words.length; ++i) {
                    dir = dir.getParentFile();
                }
            }
        } else {
            System.out.println("File\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306b\u3067\u304d\u307e\u305b\u3093");
            return null;
        }
        return dir;
    }

    public static void tryUnZip(InputStream is, File dir) throws IOException {
        File f = File.createTempFile("tmp_", "");
        FileOutputStream out = new FileOutputStream(f);
        out.write(Misc.readAll(is));
        out.close();
        Misc.tryUnZip(f, dir);
    }

    public static void tryUnZip(File f, File dir) throws IOException {
        try {
            Misc.unZip(f, dir, "UTF-8");
            return;
        }
        catch (IOException e) {
            try {
                Misc.unZip(f, dir, "MS932");
                return;
            }
            catch (IOException e2) {
                try {
                    Misc.unZip(f, dir, "euc-jp");
                    return;
                }
                catch (IOException iOException) {
                    throw new IOException("Could not unzip file : " + f);
                }
            }
        }
    }

    public static void unZip(InputStream is, File dir, String encoding) throws IOException {
        File f = File.createTempFile("tmp_", "");
        FileOutputStream out = new FileOutputStream(f);
        out.write(Misc.readAll(is));
        out.close();
        Misc.unZip(f, dir, encoding);
    }

    public static void unZip(File f, File outDir, String encoding) throws IOException {
        ZipFile zipFile = new ZipFile(f, encoding);
        Enumeration e = zipFile.getEntries();
        while (e.hasMoreElements()) {
            ZipEntry entry = (ZipEntry)e.nextElement();
            if (entry.isDirectory()) {
                new File(entry.getName()).mkdirs();
                continue;
            }
            File parent = new File(outDir, entry.getName()).getParentFile();
            parent.mkdirs();
            FileOutputStream out = new FileOutputStream(new File(outDir, entry.getName()));
            InputStream is = zipFile.getInputStream(entry);
            out.write(Misc.readAll(is));
            out.close();
            is.close();
        }
        zipFile.close();
    }
}

