/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.kyutech.ai.ylab.shiva.utils.nativecapable;

import java.applet.Applet;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.HashSet;
import jp.ac.kyutech.ai.ylab.shiva.utils.nativecapable.LibInstaller;
import jp.ac.kyutech.ai.ylab.shiva.utils.nativecapable.NaiveCapableClassLoader;
import jp.ac.kyutech.ai.ylab.shiva.utils.nativecapable.NativeCapable;
import jp.ac.kyutech.ai.ylab.shiva.utils.nativecapable.NativeCapableModule;

public class NativeCapableModuleBuilder {
    private NativeCapable nativeCapable;
    private ClassLoader oldClassLoader;
    private Collection<String> targetPackages = new HashSet<String>();
    private boolean delegeteTargets = false;
    private String moduleClassName;
    private NaiveCapableClassLoader libEnabledLoader;
    private LibInstaller installer;
    private boolean debug = false;

    public NativeCapableModuleBuilder(NativeCapable nca, String mcn) {
        this.nativeCapable = nca;
        this.moduleClassName = mcn;
    }

    public NativeCapableModule newModule() {
        SecurityManager sm = System.getSecurityManager();
        System.setSecurityManager(null);
        NativeCapableModule m = null;
        this.oldClassLoader = Thread.currentThread().getContextClassLoader();
        this.nativeCapable.setOldClassLader(this.oldClassLoader);
        Class<?> cls = null;
        URL codeBase = null;
        if (this.nativeCapable instanceof Applet) {
            Applet ap = (Applet)((Object)this.nativeCapable);
            System.out.println("codebase = " + ap.getCodeBase());
            codeBase = ap.getCodeBase();
        }
        try {
            if (!this.debug) {
                File installDir = new File(System.getProperty("java.io.tmpdir"), this.nativeCapable.getClass().getName());
                if (codeBase != null) {
                    String[] paths;
                    HashSet<URL> c = new HashSet<URL>();
                    String path = System.getProperty("java.class.path");
                    System.out.println("classpath = " + path);
                    for (String string : paths = path.split(";")) {
                        int idx;
                        if (!string.endsWith(".jar") || (idx = (string = string.replace('\\', '/')).lastIndexOf(47)) <= 0) continue;
                        c.add(new URL(codeBase, string.substring(idx)));
                    }
                    ClassLoader cl = this.getClass().getClassLoader();
                    if (cl instanceof URLClassLoader) {
                        URL[] urls;
                        URLClassLoader acl = (URLClassLoader)cl;
                        for (URL url : urls = acl.getURLs()) {
                            String string = url.toString();
                            if (!string.endsWith(".jar")) continue;
                            c.add(url);
                        }
                    }
                    URL[] urls = new URL[c.size()];
                    c.toArray(urls);
                    System.out.println("installed jars : " + c);
                    this.libEnabledLoader = new NaiveCapableClassLoader(urls, this.oldClassLoader, installDir);
                } else {
                    this.libEnabledLoader = new NaiveCapableClassLoader(new URL[0], this.oldClassLoader, installDir);
                }
                this.libEnabledLoader.setDelegateTargets(this.delegeteTargets);
                this.libEnabledLoader.setTargets(this.targetPackages);
                Thread.currentThread().setContextClassLoader(this.libEnabledLoader);
                cls = this.libEnabledLoader.loadClass(this.moduleClassName);
                this.installer = (LibInstaller)this.libEnabledLoader.findClass("jp.ac.kyutech.ai.ylab.shiva.utils.nativecapable.LibInstallerImpl").newInstance();
                try {
                    this.installer.installLibs(installDir, cls);
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            } else {
                cls = this.oldClassLoader.loadClass(this.moduleClassName);
            }
            m = (NativeCapableModule)cls.newInstance();
            this.nativeCapable.setModule(m);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.setSecurityManager(sm);
        return m;
    }

    public String getModuleClassName() {
        return this.moduleClassName;
    }

    public void setModuleClassName(String moduleClassName) {
        this.moduleClassName = moduleClassName;
    }

    public Collection<String> getTargetPackages() {
        return this.targetPackages;
    }

    public void setTargetPackages(Collection<String> targetPackages) {
        this.targetPackages = targetPackages;
    }

    public boolean isDelegateTargets() {
        return this.delegeteTargets;
    }

    public void setDelegateTargets(boolean delegateTargets) {
        this.delegeteTargets = delegateTargets;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }
}

