/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.protocol.dsound;

import com.sun.media.CircularBuffer;
import com.sun.media.protocol.dsound.DirectSoundStream;
import com.sun.media.util.LoopThread;
import javax.media.Buffer;
import javax.media.SystemTimeBase;
import javax.media.protocol.BufferTransferHandler;

class PushThread
extends LoopThread {
    private DirectSoundStream sourceStream;
    private SystemTimeBase systemTimeBase = new SystemTimeBase();
    private long seqNo = 0L;

    public PushThread() {
        this.setName("DirectSound PushThread");
    }

    void setSourceStream(DirectSoundStream ss) {
        this.sourceStream = ss;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean process() {
        Buffer buffer;
        CircularBuffer cb = this.sourceStream.cb;
        BufferTransferHandler transferHandler = this.sourceStream.transferHandler;
        CircularBuffer circularBuffer = cb;
        synchronized (circularBuffer) {
            while (!cb.canWrite()) {
                try {
                    cb.wait();
                }
                catch (Exception e2) {
                    // empty catch block
                }
            }
            buffer = cb.getEmptyBuffer();
        }
        byte[] data = buffer.getData() instanceof byte[] ? (byte[])buffer.getData() : null;
        if (data == null || data.length < this.sourceStream.bufSize) {
            data = new byte[this.sourceStream.bufSize];
            buffer.setData(data);
        }
        int len = this.sourceStream.dSound.read(data, 0, this.sourceStream.bufSize);
        buffer.setOffset(0);
        buffer.setLength(len);
        buffer.setFormat(this.sourceStream.format);
        buffer.setFlags(0x80 | 0x8000);
        buffer.setSequenceNumber(this.seqNo++);
        if (len < 1) {
            buffer.setFlags(2);
        }
        buffer.setTimeStamp(this.systemTimeBase.getNanoseconds());
        CircularBuffer circularBuffer2 = cb;
        synchronized (circularBuffer2) {
            cb.writeReport();
            cb.notify();
            if (transferHandler == null) return true;
            if (len <= 0) return true;
            transferHandler.transferData(this.sourceStream);
            return true;
        }
    }
}

