/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.ui;

import com.sun.media.util.JMFI18N;
import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Choice;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.media.Format;
import javax.media.format.AudioFormat;

public class AudioFormatChooser
extends Panel
implements ItemListener {
    public static final String ACTION_TRACK_ENABLED = "ACTION_AUDIO_TRACK_ENABLED";
    public static final String ACTION_TRACK_DISABLED = "ACTION_AUDIO_TRACK_DISABLED";
    private AudioFormat formatOld;
    private Format[] arrSupportedFormats = null;
    private Vector vectorContSuppFormats = new Vector();
    private boolean boolDisplayEnableTrack;
    private ActionListener listenerEnableTrack;
    private boolean boolEnableTrackSaved = true;
    private Checkbox checkEnableTrack;
    private Label labelEncoding;
    private Choice comboEncoding;
    private Label labelSampleRate;
    private Choice comboSampleRate;
    private Label labelHz;
    private Label labelBitsPerSample;
    private CheckboxGroup groupBitsPerSample;
    private Checkbox checkBits8;
    private Checkbox checkBits16;
    private Label labelChannels;
    private CheckboxGroup groupChannels;
    private Checkbox checkMono;
    private Checkbox checkStereo;
    private Label labelEndian;
    private CheckboxGroup groupEndian;
    private Checkbox checkEndianBig;
    private Checkbox checkEndianLittle;
    private Checkbox checkSigned;
    private boolean boolEnable8 = false;
    private boolean boolEnable16 = false;
    private boolean boolEnableMono = false;
    private boolean boolEnableStereo = false;
    private boolean boolEnableEndianBig = false;
    private boolean boolEnableEndianLittle = false;
    private boolean boolEnableSigned = false;

    public AudioFormatChooser(Format[] arrFormats, AudioFormat formatDefault) {
        this(arrFormats, formatDefault, false, null);
    }

    public AudioFormatChooser(Format[] arrFormats, AudioFormat formatDefault, boolean boolDisplayEnableTrack, ActionListener listenerEnableTrack) {
        this.arrSupportedFormats = arrFormats;
        this.boolDisplayEnableTrack = boolDisplayEnableTrack;
        this.listenerEnableTrack = listenerEnableTrack;
        int nCount = this.arrSupportedFormats.length;
        int i2 = 0;
        while (i2 < nCount) {
            if (this.arrSupportedFormats[i2] instanceof AudioFormat) {
                this.vectorContSuppFormats.addElement(this.arrSupportedFormats[i2]);
            }
            ++i2;
        }
        this.formatOld = this.isFormatSupported(formatDefault) ? formatDefault : null;
        try {
            this.init();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public void setEnabled(boolean boolEnable) {
        super.setEnabled(boolEnable);
        if (this.checkEnableTrack != null) {
            this.checkEnableTrack.setEnabled(boolEnable);
        }
        this.enableControls(boolEnable);
    }

    public Format getFormat() {
        Format formatResult = null;
        String strEncoding = this.comboEncoding.getSelectedItem();
        String strSampleRate = this.comboSampleRate.getSelectedItem();
        double dSampleRate = Double.valueOf(strSampleRate);
        int nBits = this.checkBits8.getState() && this.checkBits8.isEnabled() ? 8 : (this.checkBits16.getState() && this.checkBits16.isEnabled() ? 16 : -1);
        int nChannels = this.checkMono.getState() && this.checkMono.isEnabled() ? 1 : (this.checkStereo.getState() && this.checkStereo.isEnabled() ? 2 : -1);
        int nEndian = this.checkEndianBig.getState() && this.checkEndianBig.isEnabled() ? 1 : (this.checkEndianLittle.getState() && this.checkEndianLittle.isEnabled() ? 0 : -1);
        int nSigned = this.checkSigned.getState() ? 1 : 0;
        AudioFormat formatAudioNew = new AudioFormat(strEncoding, dSampleRate, nBits, nChannels, nEndian, nSigned);
        int nSize = this.vectorContSuppFormats.size();
        int i2 = 0;
        while (i2 < nSize && formatResult == null) {
            AudioFormat formatAudio;
            Object objectFormat = this.vectorContSuppFormats.elementAt(i2);
            if (objectFormat instanceof AudioFormat && this.isFormatGoodForEncoding(formatAudio = (AudioFormat)objectFormat) && this.isFormatGoodForSampleRate(formatAudio) && this.isFormatGoodForBitSize(formatAudio) && this.isFormatGoodForChannels(formatAudio) && this.isFormatGoodForEndian(formatAudio) && this.isFormatGoodForSigned(formatAudio) && formatAudio.matches(formatAudioNew)) {
                formatResult = formatAudio.intersects(formatAudioNew);
            }
            ++i2;
        }
        return formatResult;
    }

    public void setCurrentFormat(AudioFormat formatDefault) {
        if (this.isFormatSupported(formatDefault)) {
            this.formatOld = formatDefault;
        }
        this.updateFields(this.formatOld);
    }

    public void setSupportedFormats(Format[] arrFormats, AudioFormat formatDefault) {
        this.arrSupportedFormats = arrFormats;
        int nCount = this.arrSupportedFormats.length;
        this.vectorContSuppFormats.removeAllElements();
        int i2 = 0;
        while (i2 < nCount) {
            if (this.arrSupportedFormats[i2] instanceof AudioFormat) {
                this.vectorContSuppFormats.addElement(this.arrSupportedFormats[i2]);
            }
            ++i2;
        }
        this.formatOld = this.isFormatSupported(formatDefault) ? formatDefault : null;
        this.setSupportedFormats(this.vectorContSuppFormats);
    }

    public void setSupportedFormats(Vector vectorContSuppFormats) {
        this.vectorContSuppFormats = vectorContSuppFormats;
        if (vectorContSuppFormats.isEmpty()) {
            this.checkEnableTrack.setState(false);
            this.checkEnableTrack.setEnabled(false);
            this.onEnableTrack(true);
            return;
        }
        this.checkEnableTrack.setEnabled(true);
        this.checkEnableTrack.setState(this.boolEnableTrackSaved);
        this.onEnableTrack(true);
        if (!this.isFormatSupported(this.formatOld)) {
            this.formatOld = null;
        }
        this.updateFields(this.formatOld);
    }

    public void setTrackEnabled(boolean boolEnable) {
        this.boolEnableTrackSaved = boolEnable;
        if (this.checkEnableTrack == null) {
            return;
        }
        this.checkEnableTrack.setState(boolEnable);
        this.onEnableTrack(true);
    }

    public boolean isTrackEnabled() {
        boolean boolEnabled = this.checkEnableTrack.getState();
        return boolEnabled;
    }

    private void init() throws Exception {
        Panel panelGroup;
        this.setLayout(new BorderLayout(6, 6));
        Panel panel = this;
        this.checkEnableTrack = new Checkbox(JMFI18N.getResource("formatchooser.enabletrack"), true);
        this.checkEnableTrack.addItemListener(this);
        if (this.boolDisplayEnableTrack) {
            panelGroup = new Panel(new BorderLayout());
            panel.add((Component)panelGroup, "North");
            panelGroup.add((Component)this.checkEnableTrack, "West");
        }
        panelGroup = new Panel(new BorderLayout(6, 6));
        panel.add((Component)panelGroup, "Center");
        panel = panelGroup;
        panelGroup = new Panel(new BorderLayout());
        panel.add((Component)panelGroup, "North");
        Panel panelLabel = new Panel(new GridLayout(0, 1, 6, 6));
        panelGroup.add((Component)panelLabel, "West");
        Panel panelData = new Panel(new GridLayout(0, 1, 6, 6));
        panelGroup.add((Component)panelData, "Center");
        this.labelEncoding = new Label(JMFI18N.getResource("formatchooser.encoding"), 0);
        panelLabel.add(this.labelEncoding);
        this.comboEncoding = new Choice();
        this.comboEncoding.addItemListener(this);
        panelData.add(this.comboEncoding);
        this.labelSampleRate = new Label(JMFI18N.getResource("formatchooser.samplerate"), 0);
        panelLabel.add(this.labelSampleRate);
        Panel panelEntry = new Panel(new BorderLayout(6, 6));
        panelData.add(panelEntry);
        this.comboSampleRate = new Choice();
        this.comboSampleRate.addItemListener(this);
        panelEntry.add((Component)this.comboSampleRate, "Center");
        this.labelHz = new Label(JMFI18N.getResource("formatchooser.hz"));
        panelEntry.add((Component)this.labelHz, "East");
        this.labelBitsPerSample = new Label(JMFI18N.getResource("formatchooser.bitspersample"), 0);
        panelLabel.add(this.labelBitsPerSample);
        panelEntry = new Panel(new GridLayout(1, 0, 6, 6));
        panelData.add(panelEntry);
        this.groupBitsPerSample = new CheckboxGroup();
        this.checkBits8 = new Checkbox(JMFI18N.getResource("formatchooser.8bit"), this.groupBitsPerSample, false);
        this.checkBits8.addItemListener(this);
        panelEntry.add(this.checkBits8);
        this.checkBits16 = new Checkbox(JMFI18N.getResource("formatchooser.16bit"), this.groupBitsPerSample, false);
        this.checkBits16.addItemListener(this);
        panelEntry.add(this.checkBits16);
        this.labelChannels = new Label(JMFI18N.getResource("formatchooser.channels"), 0);
        panelLabel.add(this.labelChannels);
        panelEntry = new Panel(new GridLayout(1, 0, 6, 6));
        panelData.add(panelEntry);
        this.groupChannels = new CheckboxGroup();
        this.checkMono = new Checkbox(JMFI18N.getResource("formatchooser.mono"), this.groupChannels, false);
        this.checkMono.addItemListener(this);
        panelEntry.add(this.checkMono);
        this.checkStereo = new Checkbox(JMFI18N.getResource("formatchooser.stereo"), this.groupChannels, false);
        this.checkStereo.addItemListener(this);
        panelEntry.add(this.checkStereo);
        this.labelEndian = new Label(JMFI18N.getResource("formatchooser.endian"), 0);
        panelLabel.add(this.labelEndian);
        panelEntry = new Panel(new GridLayout(1, 0, 6, 6));
        panelData.add(panelEntry);
        this.groupEndian = new CheckboxGroup();
        this.checkEndianBig = new Checkbox(JMFI18N.getResource("formatchooser.endian.big"), this.groupEndian, false);
        this.checkEndianBig.addItemListener(this);
        panelEntry.add(this.checkEndianBig);
        this.checkEndianLittle = new Checkbox(JMFI18N.getResource("formatchooser.endian.little"), this.groupEndian, false);
        this.checkEndianLittle.addItemListener(this);
        panelEntry.add(this.checkEndianLittle);
        panelGroup = new Panel(new BorderLayout(6, 6));
        panel.add((Component)panelGroup, "Center");
        panel = panelGroup;
        panelGroup = new Panel(new BorderLayout());
        panel.add((Component)panelGroup, "North");
        this.checkSigned = new Checkbox(JMFI18N.getResource("formatchooser.signed"), true);
        this.checkSigned.addItemListener(this);
        panelGroup.add((Component)this.checkSigned, "West");
        this.updateFields(this.formatOld);
    }

    private void updateFields(AudioFormat formatDefault) {
        String strEncoding;
        String strEncodingPref = null;
        Vector<String> vectorEncoding = new Vector<String>();
        boolean boolEnable = this.comboEncoding.isEnabled();
        this.comboEncoding.setEnabled(false);
        this.comboEncoding.removeAll();
        int nSize = this.vectorContSuppFormats.size();
        int i2 = 0;
        while (i2 < nSize) {
            AudioFormat formatAudio;
            Object objectFormat = this.vectorContSuppFormats.elementAt(i2);
            if (objectFormat instanceof AudioFormat && !vectorEncoding.contains(strEncoding = (formatAudio = (AudioFormat)objectFormat).getEncoding().toUpperCase())) {
                this.comboEncoding.addItem(strEncoding);
                vectorEncoding.addElement(strEncoding);
                if (strEncodingPref == null) {
                    strEncodingPref = strEncoding;
                }
            }
            ++i2;
        }
        if (formatDefault != null) {
            strEncoding = formatDefault.getEncoding();
            this.comboEncoding.select(strEncoding);
        } else if (strEncodingPref != null) {
            this.comboEncoding.select(strEncodingPref);
        } else if (this.comboEncoding.getItemCount() > 0) {
            this.comboEncoding.select(0);
        }
        this.updateFieldsFromEncoding(formatDefault);
        this.comboEncoding.setEnabled(boolEnable);
    }

    private void updateFieldsFromEncoding(AudioFormat formatDefault) {
        String strSampleRatePref = null;
        Vector<String> vectorRates = new Vector<String>();
        boolean boolEnable = this.comboSampleRate.isEnabled();
        this.comboSampleRate.setEnabled(false);
        this.comboSampleRate.removeAll();
        int nSize = this.vectorContSuppFormats.size();
        int i2 = 0;
        while (i2 < nSize) {
            double dSampleRate;
            String strSampleRate;
            AudioFormat formatAudio;
            Object objectFormat = this.vectorContSuppFormats.elementAt(i2);
            if (objectFormat instanceof AudioFormat && this.isFormatGoodForEncoding(formatAudio = (AudioFormat)objectFormat) && !vectorRates.contains(strSampleRate = Double.toString(dSampleRate = formatAudio.getSampleRate()))) {
                this.comboSampleRate.addItem(strSampleRate);
                vectorRates.addElement(strSampleRate);
                if (strSampleRatePref == null) {
                    strSampleRatePref = strSampleRate;
                }
            }
            ++i2;
        }
        if (formatDefault != null && this.isFormatGoodForEncoding(formatDefault)) {
            this.comboSampleRate.select(Double.toString(formatDefault.getSampleRate()));
        } else if (strSampleRatePref != null) {
            this.comboEncoding.select(strSampleRatePref);
        } else if (this.comboSampleRate.getItemCount() > 0) {
            this.comboSampleRate.select(0);
        }
        this.updateFieldsFromRate(formatDefault);
        this.comboSampleRate.setEnabled(boolEnable);
    }

    private void updateFieldsFromRate(AudioFormat formatDefault) {
        int nBits;
        int nBitsPref = -1;
        this.boolEnable8 = false;
        this.boolEnable16 = false;
        int nSize = this.vectorContSuppFormats.size();
        int i2 = 0;
        while (i2 < nSize) {
            AudioFormat formatAudio;
            Object objectFormat = this.vectorContSuppFormats.elementAt(i2);
            if (objectFormat instanceof AudioFormat && this.isFormatGoodForEncoding(formatAudio = (AudioFormat)objectFormat) && this.isFormatGoodForSampleRate(formatAudio)) {
                nBits = formatAudio.getSampleSizeInBits();
                if (nBitsPref == -1) {
                    nBitsPref = nBits;
                }
                if (nBits == -1) {
                    this.boolEnable8 = true;
                    this.boolEnable16 = true;
                } else if (nBits == 8) {
                    this.boolEnable8 = true;
                } else if (nBits == 16) {
                    this.boolEnable16 = true;
                }
            }
            ++i2;
        }
        this.checkBits8.setEnabled(this.boolEnable8);
        this.checkBits16.setEnabled(this.boolEnable16);
        if (formatDefault != null && this.isFormatGoodForEncoding(formatDefault) && this.isFormatGoodForSampleRate(formatDefault)) {
            nBits = formatDefault.getSampleSizeInBits();
            if (nBits == 8) {
                this.checkBits8.setState(true);
            } else if (nBits == 16) {
                this.checkBits16.setState(true);
            }
        } else if (nBitsPref != -1) {
            if (nBitsPref == 8) {
                this.checkBits8.setState(true);
            } else if (nBitsPref == 16) {
                this.checkBits16.setState(true);
            }
        } else if (this.boolEnable8) {
            this.checkBits8.setState(true);
        } else {
            this.checkBits16.setState(true);
        }
        this.updateFieldsFromBits(formatDefault);
    }

    private void updateFieldsFromBits(AudioFormat formatDefault) {
        int nChannels;
        int nChannelsPref = -1;
        this.boolEnableMono = false;
        this.boolEnableStereo = false;
        int nSize = this.vectorContSuppFormats.size();
        int i2 = 0;
        while (i2 < nSize) {
            AudioFormat formatAudio;
            Object objectFormat = this.vectorContSuppFormats.elementAt(i2);
            if (objectFormat instanceof AudioFormat && this.isFormatGoodForEncoding(formatAudio = (AudioFormat)objectFormat) && this.isFormatGoodForSampleRate(formatAudio) && this.isFormatGoodForBitSize(formatAudio)) {
                nChannels = formatAudio.getChannels();
                if (nChannelsPref == -1) {
                    nChannelsPref = nChannels;
                }
                if (nChannels == -1) {
                    this.boolEnableMono = true;
                    this.boolEnableStereo = true;
                } else if (nChannels == 1) {
                    this.boolEnableMono = true;
                } else {
                    this.boolEnableStereo = true;
                }
            }
            ++i2;
        }
        this.checkMono.setEnabled(this.boolEnableMono);
        this.checkStereo.setEnabled(this.boolEnableStereo);
        if (formatDefault != null && this.isFormatGoodForEncoding(formatDefault) && this.isFormatGoodForSampleRate(formatDefault) && this.isFormatGoodForBitSize(formatDefault)) {
            nChannels = formatDefault.getChannels();
            if (nChannels == 1) {
                this.checkMono.setState(true);
            } else {
                this.checkStereo.setState(true);
            }
        } else if (nChannelsPref != -1) {
            if (nChannelsPref == 1) {
                this.checkMono.setState(true);
            } else {
                this.checkStereo.setState(true);
            }
        } else if (this.boolEnableMono) {
            this.checkMono.setState(true);
        } else {
            this.checkStereo.setState(true);
        }
        this.updateFieldsFromChannels(formatDefault);
    }

    private void updateFieldsFromChannels(AudioFormat formatDefault) {
        int nEndian;
        int nEndianPref = -1;
        this.boolEnableEndianBig = false;
        this.boolEnableEndianLittle = false;
        int nSize = this.vectorContSuppFormats.size();
        int i2 = 0;
        while (i2 < nSize) {
            AudioFormat formatAudio;
            Object objectFormat = this.vectorContSuppFormats.elementAt(i2);
            if (objectFormat instanceof AudioFormat && this.isFormatGoodForEncoding(formatAudio = (AudioFormat)objectFormat) && this.isFormatGoodForSampleRate(formatAudio) && this.isFormatGoodForBitSize(formatAudio) && this.isFormatGoodForChannels(formatAudio)) {
                nEndian = formatAudio.getEndian();
                if (nEndianPref == -1) {
                    nEndianPref = nEndian;
                }
                if (nEndian == -1) {
                    this.boolEnableEndianBig = true;
                    this.boolEnableEndianLittle = true;
                } else if (nEndian == 1) {
                    this.boolEnableEndianBig = true;
                } else {
                    this.boolEnableEndianLittle = true;
                }
            }
            ++i2;
        }
        this.checkEndianBig.setEnabled(this.boolEnableEndianBig);
        this.checkEndianLittle.setEnabled(this.boolEnableEndianLittle);
        if (formatDefault != null && this.isFormatGoodForEncoding(formatDefault) && this.isFormatGoodForSampleRate(formatDefault) && this.isFormatGoodForBitSize(formatDefault) && this.isFormatGoodForChannels(formatDefault)) {
            nEndian = formatDefault.getEndian();
            if (nEndian == 1) {
                this.checkEndianBig.setState(true);
            } else {
                this.checkEndianLittle.setState(true);
            }
        } else if (nEndianPref != -1) {
            if (nEndianPref == 1) {
                this.checkEndianBig.setState(true);
            } else {
                this.checkEndianLittle.setState(true);
            }
        } else if (this.boolEnableEndianBig) {
            this.checkEndianBig.setState(true);
        } else {
            this.checkEndianLittle.setState(true);
        }
        if (!this.checkBits16.getState()) {
            this.boolEnableEndianBig = false;
            this.boolEnableEndianLittle = false;
            this.checkEndianBig.setEnabled(this.boolEnableEndianBig);
            this.checkEndianLittle.setEnabled(this.boolEnableEndianLittle);
        }
        this.updateFieldsFromEndian(formatDefault);
    }

    private void updateFieldsFromEndian(AudioFormat formatDefault) {
        int nSigned;
        int nSignedPref = -1;
        boolean boolSigned = false;
        boolean boolUnsigned = false;
        int nSize = this.vectorContSuppFormats.size();
        int i2 = 0;
        while (i2 < nSize) {
            AudioFormat formatAudio;
            Object objectFormat = this.vectorContSuppFormats.elementAt(i2);
            if (objectFormat instanceof AudioFormat && this.isFormatGoodForEncoding(formatAudio = (AudioFormat)objectFormat) && this.isFormatGoodForSampleRate(formatAudio) && this.isFormatGoodForBitSize(formatAudio) && this.isFormatGoodForChannels(formatAudio) && this.isFormatGoodForEndian(formatAudio)) {
                nSigned = formatAudio.getSigned();
                if (nSignedPref == -1) {
                    nSignedPref = nSigned;
                }
                if (nSigned == -1) {
                    boolSigned = true;
                    boolUnsigned = true;
                } else if (nSigned == 1) {
                    boolSigned = true;
                } else {
                    boolUnsigned = true;
                }
            }
            ++i2;
        }
        this.boolEnableSigned = boolSigned && boolUnsigned;
        this.checkSigned.setEnabled(this.boolEnableSigned);
        if (formatDefault != null && this.isFormatGoodForEncoding(formatDefault) && this.isFormatGoodForSampleRate(formatDefault) && this.isFormatGoodForBitSize(formatDefault) && this.isFormatGoodForChannels(formatDefault) && this.isFormatGoodForEndian(formatDefault)) {
            nSigned = formatDefault.getSigned();
            if (nSigned == 1) {
                this.checkSigned.setState(true);
            } else {
                this.checkSigned.setState(false);
            }
        } else if (nSignedPref != -1) {
            if (nSignedPref == 1) {
                this.checkSigned.setState(true);
            } else {
                this.checkSigned.setState(false);
            }
        } else if (boolSigned) {
            this.checkSigned.setState(true);
        } else {
            this.checkSigned.setState(false);
        }
        this.updateFieldsFromSigned(formatDefault);
    }

    private void updateFieldsFromSigned(AudioFormat formatDefault) {
    }

    private boolean isFormatGoodForEncoding(AudioFormat format) {
        boolean boolResult = false;
        String strEncoding = this.comboEncoding.getSelectedItem();
        if (strEncoding != null) {
            boolResult = format.getEncoding().equalsIgnoreCase(strEncoding);
        }
        return boolResult;
    }

    private boolean isFormatGoodForSampleRate(AudioFormat format) {
        boolean boolResult = false;
        String strSampleRate = this.comboSampleRate.getSelectedItem();
        if (strSampleRate != null) {
            double dSampleRate = Double.valueOf(strSampleRate);
            if (format.getSampleRate() == -1.0) {
                boolResult = true;
            } else if (format.getSampleRate() == dSampleRate) {
                boolResult = true;
            }
        }
        return boolResult;
    }

    private boolean isFormatGoodForBitSize(AudioFormat format) {
        boolean boolResult = false;
        int nBits = this.checkBits8.getState() ? 8 : (this.checkBits16.getState() ? 16 : -1);
        if (format.getSampleSizeInBits() == -1) {
            boolResult = true;
        } else if (nBits == -1) {
            boolResult = true;
        } else if (format.getSampleSizeInBits() == nBits) {
            boolResult = true;
        } else if (format.getSampleSizeInBits() < 8) {
            boolResult = true;
        }
        return boolResult;
    }

    private boolean isFormatGoodForChannels(AudioFormat format) {
        boolean boolResult = false;
        int nChannels = this.checkMono.getState() ? 1 : (this.checkStereo.getState() ? 2 : -1);
        if (format.getChannels() == -1) {
            boolResult = true;
        } else if (nChannels == -1) {
            boolResult = true;
        } else if (format.getChannels() == nChannels) {
            boolResult = true;
        }
        return boolResult;
    }

    private boolean isFormatGoodForEndian(AudioFormat format) {
        boolean boolResult = false;
        int nEndian = this.checkEndianBig.getState() ? 1 : (this.checkStereo.getState() ? 0 : -1);
        if (format.getEndian() == -1) {
            boolResult = true;
        } else if (nEndian == -1) {
            boolResult = true;
        } else if (format.getEndian() == nEndian) {
            boolResult = true;
        }
        return boolResult;
    }

    private boolean isFormatGoodForSigned(AudioFormat format) {
        boolean boolResult = false;
        int nSigned = this.checkSigned.getState() ? 1 : 0;
        if (format.getSigned() == -1) {
            boolResult = true;
        } else if (nSigned == -1) {
            boolResult = true;
        } else if (format.getSigned() == nSigned) {
            boolResult = true;
        }
        return boolResult;
    }

    private boolean isFormatSupported(AudioFormat format) {
        boolean boolSupported = false;
        if (format == null) {
            return boolSupported;
        }
        int nCount = this.vectorContSuppFormats.size();
        int i2 = 0;
        while (i2 < nCount && !boolSupported) {
            AudioFormat formatAudio = (AudioFormat)this.vectorContSuppFormats.elementAt(i2);
            if (formatAudio.matches(format)) {
                boolSupported = true;
            }
            ++i2;
        }
        return boolSupported;
    }

    public void itemStateChanged(ItemEvent event) {
        Object objectSource = event.getSource();
        if (objectSource == this.checkEnableTrack) {
            this.boolEnableTrackSaved = this.checkEnableTrack.getState();
            this.onEnableTrack(true);
        } else if (objectSource == this.comboEncoding) {
            this.updateFieldsFromEncoding(this.formatOld);
        } else if (objectSource == this.comboSampleRate) {
            this.updateFieldsFromRate(this.formatOld);
        } else if (objectSource == this.checkBits8 || objectSource == this.checkBits16) {
            this.updateFieldsFromBits(this.formatOld);
        } else if (objectSource == this.checkMono || objectSource == this.checkStereo) {
            this.updateFieldsFromChannels(this.formatOld);
        } else if (objectSource == this.checkEndianBig || objectSource == this.checkEndianLittle) {
            this.updateFieldsFromEndian(this.formatOld);
        } else if (objectSource == this.checkSigned) {
            this.updateFieldsFromSigned(this.formatOld);
        }
    }

    private void onEnableTrack(boolean notifyListener) {
        boolean boolEnable = this.checkEnableTrack.getState();
        this.enableControls(boolEnable && this.isEnabled());
        if (notifyListener && this.listenerEnableTrack != null) {
            ActionEvent event = boolEnable ? new ActionEvent(this, 1001, ACTION_TRACK_ENABLED) : new ActionEvent(this, 1001, ACTION_TRACK_DISABLED);
            this.listenerEnableTrack.actionPerformed(event);
        }
    }

    private void enableControls(boolean boolEnable) {
        this.labelEncoding.setEnabled(boolEnable);
        this.comboEncoding.setEnabled(boolEnable);
        this.labelSampleRate.setEnabled(boolEnable);
        this.comboSampleRate.setEnabled(boolEnable);
        this.labelHz.setEnabled(boolEnable);
        this.labelBitsPerSample.setEnabled(boolEnable);
        this.checkBits8.setEnabled(boolEnable && this.boolEnable8);
        this.checkBits16.setEnabled(boolEnable && this.boolEnable16);
        this.labelChannels.setEnabled(boolEnable);
        this.checkMono.setEnabled(boolEnable && this.boolEnableMono);
        this.checkStereo.setEnabled(boolEnable && this.boolEnableStereo);
        this.labelEndian.setEnabled(boolEnable);
        this.checkEndianBig.setEnabled(boolEnable && this.boolEnableEndianBig);
        this.checkEndianLittle.setEnabled(boolEnable && this.boolEnableEndianLittle);
        this.checkSigned.setEnabled(boolEnable && this.boolEnableSigned);
    }
}

