/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import jp.nyatla.nyartoolkit.NyARException;
import jp.nyatla.nyartoolkit.core.NyARMat;
import jp.nyatla.util.DoubleValue;

public class NyARParam {
    private static final int SIZE_OF_PARAM_SET = 136;
    private static final int PD_LOOP = 3;
    protected int xsize;
    protected int ysize;
    private double[] array34 = new double[12];
    private double[] dist_factor = new double[4];

    public int getX() {
        return this.xsize;
    }

    public int getY() {
        return this.ysize;
    }

    public double[] getDistFactor() {
        return this.dist_factor;
    }

    public final double[] get34Array() {
        return this.array34;
    }

    public void loadFromARFile(String i_filename) throws NyARException {
        try {
            this.loadFromARFile(new FileInputStream(i_filename));
        }
        catch (Exception e) {
            throw new NyARException(e);
        }
    }

    public void loadFromARFile(InputStream i_stream) throws NyARException {
        try {
            NyARParam[] new_inst = NyARParam.arParamLoad(i_stream, 1);
            i_stream.close();
            this.xsize = new_inst[0].xsize;
            this.ysize = new_inst[0].ysize;
            this.array34 = new_inst[0].array34;
            this.dist_factor = new_inst[0].dist_factor;
        }
        catch (Exception e) {
            throw new NyARException(e);
        }
    }

    private static final double dot(double a1, double a2, double a3, double b1, double b2, double b3) {
        return a1 * b1 + a2 * b2 + a3 * b3;
    }

    private static final double norm(double a, double b, double c) {
        return Math.sqrt(a * a + b * b + c * c);
    }

    public void decompMat(NyARMat o_cpara, NyARMat o_trans) {
        int c;
        int r;
        int i;
        double[] source = this.array34;
        double[] Cpara = new double[12];
        if (source[11] >= 0.0) {
            for (i = 0; i < 12; ++i) {
                Cpara[i] = source[i];
            }
        } else {
            for (i = 0; i < 12; ++i) {
                Cpara[i] = source[i];
            }
        }
        double[][] cpara = o_cpara.getArray();
        double[][] trans = o_trans.getArray();
        for (r = 0; r < 3; ++r) {
            for (c = 0; c < 4; ++c) {
                cpara[r][c] = 0.0;
            }
        }
        cpara[2][2] = NyARParam.norm(Cpara[8], Cpara[9], Cpara[10]);
        trans[2][0] = Cpara[8] / cpara[2][2];
        trans[2][1] = Cpara[9] / cpara[2][2];
        trans[2][2] = Cpara[10] / cpara[2][2];
        trans[2][3] = Cpara[11] / cpara[2][2];
        cpara[1][2] = NyARParam.dot(trans[2][0], trans[2][1], trans[2][2], Cpara[4], Cpara[5], Cpara[6]);
        double rem1 = Cpara[4] - cpara[1][2] * trans[2][0];
        double rem2 = Cpara[5] - cpara[1][2] * trans[2][1];
        double rem3 = Cpara[6] - cpara[1][2] * trans[2][2];
        cpara[1][1] = NyARParam.norm(rem1, rem2, rem3);
        trans[1][0] = rem1 / cpara[1][1];
        trans[1][1] = rem2 / cpara[1][1];
        trans[1][2] = rem3 / cpara[1][1];
        cpara[0][2] = NyARParam.dot(trans[2][0], trans[2][1], trans[2][2], Cpara[0], Cpara[1], Cpara[2]);
        cpara[0][1] = NyARParam.dot(trans[1][0], trans[1][1], trans[1][2], Cpara[0], Cpara[1], Cpara[2]);
        rem1 = Cpara[0] - cpara[0][1] * trans[1][0] - cpara[0][2] * trans[2][0];
        rem2 = Cpara[1] - cpara[0][1] * trans[1][1] - cpara[0][2] * trans[2][1];
        rem3 = Cpara[2] - cpara[0][1] * trans[1][2] - cpara[0][2] * trans[2][2];
        cpara[0][0] = NyARParam.norm(rem1, rem2, rem3);
        trans[0][0] = rem1 / cpara[0][0];
        trans[0][1] = rem2 / cpara[0][0];
        trans[0][2] = rem3 / cpara[0][0];
        trans[1][3] = (Cpara[7] - cpara[1][2] * trans[2][3]) / cpara[1][1];
        trans[0][3] = (Cpara[3] - cpara[0][1] * trans[1][3] - cpara[0][2] * trans[2][3]) / cpara[0][0];
        for (r = 0; r < 3; ++r) {
            c = 0;
            while (c < 3) {
                double[] dArray = cpara[r];
                int n = c++;
                dArray[n] = dArray[n] / cpara[2][2];
            }
        }
    }

    public int paramDisp() {
        System.out.println("--------------------------------------");
        System.out.print("SIZE = " + this.xsize + ", " + this.ysize);
        System.out.println("Distortion factor = " + this.dist_factor[0] + " " + this.dist_factor[1] + " " + this.dist_factor[2] + " " + this.dist_factor[3]);
        for (int j = 0; j < 3; ++j) {
            for (int i = 0; i < 4; ++i) {
                System.out.print(this.array34[j * 4 + i] + " ");
            }
            System.out.println();
        }
        System.out.println("--------------------------------------");
        return 0;
    }

    public void changeSize(int i_xsize, int i_ysize) {
        double scale = (double)i_xsize / (double)this.xsize;
        for (int i = 0; i < 4; ++i) {
            this.array34[0 + i] = this.array34[0 + i] * scale;
            this.array34[4 + i] = this.array34[4 + i] * scale;
            this.array34[8 + i] = this.array34[8 + i];
        }
        this.dist_factor[0] = this.dist_factor[0] * scale;
        this.dist_factor[1] = this.dist_factor[1] * scale;
        this.dist_factor[2] = this.dist_factor[2] / (scale * scale);
        this.dist_factor[3] = this.dist_factor[3];
        this.xsize = i_xsize;
        this.ysize = i_ysize;
    }

    public void ideal2Observ(double ix, double iy, DoubleValue ox, DoubleValue oy) {
        double[] df = this.dist_factor;
        double d0 = df[0];
        double d1 = df[1];
        double d3 = df[3];
        double x = (ix - d0) * d3;
        double y = (iy - d1) * d3;
        if (x == 0.0 && y == 0.0) {
            ox.value = d0;
            oy.value = d1;
        } else {
            double d = 1.0 - df[2] / 1.0E8 * (x * x + y * y);
            ox.value = x * d + d0;
            oy.value = y * d + d1;
        }
    }

    public void ideal2ObservBatch(double[][] i_in, double[][] o_out, int i_size) {
        double[] df = this.dist_factor;
        double d0 = df[0];
        double d1 = df[1];
        double d3 = df[3];
        double d2_w = df[2] / 1.0E8;
        for (int i = 0; i < i_size; ++i) {
            double x = (i_in[i][0] - d0) * d3;
            double y = (i_in[i][1] - d1) * d3;
            if (x == 0.0 && y == 0.0) {
                o_out[i][0] = d0;
                o_out[i][1] = d1;
                continue;
            }
            double d = 1.0 - d2_w * (x * x + y * y);
            o_out[i][0] = x * d + d0;
            o_out[i][1] = y * d + d1;
        }
    }

    public int observ2Ideal(double ox, double oy, DoubleValue ix, DoubleValue iy) {
        double z0;
        double[] df = this.dist_factor;
        double d0 = df[0];
        double d1 = df[1];
        double px = ox - d0;
        double py = oy - d1;
        double p = df[2] / 1.0E8;
        double z02 = px * px + py * py;
        double q = z0 = Math.sqrt(z02);
        int i = 1;
        while (true) {
            if (z0 == 0.0) {
                px = 0.0;
                py = 0.0;
                break;
            }
            double opttmp_1 = p * z02;
            double z = z0 - ((1.0 - opttmp_1) * z0 - q) / (1.0 - 3.0 * opttmp_1);
            px = px * z / z0;
            py = py * z / z0;
            if (i == 3) break;
            z02 = px * px + py * py;
            z0 = Math.sqrt(z02);
            ++i;
        }
        double d3 = df[3];
        ix.value = px / d3 + d0;
        iy.value = py / d3 + d1;
        return 0;
    }

    public void observ2IdealBatch(int[] i_x_coord, int[] i_y_coord, int i_start, int i_num, double[][] o_ideal) {
        double[] df = this.dist_factor;
        double d0 = df[0];
        double d1 = df[1];
        double d3 = df[3];
        double p = df[2] / 1.0E8;
        for (int j = 0; j < i_num; ++j) {
            double z0;
            double px = (double)i_x_coord[i_start + j] - d0;
            double py = (double)i_y_coord[i_start + j] - d1;
            double z02 = px * px + py * py;
            double q = z0 = Math.sqrt(z02);
            int i = 1;
            while (true) {
                if (z0 == 0.0) {
                    px = 0.0;
                    py = 0.0;
                    break;
                }
                double opttmp_1 = p * z02;
                double z = z0 - ((1.0 - opttmp_1) * z0 - q) / (1.0 - 3.0 * opttmp_1);
                px = px * z / z0;
                py = py * z / z0;
                if (i == 3) break;
                z02 = px * px + py * py;
                z0 = Math.sqrt(z02);
                ++i;
            }
            o_ideal[j][0] = px / d3 + d0;
            o_ideal[j][1] = py / d3 + d1;
        }
    }

    private static NyARParam[] arParamLoad(InputStream i_stream, int i_num) throws NyARException {
        try {
            int read_size = 136 * i_num;
            byte[] buf = new byte[read_size];
            i_stream.read(buf);
            NyARParam[] result = new NyARParam[i_num];
            ByteBuffer bb = ByteBuffer.wrap(buf);
            bb.order(ByteOrder.BIG_ENDIAN);
            for (int i = 0; i < i_num; ++i) {
                int i2;
                NyARParam new_param = new NyARParam();
                new_param.xsize = bb.getInt();
                new_param.ysize = bb.getInt();
                for (i2 = 0; i2 < 3; ++i2) {
                    for (int i3 = 0; i3 < 4; ++i3) {
                        new_param.array34[i2 * 4 + i3] = bb.getDouble();
                    }
                }
                for (i2 = 0; i2 < 4; ++i2) {
                    new_param.dist_factor[i2] = bb.getDouble();
                }
                result[i] = new_param;
            }
            return result;
        }
        catch (Exception e) {
            throw new NyARException(e);
        }
    }

    public static int arParamSave(String filename, int num, NyARParam[] param) throws Exception {
        NyARException.trap("\u672a\u30c1\u30a7\u30c3\u30af\u306e\u95a2\u6570");
        byte[] buf = new byte[136 * param.length];
        ByteBuffer bb = ByteBuffer.wrap(buf);
        bb.order(ByteOrder.BIG_ENDIAN);
        for (int i = 0; i < param.length; ++i) {
            int i2;
            bb.putInt(param[i].xsize);
            bb.putInt(param[i].ysize);
            for (i2 = 0; i2 < 3; ++i2) {
                for (int i3 = 0; i3 < 4; ++i3) {
                    bb.putDouble(param[i].array34[i2 * 4 + i3]);
                }
            }
            for (i2 = 0; i2 < 4; ++i2) {
                bb.putDouble(param[i].dist_factor[i2]);
            }
        }
        FileOutputStream fs = new FileOutputStream(filename);
        fs.write(buf);
        fs.close();
        return 0;
    }
}

