/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core;

import jp.nyatla.nyartoolkit.NyARException;
import jp.nyatla.nyartoolkit.core.NyARMat;
import jp.nyatla.nyartoolkit.core.NyARParam;
import jp.nyatla.nyartoolkit.core.NyARSquare;
import jp.nyatla.nyartoolkit.core.NyARTransMat;
import jp.nyatla.nyartoolkit.core.NyARTransMatResult;
import jp.nyatla.nyartoolkit.core.NyARTransRot;
import jp.nyatla.nyartoolkit.core.NyARTransRot_O3;
import jp.nyatla.util.DoubleValue;

public class NyARTransMat_O1
implements NyARTransMat {
    private static final int AR_FITTING_TO_IDEAL = 0;
    private static final int AR_FITTING_TO_INPUT = 1;
    private static final int arFittingMode = 1;
    private static final int AR_GET_TRANS_MAT_MAX_LOOP_COUNT = 5;
    private static final double AR_GET_TRANS_MAT_MAX_FIT_ERROR = 1.0;
    private static final double AR_GET_TRANS_CONT_MAT_MAX_FIT_ERROR = 1.0;
    private static final int P_MAX = 10;
    private static final int NUMBER_OF_VERTEX = 4;
    private final NyARTransRot transrot;
    private final double[] center = new double[]{0.0, 0.0};
    private final NyARParam param;
    private final double[][] wk_transMat_pos3d = new double[10][3];
    private final double[][] wk_transMat_ppos2d = new double[4][2];
    private final double[][] wk_transMat_ppos3d = new double[4][2];
    private final double[] wk_transMat_off = new double[3];
    private final NyARTransMatResult wk_transMatContinue_result = new NyARTransMatResult();
    private final double[] wk_arGetTransMat3_initPos3d_pmax = new double[3];
    private final double[] wk_arGetTransMat3_initPos3d_pmin = new double[3];
    private final NyARMat wk_arGetTransMatSub_mat_a = new NyARMat(8, 3);
    private final NyARMat wk_arGetTransMatSub_mat_b = new NyARMat(3, 8);
    private final NyARMat wk_arGetTransMatSub_mat_c = new NyARMat(8, 1);
    private final NyARMat wk_arGetTransMatSub_mat_d = new NyARMat(3, 3);
    private final NyARMat wk_arGetTransMatSub_mat_e = new NyARMat(3, 1);
    private final NyARMat wk_arGetTransMatSub_mat_f = new NyARMat(3, 1);
    private final double[] wk_arGetTransMatSub_trans = new double[3];
    private final double[][] wk_arGetTransMatSub_pos2d = new double[10][2];
    private final DoubleValue wk_arGetTransMatSub_a1 = new DoubleValue();
    private final DoubleValue wk_arGetTransMatSub_a2 = new DoubleValue();

    public NyARTransMat_O1(NyARParam i_param) throws NyARException {
        this.param = i_param;
        this.transrot = new NyARTransRot_O3(i_param, 4);
    }

    @Override
    public void setCenter(double i_x, double i_y) {
        this.center[0] = i_x;
        this.center[1] = i_x;
    }

    @Override
    public double transMat(NyARSquare square, int i_direction, double i_width, NyARTransMatResult o_result_conv) throws NyARException {
        double[][] ppos2d = this.wk_transMat_ppos2d;
        double[][] ppos3d = this.wk_transMat_ppos3d;
        double[] off = this.wk_transMat_off;
        double[][] pos3d = this.wk_transMat_pos3d;
        double err = -1.0;
        this.transrot.initRot(square, i_direction);
        int dir = i_direction;
        ppos2d[0][0] = square.sqvertex[(4 - dir) % 4][0];
        ppos2d[0][1] = square.sqvertex[(4 - dir) % 4][1];
        ppos2d[1][0] = square.sqvertex[(5 - dir) % 4][0];
        ppos2d[1][1] = square.sqvertex[(5 - dir) % 4][1];
        ppos2d[2][0] = square.sqvertex[(6 - dir) % 4][0];
        ppos2d[2][1] = square.sqvertex[(6 - dir) % 4][1];
        ppos2d[3][0] = square.sqvertex[(7 - dir) % 4][0];
        ppos2d[3][1] = square.sqvertex[(7 - dir) % 4][1];
        ppos3d[0][0] = this.center[0] - i_width / 2.0;
        ppos3d[0][1] = this.center[1] + i_width / 2.0;
        ppos3d[1][0] = this.center[0] + i_width / 2.0;
        ppos3d[1][1] = this.center[1] + i_width / 2.0;
        ppos3d[2][0] = this.center[0] + i_width / 2.0;
        ppos3d[2][1] = this.center[1] - i_width / 2.0;
        ppos3d[3][0] = this.center[0] - i_width / 2.0;
        ppos3d[3][1] = this.center[1] - i_width / 2.0;
        this.arGetTransMat3_initPos3d(ppos3d, pos3d, off);
        for (int i = 0; i < 5 && !((err = this.arGetTransMat3(ppos2d, pos3d, off, o_result_conv)) < 1.0); ++i) {
        }
        return err;
    }

    @Override
    public double transMatContinue(NyARSquare i_square, int i_direction, double i_width, NyARTransMatResult io_result_conv) throws NyARException {
        if (!io_result_conv.hasValue()) {
            return this.transMat(i_square, i_direction, i_width, io_result_conv);
        }
        double[][] ppos2d = this.wk_transMat_ppos2d;
        double[][] ppos3d = this.wk_transMat_ppos3d;
        double[] off = this.wk_transMat_off;
        double[][] pos3d = this.wk_transMat_pos3d;
        this.transrot.initRotByPrevResult(io_result_conv);
        int dir = i_direction;
        ppos2d[0][0] = i_square.sqvertex[(4 - dir) % 4][0];
        ppos2d[0][1] = i_square.sqvertex[(4 - dir) % 4][1];
        ppos2d[1][0] = i_square.sqvertex[(5 - dir) % 4][0];
        ppos2d[1][1] = i_square.sqvertex[(5 - dir) % 4][1];
        ppos2d[2][0] = i_square.sqvertex[(6 - dir) % 4][0];
        ppos2d[2][1] = i_square.sqvertex[(6 - dir) % 4][1];
        ppos2d[3][0] = i_square.sqvertex[(7 - dir) % 4][0];
        ppos2d[3][1] = i_square.sqvertex[(7 - dir) % 4][1];
        ppos3d[0][0] = this.center[0] - i_width / 2.0;
        ppos3d[0][1] = this.center[1] + i_width / 2.0;
        ppos3d[1][0] = this.center[0] + i_width / 2.0;
        ppos3d[1][1] = this.center[1] + i_width / 2.0;
        ppos3d[2][0] = this.center[0] + i_width / 2.0;
        ppos3d[2][1] = this.center[1] - i_width / 2.0;
        ppos3d[3][0] = this.center[0] - i_width / 2.0;
        ppos3d[3][1] = this.center[1] - i_width / 2.0;
        this.arGetTransMat3_initPos3d(ppos3d, pos3d, off);
        double err2 = -1.0;
        double err1 = -1.0;
        for (int i = 0; i < 5 && !((err1 = this.arGetTransMat3(ppos2d, pos3d, off, io_result_conv)) < 1.0); ++i) {
        }
        if (err1 > 1.0) {
            NyARTransMatResult result2 = this.wk_transMatContinue_result;
            this.transrot.initRot(i_square, i_direction);
            err2 = this.transMat(i_square, i_direction, i_width, result2);
            if (err2 < err1) {
                io_result_conv.copyFrom(result2);
                err1 = err2;
            }
        }
        return err1;
    }

    private final void arGetTransMat3_initPos3d(double[][] i_ppos3d, double[][] o_pos3d, double[] o_off) throws NyARException {
        int i;
        double[] pmax = this.wk_arGetTransMat3_initPos3d_pmax;
        double[] pmin = this.wk_arGetTransMat3_initPos3d_pmin;
        pmax[2] = -1.0E10;
        pmax[1] = -1.0E10;
        pmax[0] = -1.0E10;
        pmin[2] = 1.0E10;
        pmin[1] = 1.0E10;
        pmin[0] = 1.0E10;
        for (i = 0; i < 4; ++i) {
            if (i_ppos3d[i][0] > pmax[0]) {
                pmax[0] = i_ppos3d[i][0];
            }
            if (i_ppos3d[i][0] < pmin[0]) {
                pmin[0] = i_ppos3d[i][0];
            }
            if (i_ppos3d[i][1] > pmax[1]) {
                pmax[1] = i_ppos3d[i][1];
            }
            if (!(i_ppos3d[i][1] < pmin[1])) continue;
            pmin[1] = i_ppos3d[i][1];
        }
        o_off[0] = -(pmax[0] + pmin[0]) / 2.0;
        o_off[1] = -(pmax[1] + pmin[1]) / 2.0;
        o_off[2] = -(pmax[2] + pmin[2]) / 2.0;
        for (i = 0; i < 4; ++i) {
            double[] o_pos3d_pt = o_pos3d[i];
            double[] i_pos_pd_pt = i_ppos3d[i];
            o_pos3d_pt[0] = i_pos_pd_pt[0] + o_off[0];
            o_pos3d_pt[1] = i_pos_pd_pt[1] + o_off[1];
            o_pos3d_pt[2] = 0.0;
        }
    }

    private final double arGetTransMat3(double[][] ppos2d, double[][] i_pos3d, double[] i_off, NyARTransMatResult o_result_conv) throws NyARException {
        double ret = this.arGetTransMatSub(ppos2d, i_pos3d, i_off, o_result_conv);
        return ret;
    }

    private final double arGetTransMatSub(double[][] i_ppos2d, double[][] i_pos3d, double[] i_off, NyARTransMatResult o_result_conv) throws NyARException {
        double wz;
        double wy;
        double wx;
        double[] i_pos3d_pt;
        int x2;
        double[] po2d_pt;
        int i;
        double[][] pos2d = this.wk_arGetTransMatSub_pos2d;
        double[] cpara = this.param.get34Array();
        NyARMat mat_a = this.wk_arGetTransMatSub_mat_a;
        double[][] a_array = mat_a.getArray();
        NyARMat mat_b = this.wk_arGetTransMatSub_mat_b;
        double[][] b_array = mat_b.getArray();
        DoubleValue a1 = this.wk_arGetTransMatSub_a1;
        DoubleValue a2 = this.wk_arGetTransMatSub_a2;
        for (i = 0; i < 4; ++i) {
            this.param.ideal2Observ(i_ppos2d[i][0], i_ppos2d[i][1], a1, a2);
            po2d_pt = pos2d[i];
            po2d_pt[0] = a1.value;
            po2d_pt[1] = a2.value;
        }
        NyARMat mat_c = this.wk_arGetTransMatSub_mat_c;
        double[][] c_array = mat_c.getArray();
        double[] rot = this.transrot.getArray();
        for (i = 0; i < 4; ++i) {
            x2 = i * 2;
            i_pos3d_pt = i_pos3d[i];
            po2d_pt = pos2d[i];
            wx = rot[0] * i_pos3d_pt[0] + rot[1] * i_pos3d_pt[1] + rot[2] * i_pos3d_pt[2];
            wy = rot[3] * i_pos3d_pt[0] + rot[4] * i_pos3d_pt[1] + rot[5] * i_pos3d_pt[2];
            wz = rot[6] * i_pos3d_pt[0] + rot[7] * i_pos3d_pt[1] + rot[8] * i_pos3d_pt[2];
            double d = cpara[0];
            b_array[0][x2] = d;
            a_array[x2][0] = d;
            double d2 = cpara[1];
            b_array[1][x2] = d2;
            a_array[x2][1] = d2;
            double d3 = cpara[2] - po2d_pt[0];
            b_array[2][x2] = d3;
            a_array[x2][2] = d3;
            b_array[0][x2 + 1] = 0.0;
            a_array[x2 + 1][0] = 0.0;
            double d4 = cpara[5];
            b_array[1][x2 + 1] = d4;
            a_array[x2 + 1][1] = d4;
            double d5 = cpara[6] - po2d_pt[1];
            b_array[2][x2 + 1] = d5;
            a_array[x2 + 1][2] = d5;
            c_array[x2][0] = wz * po2d_pt[0] - cpara[0] * wx - cpara[1] * wy - cpara[2] * wz;
            c_array[x2 + 1][0] = wz * po2d_pt[1] - cpara[5] * wy - cpara[6] * wz;
        }
        NyARMat mat_d = this.wk_arGetTransMatSub_mat_d;
        NyARMat mat_e = this.wk_arGetTransMatSub_mat_e;
        NyARMat mat_f = this.wk_arGetTransMatSub_mat_f;
        double[][] f_array = mat_f.getArray();
        mat_d.matrixMul(mat_b, mat_a);
        mat_e.matrixMul(mat_b, mat_c);
        mat_d.matrixSelfInv();
        mat_f.matrixMul(mat_d, mat_e);
        double[] trans = this.wk_arGetTransMatSub_trans;
        trans[0] = f_array[0][0];
        trans[1] = f_array[1][0];
        trans[2] = f_array[2][0];
        double ret = this.transrot.modifyMatrix(trans, i_pos3d, pos2d);
        for (i = 0; i < 4; ++i) {
            x2 = i * 2;
            i_pos3d_pt = i_pos3d[i];
            po2d_pt = pos2d[i];
            wx = rot[0] * i_pos3d_pt[0] + rot[1] * i_pos3d_pt[1] + rot[2] * i_pos3d_pt[2];
            wy = rot[3] * i_pos3d_pt[0] + rot[4] * i_pos3d_pt[1] + rot[5] * i_pos3d_pt[2];
            wz = rot[6] * i_pos3d_pt[0] + rot[7] * i_pos3d_pt[1] + rot[8] * i_pos3d_pt[2];
            double d = cpara[0];
            b_array[0][x2] = d;
            a_array[x2][0] = d;
            double d6 = cpara[1];
            b_array[1][x2] = d6;
            a_array[x2][1] = d6;
            double d7 = cpara[2] - po2d_pt[0];
            b_array[2][x2] = d7;
            a_array[x2][2] = d7;
            b_array[0][x2 + 1] = 0.0;
            a_array[x2 + 1][0] = 0.0;
            double d8 = cpara[5];
            b_array[1][x2 + 1] = d8;
            a_array[x2 + 1][1] = d8;
            double d9 = cpara[6] - po2d_pt[1];
            b_array[2][x2 + 1] = d9;
            a_array[x2 + 1][2] = d9;
            c_array[x2][0] = wz * po2d_pt[0] - cpara[0] * wx - cpara[1] * wy - cpara[2] * wz;
            c_array[x2 + 1][0] = wz * po2d_pt[1] - cpara[5] * wy - cpara[6] * wz;
        }
        mat_d.matrixMul(mat_b, mat_a);
        mat_e.matrixMul(mat_b, mat_c);
        mat_d.matrixSelfInv();
        mat_f.matrixMul(mat_d, mat_e);
        trans[0] = f_array[0][0];
        trans[1] = f_array[1][0];
        trans[2] = f_array[2][0];
        ret = this.transrot.modifyMatrix(trans, i_pos3d, pos2d);
        o_result_conv.updateMatrixValue(this.transrot, i_off, trans);
        return ret;
    }
}

