/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core;

final class NyARVertexCounter {
    public final int[] vertex = new int[10];
    public int number_of_vertex;
    private double thresh;
    private int[] x_coord;
    private int[] y_coord;

    NyARVertexCounter() {
    }

    public boolean getVertex(int[] i_x_coord, int[] i_y_coord, int st, int ed, double i_thresh) {
        this.number_of_vertex = 0;
        this.thresh = i_thresh;
        this.x_coord = i_x_coord;
        this.y_coord = i_y_coord;
        return this.get_vertex(st, ed);
    }

    private boolean get_vertex(int st, int ed) {
        int v1 = 0;
        int[] lx_coord = this.x_coord;
        int[] ly_coord = this.y_coord;
        double a = ly_coord[ed] - ly_coord[st];
        double b = lx_coord[st] - lx_coord[ed];
        double c = lx_coord[ed] * ly_coord[st] - ly_coord[ed] * lx_coord[st];
        double dmax = 0.0;
        for (int i = st + 1; i < ed; ++i) {
            double d = a * (double)lx_coord[i] + b * (double)ly_coord[i] + c;
            if (!(d * d > dmax)) continue;
            dmax = d * d;
            v1 = i;
        }
        if (dmax / (a * a + b * b) > this.thresh) {
            if (!this.get_vertex(st, v1)) {
                return false;
            }
            if (this.number_of_vertex > 5) {
                return false;
            }
            this.vertex[this.number_of_vertex] = v1;
            ++this.number_of_vertex;
            if (!this.get_vertex(v1, ed)) {
                return false;
            }
        }
        return true;
    }
}

