/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.detector;

import jp.nyatla.nyartoolkit.NyARException;
import jp.nyatla.nyartoolkit.core.NyARCode;
import jp.nyatla.nyartoolkit.core.NyARColorPatt;
import jp.nyatla.nyartoolkit.core.NyARColorPatt_O3;
import jp.nyatla.nyartoolkit.core.NyARDetectSquare;
import jp.nyatla.nyartoolkit.core.NyARParam;
import jp.nyatla.nyartoolkit.core.NyARSquare;
import jp.nyatla.nyartoolkit.core.NyARSquareList;
import jp.nyatla.nyartoolkit.core.NyARTransMat;
import jp.nyatla.nyartoolkit.core.NyARTransMatResult;
import jp.nyatla.nyartoolkit.core.NyARTransMat_O2;
import jp.nyatla.nyartoolkit.core.match.NyARMatchPatt_Color_WITHOUT_PCA;
import jp.nyatla.nyartoolkit.core.raster.NyARRaster;
import jp.nyatla.nyartoolkit.detector.NyARDetectMarkerResult;
import jp.nyatla.nyartoolkit.detector.NyARDetectMarkerResultHolder;

public class NyARDetectMarker {
    private static final int AR_SQUARE_MAX = 300;
    private boolean is_continue = false;
    private NyARMatchPatt_Color_WITHOUT_PCA match_patt;
    private NyARDetectSquare square;
    private final NyARSquareList square_list = new NyARSquareList(300);
    private NyARCode[] codes;
    protected NyARTransMat transmat;
    private double[] marker_width;
    private int number_of_code;
    private NyARColorPatt patt;
    private NyARDetectMarkerResultHolder result_holder = new NyARDetectMarkerResultHolder();

    public NyARDetectMarker(NyARParam i_param, NyARCode[] i_code, double[] i_marker_width, int i_number_of_code) throws NyARException {
        this.square = new NyARDetectSquare(i_param);
        this.transmat = new NyARTransMat_O2(i_param);
        this.codes = i_code;
        int cw = i_code[0].getWidth();
        int ch = i_code[0].getHeight();
        for (int i = 1; i < i_number_of_code; ++i) {
            if (cw == i_code[i].getWidth() && ch == i_code[i].getHeight()) continue;
            throw new NyARException();
        }
        this.patt = new NyARColorPatt_O3(cw, ch);
        this.number_of_code = i_number_of_code;
        this.marker_width = i_marker_width;
        this.match_patt = new NyARMatchPatt_Color_WITHOUT_PCA();
    }

    public int detectMarkerLite(NyARRaster i_image, int i_thresh) throws NyARException {
        NyARSquareList l_square_list = this.square_list;
        this.square.detectSquare(i_image, i_thresh, l_square_list);
        int number_of_square = l_square_list.getSquareNum();
        if (number_of_square < 1) {
            return 0;
        }
        this.result_holder.reservHolder(number_of_square);
        for (int i = 0; i < number_of_square; ++i) {
            NyARSquare square = l_square_list.getSquare(i);
            if (!this.patt.pickFromRaster(i_image, square)) continue;
            if (!this.match_patt.setPatt(this.patt)) {
                throw new NyARException();
            }
            int code_index = 0;
            this.match_patt.evaluate(this.codes[0]);
            double confidence = this.match_patt.getConfidence();
            int direction = this.match_patt.getDirection();
            for (int i2 = 1; i2 < this.number_of_code; ++i2) {
                this.match_patt.evaluate(this.codes[i2]);
                double c2 = this.match_patt.getConfidence();
                if (confidence > c2) continue;
                code_index = i2;
                direction = this.match_patt.getDirection();
                confidence = c2;
            }
            NyARDetectMarkerResult result = this.result_holder.result_array[i];
            result.arcode_id = code_index;
            result.confidence = confidence;
            result.direction = direction;
            result.ref_square = square;
        }
        return number_of_square;
    }

    public void getTransmationMatrix(int i_index, NyARTransMatResult o_result) throws NyARException {
        NyARDetectMarkerResult result = this.result_holder.result_array[i_index];
        if (this.is_continue) {
            this.transmat.transMatContinue(result.ref_square, result.direction, this.marker_width[result.arcode_id], o_result);
        } else {
            this.transmat.transMat(result.ref_square, result.direction, this.marker_width[result.arcode_id], o_result);
        }
    }

    public double getConfidence(int i_index) {
        return this.result_holder.result_array[i_index].confidence;
    }

    public int getDirection(int i_index) {
        return this.result_holder.result_array[i_index].direction;
    }

    public int getARCodeIndex(int i_index) {
        return this.result_holder.result_array[i_index].arcode_id;
    }

    public void setContinueMode(boolean i_is_continue) {
        this.is_continue = i_is_continue;
    }
}

