/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.jmf.utils;

import java.io.IOException;
import javax.media.CaptureDeviceInfo;
import javax.media.Control;
import javax.media.Time;
import javax.media.control.FormatControl;
import javax.media.protocol.CaptureDevice;
import javax.media.protocol.DataSource;
import javax.media.protocol.PushBufferDataSource;
import javax.media.protocol.PushBufferStream;
import jp.nyatla.nyartoolkit.jmf.utils.MonitorStream;

public class MonitorCDS
extends PushBufferDataSource {
    private PushBufferDataSource delegate = null;
    private PushBufferStream[] delStreams = null;
    private MonitorStream monitorStream = null;
    private PushBufferStream[] monitorStreams = null;
    boolean delStarted = false;
    private Control[] controls;

    public MonitorCDS(DataSource ds) {
        if (ds instanceof PushBufferDataSource) {
            this.delegate = (PushBufferDataSource)ds;
            this.delStreams = this.delegate.getStreams();
            this.monitorStream = new MonitorStream(this.delStreams[0], this);
            this.monitorStreams = new PushBufferStream[]{this.monitorStream};
        }
    }

    public Object[] getControls() {
        return this.controls;
    }

    public Object getControl(String value) {
        if (value.equals("jmfsample.MonitorStream") || value.equals("javax.media.control.MonitorControl")) {
            return this.monitorStream;
        }
        return null;
    }

    public CaptureDeviceInfo getCaptureDeviceInfo() {
        return ((CaptureDevice)this.delegate).getCaptureDeviceInfo();
    }

    public FormatControl[] getFormatControls() {
        return ((CaptureDevice)this.delegate).getFormatControls();
    }

    public String getContentType() {
        return this.delegate.getContentType();
    }

    public void connect() throws IOException {
        if (this.delegate == null) {
            throw new IOException("Incompatible DataSource");
        }
    }

    public void disconnect() {
        this.monitorStream.setEnabled(false);
        this.delegate.disconnect();
    }

    public synchronized void start() throws IOException {
        this.startDelegate();
        this.delStarted = true;
    }

    public synchronized void stop() throws IOException {
        if (!this.monitorStream.isEnabled()) {
            this.stopDelegate();
        }
        this.delStarted = false;
    }

    public Time getDuration() {
        return this.delegate.getDuration();
    }

    public PushBufferStream[] getStreams() {
        return this.monitorStreams;
    }

    void startDelegate() throws IOException {
        this.delegate.start();
    }

    void stopDelegate() throws IOException {
        this.delegate.stop();
    }
}

