package jp.ac.kyutech.ai.ylab.shiva.nativecapable.plugin;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.console.AbstractConsole;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

/**
 * The activator class controls the plug-in life cycle
 */
public class NativeCapableJavaPlugin extends AbstractUIPlugin {

	// The plug-in ID
	public static final String PLUGIN_ID = "NativeCapableJavaPlugin";

	// The shared instance
	private static NativeCapableJavaPlugin plugin;

	private static MessageConsoleStream consoleStream;

	public static final String NATURE_ID = "jp.ac.kyutech.ai.ylab.shiva.nativecapable.nature";

	/**
	 * The constructor
	 */
	public NativeCapableJavaPlugin() {

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.plugin.AbstractUIPlugin#start(org.osgi.framework.BundleContext)
	 */
	public void start(BundleContext context) throws Exception {
		super.start(context);
		plugin = this;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.plugin.AbstractUIPlugin#stop(org.osgi.framework.BundleContext)
	 */
	public void stop(BundleContext context) throws Exception {
		plugin = null;
		super.stop(context);
	}

	/**
	 * Returns the shared instance
	 * 
	 * @return the shared instance
	 */
	public static NativeCapableJavaPlugin getDefault() {

		return plugin;
	}

	/**
	 * Returns an image descriptor for the image file at the given plug-in
	 * relative path
	 * 
	 * @param path
	 *            the path
	 * @return the image descriptor
	 */
	public static ImageDescriptor getImageDescriptor(String path) {
		return imageDescriptorFromPlugin(PLUGIN_ID, path);
	}

	public static MessageConsoleStream getConsoleStream() {
		if (consoleStream == null) {
			MessageConsole console = new MessageConsole("Native Capable Java",
					null);
			consoleStream = console.newMessageStream();
			IConsoleManager manager = ConsolePlugin.getDefault()
					.getConsoleManager();
			manager.addConsoles(new AbstractConsole[] { console });
			manager.showConsoleView(console);
		}
		return consoleStream;
	}

}
