/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.processor;

import jp.nyatla.nyartoolkit.NyARException;
import jp.nyatla.nyartoolkit.core.NyARCode;
import jp.nyatla.nyartoolkit.core.analyzer.raster.threshold.NyARRasterThresholdAnalyzer_SlidePTile;
import jp.nyatla.nyartoolkit.core.match.NyARMatchPattDeviationColorData;
import jp.nyatla.nyartoolkit.core.match.NyARMatchPattResult;
import jp.nyatla.nyartoolkit.core.match.NyARMatchPatt_Color_WITHOUT_PCA;
import jp.nyatla.nyartoolkit.core.param.NyARParam;
import jp.nyatla.nyartoolkit.core.pickup.INyARColorPatt;
import jp.nyatla.nyartoolkit.core.pickup.NyARColorPatt_Perspective_O2;
import jp.nyatla.nyartoolkit.core.raster.NyARBinRaster;
import jp.nyatla.nyartoolkit.core.raster.rgb.INyARRgbRaster;
import jp.nyatla.nyartoolkit.core.rasterfilter.rgb2bin.NyARRasterFilter_ARToolkitThreshold;
import jp.nyatla.nyartoolkit.core.squaredetect.NyARCoord2Linear;
import jp.nyatla.nyartoolkit.core.squaredetect.NyARSquare;
import jp.nyatla.nyartoolkit.core.squaredetect.NyARSquareContourDetector;
import jp.nyatla.nyartoolkit.core.squaredetect.NyARSquareContourDetector_Rle;
import jp.nyatla.nyartoolkit.core.transmat.INyARTransMat;
import jp.nyatla.nyartoolkit.core.transmat.NyARRectOffset;
import jp.nyatla.nyartoolkit.core.transmat.NyARTransMat;
import jp.nyatla.nyartoolkit.core.transmat.NyARTransMatResult;
import jp.nyatla.nyartoolkit.core.types.NyARIntPoint2d;
import jp.nyatla.nyartoolkit.core.types.NyARIntSize;
import jp.nyatla.nyartoolkit.core.types.NyARLinear;

public abstract class SingleARMarkerProcesser {
    public Object tag;
    private int _lost_delay_count = 0;
    private int _lost_delay = 5;
    private NyARSquareContourDetector _square_detect;
    protected INyARTransMat _transmat;
    private NyARRectOffset _offset;
    private int _threshold = 110;
    private NyARBinRaster _bin_raster;
    private NyARRasterFilter_ARToolkitThreshold _tobin_filter;
    protected int _current_arcode_index = -1;
    private NyARRasterThresholdAnalyzer_SlidePTile _threshold_detect;
    private boolean _initialized = false;
    private DetectSquareCB _detectmarker_cb;
    private NyARTransMatResult __NyARSquare_result = new NyARTransMatResult();

    protected SingleARMarkerProcesser() {
    }

    protected void initInstance(NyARParam i_param, int i_raster_type) throws NyARException {
        assert (!this._initialized);
        NyARIntSize scr_size = i_param.getScreenSize();
        this._square_detect = new NyARSquareContourDetector_Rle(i_param.getDistortionFactor(), scr_size);
        this._transmat = new NyARTransMat(i_param);
        this._tobin_filter = new NyARRasterFilter_ARToolkitThreshold(110, i_raster_type);
        this._bin_raster = new NyARBinRaster(scr_size.w, scr_size.h);
        this._threshold_detect = new NyARRasterThresholdAnalyzer_SlidePTile(15, i_raster_type, 4);
        this._initialized = true;
        this._detectmarker_cb = new DetectSquareCB(i_param);
        this._offset = new NyARRectOffset();
    }

    public void setARCodeTable(NyARCode[] i_ref_code_table, int i_code_resolution, double i_marker_width) {
        if (this._current_arcode_index != -1) {
            this.reset(true);
        }
        this._detectmarker_cb.setNyARCodeTable(i_ref_code_table, i_code_resolution);
        this._offset.setSquare(i_marker_width);
    }

    public void reset(boolean i_is_force) {
        if (this._current_arcode_index != -1 && !i_is_force) {
            this.onLeaveHandler();
        }
        this._current_arcode_index = -1;
    }

    public void detectMarker(INyARRgbRaster i_raster) throws NyARException {
        assert (this._bin_raster.getSize().isEqualSize(i_raster.getSize().w, i_raster.getSize().h));
        this._tobin_filter.setThreshold(this._threshold);
        this._tobin_filter.doFilter(i_raster, this._bin_raster);
        this._detectmarker_cb.init(i_raster, this._current_arcode_index);
        this._square_detect.detectMarkerCB(this._bin_raster, this._detectmarker_cb);
        boolean is_id_found = this.updateStatus(this._detectmarker_cb.square, this._detectmarker_cb.code_index);
        if (!is_id_found) {
            int th = this._threshold_detect.analyzeRaster(i_raster);
            this._threshold = (this._threshold + th) / 2;
        }
    }

    public void setConfidenceThreshold(double i_new_cf, double i_exist_cf) {
        this._detectmarker_cb.cf_threshold_exist = i_exist_cf;
        this._detectmarker_cb.cf_threshold_new = i_new_cf;
    }

    private boolean updateStatus(NyARSquare i_square, int i_code_index) throws NyARException {
        NyARTransMatResult result = this.__NyARSquare_result;
        if (this._current_arcode_index < 0) {
            if (i_code_index < 0) {
                return false;
            }
            this._current_arcode_index = i_code_index;
            this.onEnterHandler(i_code_index);
            this._transmat.transMat(i_square, this._offset, result);
            this.onUpdateHandler(i_square, result);
            this._lost_delay_count = 0;
            return true;
        }
        if (i_code_index < 0) {
            ++this._lost_delay_count;
            if (this._lost_delay < this._lost_delay_count) {
                this._current_arcode_index = -1;
                this.onLeaveHandler();
            }
            return false;
        }
        if (i_code_index == this._current_arcode_index) {
            this._transmat.transMatContinue(i_square, this._offset, result);
            this.onUpdateHandler(i_square, result);
            this._lost_delay_count = 0;
            return true;
        }
        throw new NyARException();
    }

    protected abstract void onEnterHandler(int var1);

    protected abstract void onLeaveHandler();

    protected abstract void onUpdateHandler(NyARSquare var1, NyARTransMatResult var2);

    private class DetectSquareCB
    implements NyARSquareContourDetector.IDetectMarkerCallback {
        public final NyARSquare square = new NyARSquare();
        public double confidence = 0.0;
        public int code_index = -1;
        public double cf_threshold_new = 0.5;
        public double cf_threshold_exist = 0.3;
        private INyARRgbRaster _ref_raster;
        private INyARColorPatt _inst_patt;
        private NyARMatchPattDeviationColorData _deviation_data;
        private NyARMatchPatt_Color_WITHOUT_PCA[] _match_patt = null;
        private final NyARMatchPattResult __detectMarkerLite_mr = new NyARMatchPattResult();
        private NyARCoord2Linear _coordline;
        private NyARIntPoint2d[] __tmp_vertex = NyARIntPoint2d.createArray(4);
        private int _target_id;

        public DetectSquareCB(NyARParam i_param) {
            this._coordline = new NyARCoord2Linear(i_param.getScreenSize(), i_param.getDistortionFactor());
        }

        public void setNyARCodeTable(NyARCode[] i_ref_code, int i_code_resolution) {
            this._deviation_data = new NyARMatchPattDeviationColorData(i_code_resolution, i_code_resolution);
            this._inst_patt = new NyARColorPatt_Perspective_O2(i_code_resolution, i_code_resolution, 4, 25);
            this._match_patt = new NyARMatchPatt_Color_WITHOUT_PCA[i_ref_code.length];
            int i = 0;
            while (i < i_ref_code.length) {
                this._match_patt[i] = new NyARMatchPatt_Color_WITHOUT_PCA(i_ref_code[i]);
                ++i;
            }
        }

        public void init(INyARRgbRaster i_raster, int i_target_id) {
            this._ref_raster = i_raster;
            this._target_id = i_target_id;
            this.code_index = -1;
            this.confidence = Double.MIN_NORMAL;
        }

        public void onSquareDetect(NyARSquareContourDetector i_sender, int[] i_coordx, int[] i_coordy, int i_coor_num, int[] i_vertex_index) throws NyARException {
            if (this._match_patt == null) {
                return;
            }
            NyARIntPoint2d[] vertex = this.__tmp_vertex;
            vertex[0].x = i_coordx[i_vertex_index[0]];
            vertex[0].y = i_coordy[i_vertex_index[0]];
            vertex[1].x = i_coordx[i_vertex_index[1]];
            vertex[1].y = i_coordy[i_vertex_index[1]];
            vertex[2].x = i_coordx[i_vertex_index[2]];
            vertex[2].y = i_coordy[i_vertex_index[2]];
            vertex[3].x = i_coordx[i_vertex_index[3]];
            vertex[3].y = i_coordy[i_vertex_index[3]];
            if (!this._inst_patt.pickFromRaster(this._ref_raster, vertex)) {
                return;
            }
            this._deviation_data.setRaster(this._inst_patt);
            NyARMatchPattResult mr = this.__detectMarkerLite_mr;
            int lcode_index = 0;
            int dir = 0;
            double c1 = 0.0;
            int i = 0;
            while (i < this._match_patt.length) {
                this._match_patt[i].evaluate(this._deviation_data, mr);
                double c2 = mr.confidence;
                if (c1 < c2) {
                    lcode_index = i;
                    c1 = c2;
                    dir = mr.direction;
                }
                ++i;
            }
            if (this._target_id == -1) {
                if (c1 < this.cf_threshold_new) {
                    return;
                }
                if (this.confidence > c1) {
                    return;
                }
                this.code_index = lcode_index;
            } else {
                if (lcode_index != this._target_id) {
                    return;
                }
                if (c1 < this.cf_threshold_exist) {
                    return;
                }
                if (this.confidence > c1) {
                    return;
                }
                this.code_index = this._target_id;
            }
            this.confidence = c1;
            NyARSquare sq = this.square;
            int i2 = 0;
            while (i2 < 4) {
                int idx = (i2 + 4 - dir) % 4;
                this._coordline.coord2Line(i_vertex_index[idx], i_vertex_index[(idx + 1) % 4], i_coordx, i_coordy, i_coor_num, sq.line[i2]);
                ++i2;
            }
            i2 = 0;
            while (i2 < 4) {
                if (!NyARLinear.crossPos(sq.line[i2], sq.line[(i2 + 3) % 4], sq.sqvertex[i2])) {
                    throw new NyARException();
                }
                ++i2;
            }
        }
    }
}

