/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.processor;

import jp.nyatla.nyartoolkit.NyARException;
import jp.nyatla.nyartoolkit.core.analyzer.raster.threshold.NyARRasterThresholdAnalyzer_SlidePTile;
import jp.nyatla.nyartoolkit.core.param.NyARParam;
import jp.nyatla.nyartoolkit.core.raster.NyARBinRaster;
import jp.nyatla.nyartoolkit.core.raster.rgb.INyARRgbRaster;
import jp.nyatla.nyartoolkit.core.rasterfilter.rgb2bin.NyARRasterFilter_ARToolkitThreshold;
import jp.nyatla.nyartoolkit.core.squaredetect.NyARCoord2Linear;
import jp.nyatla.nyartoolkit.core.squaredetect.NyARSquare;
import jp.nyatla.nyartoolkit.core.squaredetect.NyARSquareContourDetector;
import jp.nyatla.nyartoolkit.core.squaredetect.NyARSquareContourDetector_Rle;
import jp.nyatla.nyartoolkit.core.transmat.INyARTransMat;
import jp.nyatla.nyartoolkit.core.transmat.NyARRectOffset;
import jp.nyatla.nyartoolkit.core.transmat.NyARTransMat;
import jp.nyatla.nyartoolkit.core.transmat.NyARTransMatResult;
import jp.nyatla.nyartoolkit.core.types.NyARIntPoint2d;
import jp.nyatla.nyartoolkit.core.types.NyARIntSize;
import jp.nyatla.nyartoolkit.core.types.NyARLinear;
import jp.nyatla.nyartoolkit.nyidmarker.NyIdMarkerParam;
import jp.nyatla.nyartoolkit.nyidmarker.NyIdMarkerPattern;
import jp.nyatla.nyartoolkit.nyidmarker.NyIdMarkerPickup;
import jp.nyatla.nyartoolkit.nyidmarker.data.INyIdMarkerData;
import jp.nyatla.nyartoolkit.nyidmarker.data.INyIdMarkerDataEncoder;

public abstract class SingleNyIdMarkerProcesser {
    public Object tag;
    private int _lost_delay_count = 0;
    private int _lost_delay = 5;
    private NyARSquareContourDetector_Rle _square_detect;
    protected INyARTransMat _transmat;
    private NyARRectOffset _offset;
    private boolean _is_active;
    private int _current_threshold = 110;
    private NyARBinRaster _bin_raster;
    private NyARRasterFilter_ARToolkitThreshold _tobin_filter;
    private DetectSquareCB _callback;
    private INyIdMarkerData _data_current;
    private boolean _initialized = false;
    private NyARRasterThresholdAnalyzer_SlidePTile _threshold_detect;
    private NyARTransMatResult __NyARSquare_result = new NyARTransMatResult();

    protected SingleNyIdMarkerProcesser() {
    }

    protected void initInstance(NyARParam i_param, INyIdMarkerDataEncoder i_encoder, int i_marker_width, int i_raster_format) throws NyARException {
        assert (!this._initialized);
        NyARIntSize scr_size = i_param.getScreenSize();
        this._square_detect = new NyARSquareContourDetector_Rle(i_param.getDistortionFactor(), scr_size);
        this._transmat = new NyARTransMat(i_param);
        this._callback = new DetectSquareCB(i_param, i_encoder);
        this._bin_raster = new NyARBinRaster(scr_size.w, scr_size.h);
        this._data_current = i_encoder.createDataInstance();
        this._tobin_filter = new NyARRasterFilter_ARToolkitThreshold(110, i_raster_format);
        this._threshold_detect = new NyARRasterThresholdAnalyzer_SlidePTile(15, i_raster_format, 4);
        this._initialized = true;
        this._is_active = false;
        this._offset = new NyARRectOffset();
        this._offset.setSquare(i_marker_width);
    }

    public void setMarkerWidth(int i_width) {
        this._offset.setSquare(i_width);
    }

    public void reset(boolean i_is_force) {
        if (!i_is_force && this._is_active) {
            this.onLeaveHandler();
        }
        this._is_active = false;
    }

    public void detectMarker(INyARRgbRaster i_raster) throws NyARException {
        if (!this._bin_raster.getSize().isEqualSize(i_raster.getSize().w, i_raster.getSize().h)) {
            throw new NyARException();
        }
        this._tobin_filter.setThreshold(this._current_threshold);
        this._tobin_filter.doFilter(i_raster, this._bin_raster);
        this._callback.init(i_raster, this._is_active ? this._data_current : null);
        this._square_detect.detectMarkerCB(this._bin_raster, this._callback);
        boolean is_id_found = this.updateStatus(this._callback.square, this._callback.marker_data);
        if (is_id_found) {
            this._current_threshold = (this._current_threshold + this._callback.threshold) / 2;
        } else {
            int th = this._threshold_detect.analyzeRaster(i_raster);
            this._current_threshold = (this._current_threshold + th) / 2;
        }
    }

    private boolean updateStatus(NyARSquare i_square, INyIdMarkerData i_marker_data) throws NyARException {
        boolean is_id_found = false;
        NyARTransMatResult result = this.__NyARSquare_result;
        if (!this._is_active) {
            if (i_marker_data == null) {
                this._is_active = false;
            } else {
                this._data_current.copyFrom(i_marker_data);
                this.onEnterHandler(this._data_current);
                this._transmat.transMat(i_square, this._offset, result);
                this.onUpdateHandler(i_square, result);
                this._lost_delay_count = 0;
                this._is_active = true;
                is_id_found = true;
            }
        } else if (i_marker_data == null) {
            ++this._lost_delay_count;
            if (this._lost_delay < this._lost_delay_count) {
                this.onLeaveHandler();
                this._is_active = false;
            }
        } else if (this._data_current.isEqual(i_marker_data)) {
            this._transmat.transMatContinue(i_square, this._offset, result);
            this.onUpdateHandler(i_square, result);
            this._lost_delay_count = 0;
            is_id_found = true;
        } else {
            throw new NyARException();
        }
        return is_id_found;
    }

    protected abstract void onEnterHandler(INyIdMarkerData var1);

    protected abstract void onLeaveHandler();

    protected abstract void onUpdateHandler(NyARSquare var1, NyARTransMatResult var2);

    private class DetectSquareCB
    implements NyARSquareContourDetector.IDetectMarkerCallback {
        public final NyARSquare square = new NyARSquare();
        public INyIdMarkerData marker_data;
        public int threshold;
        private INyARRgbRaster _ref_raster;
        private INyIdMarkerData _current_data;
        private final NyIdMarkerPickup _id_pickup = new NyIdMarkerPickup();
        private NyARCoord2Linear _coordline;
        private INyIdMarkerDataEncoder _encoder;
        private INyIdMarkerData _data_temp;
        private INyIdMarkerData _prev_data;
        private NyARIntPoint2d[] __tmp_vertex = NyARIntPoint2d.createArray(4);
        private final NyIdMarkerParam _marker_param = new NyIdMarkerParam();
        private final NyIdMarkerPattern _marker_data = new NyIdMarkerPattern();

        public DetectSquareCB(NyARParam i_param, INyIdMarkerDataEncoder i_encoder) {
            this._coordline = new NyARCoord2Linear(i_param.getScreenSize(), i_param.getDistortionFactor());
            this._data_temp = i_encoder.createDataInstance();
            this._current_data = i_encoder.createDataInstance();
            this._encoder = i_encoder;
        }

        public void init(INyARRgbRaster i_raster, INyIdMarkerData i_prev_data) {
            this.marker_data = null;
            this._prev_data = i_prev_data;
            this._ref_raster = i_raster;
        }

        public void onSquareDetect(NyARSquareContourDetector i_sender, int[] i_coordx, int[] i_coordy, int i_coor_num, int[] i_vertex_index) throws NyARException {
            if (this.marker_data != null) {
                return;
            }
            NyARIntPoint2d[] vertex = this.__tmp_vertex;
            vertex[0].x = i_coordx[i_vertex_index[0]];
            vertex[0].y = i_coordy[i_vertex_index[0]];
            vertex[1].x = i_coordx[i_vertex_index[1]];
            vertex[1].y = i_coordy[i_vertex_index[1]];
            vertex[2].x = i_coordx[i_vertex_index[2]];
            vertex[2].y = i_coordy[i_vertex_index[2]];
            vertex[3].x = i_coordx[i_vertex_index[3]];
            vertex[3].y = i_coordy[i_vertex_index[3]];
            NyIdMarkerPattern patt_data = this._marker_data;
            NyIdMarkerParam param = this._marker_param;
            if (!this._id_pickup.pickFromRaster(this._ref_raster, vertex, patt_data, param)) {
                return;
            }
            if (!this._encoder.encode(patt_data, this._data_temp)) {
                return;
            }
            if (this._prev_data == null) {
                this._current_data.copyFrom(this._data_temp);
            } else if (!this._prev_data.isEqual(this._data_temp)) {
                return;
            }
            NyARSquare sq = this.square;
            int i = 0;
            while (i < 4) {
                int idx = (i + 4 - param.direction) % 4;
                this._coordline.coord2Line(i_vertex_index[idx], i_vertex_index[(idx + 1) % 4], i_coordx, i_coordy, i_coor_num, sq.line[i]);
                ++i;
            }
            i = 0;
            while (i < 4) {
                if (!NyARLinear.crossPos(sq.line[i], sq.line[(i + 3) % 4], sq.sqvertex[i])) {
                    throw new NyARException();
                }
                ++i;
            }
            this.threshold = param.threshold;
            this.marker_data = this._current_data;
        }
    }
}

