/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.analyzer.raster;

import jp.nyatla.nyartoolkit.NyARException;
import jp.nyatla.nyartoolkit.core.raster.INyARRaster;
import jp.nyatla.nyartoolkit.core.types.NyARHistogram;
import jp.nyatla.nyartoolkit.core.types.NyARIntSize;

public class NyARRasterAnalyzer_Histogram {
    protected ICreateHistogramImpl _histImpl;
    protected int _vertical_skip;

    public NyARRasterAnalyzer_Histogram(int i_raster_format, int i_vertical_interval) throws NyARException {
        if (!this.initInstance(i_raster_format, i_vertical_interval)) {
            throw new NyARException();
        }
    }

    protected boolean initInstance(int i_raster_format, int i_vertical_interval) {
        switch (i_raster_format) {
            case 65537: 
            case 65538: {
                this._histImpl = new NyARRasterThresholdAnalyzer_Histogram_BYTE1D_RGB_24();
                break;
            }
            case 262145: {
                this._histImpl = new NyARRasterThresholdAnalyzer_Histogram_INT1D_GRAY_8();
                break;
            }
            case 65793: {
                this._histImpl = new NyARRasterThresholdAnalyzer_Histogram_BYTE1D_B8G8R8X8_32();
                break;
            }
            case 65794: {
                this._histImpl = new NyARRasterThresholdAnalyzer_Histogram_BYTE1D_X8R8G8B8_32();
                break;
            }
            case 197121: {
                this._histImpl = new NyARRasterThresholdAnalyzer_Histogram_WORD1D_R5G6B5_16LE();
                break;
            }
            case 262402: {
                this._histImpl = new NyARRasterThresholdAnalyzer_Histogram_INT1D_X8R8G8B8_32();
                break;
            }
            default: {
                return false;
            }
        }
        this._vertical_skip = i_vertical_interval;
        return true;
    }

    public void setVerticalInterval(int i_step) {
        this._vertical_skip = i_step;
    }

    public int analyzeRaster(INyARRaster i_input, NyARHistogram o_histogram) throws NyARException {
        NyARIntSize size = i_input.getSize();
        assert (size.w * size.h < 0x40000000);
        assert (o_histogram.length == 256);
        int[] h = o_histogram.data;
        int i = o_histogram.length - 1;
        while (i >= 0) {
            h[i] = 0;
            --i;
        }
        o_histogram.total_of_data = size.w * size.h / this._vertical_skip;
        return this._histImpl.createHistogram(i_input, size, h, this._vertical_skip);
    }

    static interface ICreateHistogramImpl {
        public int createHistogram(INyARRaster var1, NyARIntSize var2, int[] var3, int var4);
    }

    class NyARRasterThresholdAnalyzer_Histogram_BYTE1D_B8G8R8X8_32
    implements ICreateHistogramImpl {
        NyARRasterThresholdAnalyzer_Histogram_BYTE1D_B8G8R8X8_32() {
        }

        public int createHistogram(INyARRaster i_reader, NyARIntSize i_size, int[] o_histogram, int i_skip) {
            assert (i_reader.isEqualBufferType(65793));
            byte[] input = (byte[])i_reader.getBuffer();
            int pix_count = i_size.w;
            int pix_mod_part = pix_count - pix_count % 8;
            int y = i_size.h - 1;
            while (y >= 0) {
                int v;
                int pt = y * i_size.w * 4;
                int x = pix_count - 1;
                while (x >= pix_mod_part) {
                    int n = v = ((input[pt + 0] & 0xFF) + (input[pt + 1] & 0xFF) + (input[pt + 2] & 0xFF)) / 3;
                    o_histogram[n] = o_histogram[n] + 1;
                    pt += 4;
                    --x;
                }
                while (x >= 0) {
                    int n = v = ((input[pt + 0] & 0xFF) + (input[pt + 1] & 0xFF) + (input[pt + 2] & 0xFF)) / 3;
                    o_histogram[n] = o_histogram[n] + 1;
                    int n2 = v = ((input[pt + 4] & 0xFF) + (input[pt + 5] & 0xFF) + (input[pt + 6] & 0xFF)) / 3;
                    o_histogram[n2] = o_histogram[n2] + 1;
                    int n3 = v = ((input[pt + 8] & 0xFF) + (input[pt + 9] & 0xFF) + (input[pt + 10] & 0xFF)) / 3;
                    o_histogram[n3] = o_histogram[n3] + 1;
                    int n4 = v = ((input[pt + 12] & 0xFF) + (input[pt + 13] & 0xFF) + (input[pt + 14] & 0xFF)) / 3;
                    o_histogram[n4] = o_histogram[n4] + 1;
                    int n5 = v = ((input[pt + 16] & 0xFF) + (input[pt + 17] & 0xFF) + (input[pt + 18] & 0xFF)) / 3;
                    o_histogram[n5] = o_histogram[n5] + 1;
                    int n6 = v = ((input[pt + 20] & 0xFF) + (input[pt + 21] & 0xFF) + (input[pt + 22] & 0xFF)) / 3;
                    o_histogram[n6] = o_histogram[n6] + 1;
                    int n7 = v = ((input[pt + 24] & 0xFF) + (input[pt + 25] & 0xFF) + (input[pt + 26] & 0xFF)) / 3;
                    o_histogram[n7] = o_histogram[n7] + 1;
                    int n8 = v = ((input[pt + 28] & 0xFF) + (input[pt + 29] & 0xFF) + (input[pt + 30] & 0xFF)) / 3;
                    o_histogram[n8] = o_histogram[n8] + 1;
                    pt += 32;
                    x -= 8;
                }
                y -= i_skip;
            }
            return i_size.w * i_size.h;
        }
    }

    class NyARRasterThresholdAnalyzer_Histogram_BYTE1D_RGB_24
    implements ICreateHistogramImpl {
        NyARRasterThresholdAnalyzer_Histogram_BYTE1D_RGB_24() {
        }

        public int createHistogram(INyARRaster i_reader, NyARIntSize i_size, int[] o_histogram, int i_skip) {
            assert (i_reader.isEqualBufferType(65538) || i_reader.isEqualBufferType(65537));
            byte[] input = (byte[])i_reader.getBuffer();
            int pix_count = i_size.w;
            int pix_mod_part = pix_count - pix_count % 8;
            int y = i_size.h - 1;
            while (y >= 0) {
                int v;
                int pt = y * i_size.w * 3;
                int x = pix_count - 1;
                while (x >= pix_mod_part) {
                    int n = v = ((input[pt + 0] & 0xFF) + (input[pt + 1] & 0xFF) + (input[pt + 2] & 0xFF)) / 3;
                    o_histogram[n] = o_histogram[n] + 1;
                    pt += 3;
                    --x;
                }
                while (x >= 0) {
                    int n = v = ((input[pt + 0] & 0xFF) + (input[pt + 1] & 0xFF) + (input[pt + 2] & 0xFF)) / 3;
                    o_histogram[n] = o_histogram[n] + 1;
                    int n2 = v = ((input[pt + 3] & 0xFF) + (input[pt + 4] & 0xFF) + (input[pt + 5] & 0xFF)) / 3;
                    o_histogram[n2] = o_histogram[n2] + 1;
                    int n3 = v = ((input[pt + 6] & 0xFF) + (input[pt + 7] & 0xFF) + (input[pt + 8] & 0xFF)) / 3;
                    o_histogram[n3] = o_histogram[n3] + 1;
                    int n4 = v = ((input[pt + 9] & 0xFF) + (input[pt + 10] & 0xFF) + (input[pt + 11] & 0xFF)) / 3;
                    o_histogram[n4] = o_histogram[n4] + 1;
                    int n5 = v = ((input[pt + 12] & 0xFF) + (input[pt + 13] & 0xFF) + (input[pt + 14] & 0xFF)) / 3;
                    o_histogram[n5] = o_histogram[n5] + 1;
                    int n6 = v = ((input[pt + 15] & 0xFF) + (input[pt + 16] & 0xFF) + (input[pt + 17] & 0xFF)) / 3;
                    o_histogram[n6] = o_histogram[n6] + 1;
                    int n7 = v = ((input[pt + 18] & 0xFF) + (input[pt + 19] & 0xFF) + (input[pt + 20] & 0xFF)) / 3;
                    o_histogram[n7] = o_histogram[n7] + 1;
                    int n8 = v = ((input[pt + 21] & 0xFF) + (input[pt + 22] & 0xFF) + (input[pt + 23] & 0xFF)) / 3;
                    o_histogram[n8] = o_histogram[n8] + 1;
                    pt += 24;
                    x -= 8;
                }
                y -= i_skip;
            }
            return i_size.w * i_size.h;
        }
    }

    class NyARRasterThresholdAnalyzer_Histogram_BYTE1D_X8R8G8B8_32
    implements ICreateHistogramImpl {
        NyARRasterThresholdAnalyzer_Histogram_BYTE1D_X8R8G8B8_32() {
        }

        public int createHistogram(INyARRaster i_reader, NyARIntSize i_size, int[] o_histogram, int i_skip) {
            assert (i_reader.isEqualBufferType(65794));
            byte[] input = (byte[])i_reader.getBuffer();
            int pix_count = i_size.w;
            int pix_mod_part = pix_count - pix_count % 8;
            int y = i_size.h - 1;
            while (y >= 0) {
                int v;
                int pt = y * i_size.w * 4;
                int x = pix_count - 1;
                while (x >= pix_mod_part) {
                    int n = v = ((input[pt + 1] & 0xFF) + (input[pt + 2] & 0xFF) + (input[pt + 3] & 0xFF)) / 3;
                    o_histogram[n] = o_histogram[n] + 1;
                    pt += 4;
                    --x;
                }
                while (x >= 0) {
                    int n = v = ((input[pt + 1] & 0xFF) + (input[pt + 2] & 0xFF) + (input[pt + 3] & 0xFF)) / 3;
                    o_histogram[n] = o_histogram[n] + 1;
                    int n2 = v = ((input[pt + 5] & 0xFF) + (input[pt + 6] & 0xFF) + (input[pt + 7] & 0xFF)) / 3;
                    o_histogram[n2] = o_histogram[n2] + 1;
                    int n3 = v = ((input[pt + 9] & 0xFF) + (input[pt + 10] & 0xFF) + (input[pt + 11] & 0xFF)) / 3;
                    o_histogram[n3] = o_histogram[n3] + 1;
                    int n4 = v = ((input[pt + 13] & 0xFF) + (input[pt + 14] & 0xFF) + (input[pt + 15] & 0xFF)) / 3;
                    o_histogram[n4] = o_histogram[n4] + 1;
                    int n5 = v = ((input[pt + 17] & 0xFF) + (input[pt + 18] & 0xFF) + (input[pt + 19] & 0xFF)) / 3;
                    o_histogram[n5] = o_histogram[n5] + 1;
                    int n6 = v = ((input[pt + 21] & 0xFF) + (input[pt + 22] & 0xFF) + (input[pt + 23] & 0xFF)) / 3;
                    o_histogram[n6] = o_histogram[n6] + 1;
                    int n7 = v = ((input[pt + 25] & 0xFF) + (input[pt + 26] & 0xFF) + (input[pt + 27] & 0xFF)) / 3;
                    o_histogram[n7] = o_histogram[n7] + 1;
                    int n8 = v = ((input[pt + 29] & 0xFF) + (input[pt + 30] & 0xFF) + (input[pt + 31] & 0xFF)) / 3;
                    o_histogram[n8] = o_histogram[n8] + 1;
                    pt += 32;
                    x -= 8;
                }
                y -= i_skip;
            }
            return i_size.w * i_size.h;
        }
    }

    class NyARRasterThresholdAnalyzer_Histogram_INT1D_GRAY_8
    implements ICreateHistogramImpl {
        NyARRasterThresholdAnalyzer_Histogram_INT1D_GRAY_8() {
        }

        public int createHistogram(INyARRaster i_reader, NyARIntSize i_size, int[] o_histogram, int i_skip) {
            assert (i_reader.isEqualBufferType(262145));
            int[] input = (int[])i_reader.getBuffer();
            int y = i_size.h - 1;
            while (y >= 0) {
                int pt = y * i_size.w;
                int x = i_size.w - 1;
                while (x >= 0) {
                    int n = input[pt];
                    o_histogram[n] = o_histogram[n] + 1;
                    ++pt;
                    --x;
                }
                y -= i_skip;
            }
            return i_size.w * i_size.h;
        }
    }

    class NyARRasterThresholdAnalyzer_Histogram_INT1D_X8R8G8B8_32
    implements ICreateHistogramImpl {
        NyARRasterThresholdAnalyzer_Histogram_INT1D_X8R8G8B8_32() {
        }

        public int createHistogram(INyARRaster i_reader, NyARIntSize i_size, int[] o_histogram, int i_skip) {
            assert (i_reader.isEqualBufferType(262402));
            int[] input = (int[])i_reader.getBuffer();
            int y = i_size.h - 1;
            while (y >= 0) {
                int pt = y * i_size.w;
                int x = i_size.w - 1;
                while (x >= 0) {
                    int p = input[pt];
                    int n = ((p & 0xFF) + (p & 0xFF) + (p & 0xFF)) / 3;
                    o_histogram[n] = o_histogram[n] + 1;
                    ++pt;
                    --x;
                }
                y -= i_skip;
            }
            return i_size.w * i_size.h;
        }
    }

    class NyARRasterThresholdAnalyzer_Histogram_WORD1D_R5G6B5_16LE
    implements ICreateHistogramImpl {
        NyARRasterThresholdAnalyzer_Histogram_WORD1D_R5G6B5_16LE() {
        }

        public int createHistogram(INyARRaster i_reader, NyARIntSize i_size, int[] o_histogram, int i_skip) {
            assert (i_reader.isEqualBufferType(197121));
            short[] input = (short[])i_reader.getBuffer();
            int pix_count = i_size.w;
            int pix_mod_part = pix_count - pix_count % 8;
            int y = i_size.h - 1;
            while (y >= 0) {
                int v;
                int pt = y * i_size.w;
                int x = pix_count - 1;
                while (x >= pix_mod_part) {
                    v = input[pt];
                    int n = v = (((v & 0xF800) >> 8) + ((v & 0x7E0) >> 3) + ((v & 0x1F) << 3)) / 3;
                    o_histogram[n] = o_histogram[n] + 1;
                    ++pt;
                    --x;
                }
                while (x >= 0) {
                    v = input[pt];
                    int n = v = (((v & 0xF800) >> 8) + ((v & 0x7E0) >> 3) + ((v & 0x1F) << 3)) / 3;
                    o_histogram[n] = o_histogram[n] + 1;
                    v = input[++pt];
                    int n2 = v = (((v & 0xF800) >> 8) + ((v & 0x7E0) >> 3) + ((v & 0x1F) << 3)) / 3;
                    o_histogram[n2] = o_histogram[n2] + 1;
                    v = input[++pt];
                    int n3 = v = (((v & 0xF800) >> 8) + ((v & 0x7E0) >> 3) + ((v & 0x1F) << 3)) / 3;
                    o_histogram[n3] = o_histogram[n3] + 1;
                    v = input[++pt];
                    int n4 = v = (((v & 0xF800) >> 8) + ((v & 0x7E0) >> 3) + ((v & 0x1F) << 3)) / 3;
                    o_histogram[n4] = o_histogram[n4] + 1;
                    v = input[++pt];
                    int n5 = v = (((v & 0xF800) >> 8) + ((v & 0x7E0) >> 3) + ((v & 0x1F) << 3)) / 3;
                    o_histogram[n5] = o_histogram[n5] + 1;
                    v = input[++pt];
                    int n6 = v = (((v & 0xF800) >> 8) + ((v & 0x7E0) >> 3) + ((v & 0x1F) << 3)) / 3;
                    o_histogram[n6] = o_histogram[n6] + 1;
                    v = input[++pt];
                    int n7 = v = (((v & 0xF800) >> 8) + ((v & 0x7E0) >> 3) + ((v & 0x1F) << 3)) / 3;
                    o_histogram[n7] = o_histogram[n7] + 1;
                    v = input[++pt];
                    ++pt;
                    int n8 = v = (((v & 0xF800) >> 8) + ((v & 0x7E0) >> 3) + ((v & 0x1F) << 3)) / 3;
                    o_histogram[n8] = o_histogram[n8] + 1;
                    x -= 8;
                }
                y -= i_skip;
            }
            return i_size.w * i_size.h;
        }
    }
}

