/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.rasterreader;

import jp.nyatla.nyartoolkit.NyARException;
import jp.nyatla.nyartoolkit.core.rasterreader.INyARRgbPixelReader;
import jp.nyatla.nyartoolkit.core.types.NyARIntSize;

public final class NyARRgbPixelReader_INT1D_X8R8G8B8_32
implements INyARRgbPixelReader {
    protected int[] _ref_buf;
    private NyARIntSize _size;

    public NyARRgbPixelReader_INT1D_X8R8G8B8_32(int[] i_buf, NyARIntSize i_size) {
        this._ref_buf = i_buf;
        this._size = i_size;
    }

    @Override
    public void getPixel(int i_x, int i_y, int[] o_rgb) {
        int rgb = this._ref_buf[i_x + i_y * this._size.w];
        o_rgb[0] = rgb >> 16 & 0xFF;
        o_rgb[1] = rgb >> 8 & 0xFF;
        o_rgb[2] = rgb & 0xFF;
    }

    @Override
    public void getPixelSet(int[] i_x, int[] i_y, int i_num, int[] o_rgb) {
        int width = this._size.w;
        int[] ref_buf = this._ref_buf;
        int i = i_num - 1;
        while (i >= 0) {
            int rgb = ref_buf[i_x[i] + i_y[i] * width];
            o_rgb[i * 3 + 0] = rgb >> 16 & 0xFF;
            o_rgb[i * 3 + 1] = rgb >> 8 & 0xFF;
            o_rgb[i * 3 + 2] = rgb & 0xFF;
            --i;
        }
    }

    @Override
    public void setPixel(int i_x, int i_y, int[] i_rgb) throws NyARException {
        this._ref_buf[i_x + i_y * this._size.w] = i_rgb[0] << 16 | i_rgb[1] << 8 | i_rgb[2];
    }

    @Override
    public void setPixel(int i_x, int i_y, int i_r, int i_g, int i_b) throws NyARException {
        this._ref_buf[i_x + i_y * this._size.w] = i_r << 16 | i_g << 8 | i_b;
    }

    @Override
    public void setPixels(int[] i_x, int[] i_y, int i_num, int[] i_intrgb) throws NyARException {
        NyARException.notImplement();
    }

    @Override
    public void switchBuffer(Object i_ref_buffer) throws NyARException {
        assert (((int[])i_ref_buffer).length >= this._size.w * this._size.h);
        this._ref_buf = (int[])i_ref_buffer;
    }
}

