/*
 * Decompiled with CFR 0.152.
 */
package picking;

import picking.Buffer;
import processing.core.PApplet;
import processing.core.PGraphics;

public class Picker {
    protected PApplet parent;
    public Buffer buffer;

    public Picker(PApplet pApplet) {
        this.parent = pApplet;
        this.buffer = (Buffer)pApplet.createGraphics(pApplet.width, pApplet.height, "picking.Buffer");
        this.buffer.callCheckSettings();
        if (pApplet.recorder == null) {
            pApplet.recorder = this.buffer;
        }
        this.buffer.background(0);
        pApplet.registerPre((Object)this);
        pApplet.registerDraw((Object)this);
    }

    public void pre() {
        this.buffer.beginDraw();
        if (this.parent.recorder == null) {
            this.parent.recorder = this.buffer;
        }
    }

    public void draw() {
        this.buffer.endDraw();
    }

    public void start(int n) {
        if (n < 0 || n > 0xFFFFFE) {
            PApplet.println((String)"[Picking error] start(): ID out of range");
            return;
        }
        if (this.parent.recorder == null) {
            this.parent.recorder = this.buffer;
        }
        this.buffer.setCurrentId(n);
    }

    public void stop() {
        this.parent.recorder = null;
    }

    public void resume() {
        if (this.parent.recorder == null) {
            this.parent.recorder = this.buffer;
        }
    }

    public int get(int n, int n2) {
        return this.buffer.getId(n, n2);
    }

    public PGraphics getBuffer() {
        return this.buffer;
    }
}

