/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyar4psg;

import java.io.InputStream;
import java.util.ArrayList;
import jp.nyatla.nyar4psg.NyAR4PsgConfig;
import jp.nyatla.nyar4psg.NyARPsgBaseClass;
import jp.nyatla.nyar4psg.PImageRaster;
import jp.nyatla.nyartoolkit.core.NyARException;
import jp.nyatla.nyartoolkit.core.param.NyARParam;
import jp.nyatla.nyartoolkit.core.raster.rgb.INyARRgbRaster;
import jp.nyatla.nyartoolkit.core.transmat.INyARTransMat;
import jp.nyatla.nyartoolkit.core.transmat.NyARTransMat;
import jp.nyatla.nyartoolkit.core.transmat.NyARTransMat_ARToolKit;
import jp.nyatla.nyartoolkit.core.types.NyARDoublePoint2d;
import jp.nyatla.nyartoolkit.core.types.NyARDoublePoint3d;
import jp.nyatla.nyartoolkit.core.types.NyARIntPoint2d;
import jp.nyatla.nyartoolkit.core.types.NyARIntSize;
import jp.nyatla.nyartoolkit.core.types.matrix.NyARDoubleMatrix44;
import jp.nyatla.nyartoolkit.markersystem.INyARMarkerSystemConfig;
import jp.nyatla.nyartoolkit.markersystem.NyARMarkerSystem;
import jp.nyatla.nyartoolkit.markersystem.NyARMarkerSystemConfig;
import jp.nyatla.nyartoolkit.markersystem.NyARSensor;
import processing.core.PApplet;
import processing.core.PImage;
import processing.core.PMatrix;
import processing.core.PMatrix3D;
import processing.core.PVector;
import processing.opengl.PGraphicsOpenGL;

public class MultiMarker
extends NyARPsgBaseClass {
    protected PImageSensor _ss;
    protected NyARMarkerSystem _ms;
    public static final double DEFAULT_CF_THRESHOLD = 0.51;
    public static final int DEFAULT_LOST_DELAY = 10;
    public static final int THLESHOLD_AUTO = -1;
    private ArrayList<Integer> _id_map = new ArrayList();
    private final PMatrix3D _ps_projection = new PMatrix3D();
    private boolean _is_in_begin_end_session = false;

    public void setConfidenceThreshold(double d) {
        this._ms.setConfidenceThreshold(d);
    }

    public void setLostDelay(int n) {
        this._ms.setLostDelay(n);
    }

    public void setThreshold(int n) {
        int n2 = n == -1 ? Integer.MAX_VALUE : n;
        this._ms.setBinThreshold(n2);
    }

    public int getCurrentThreshold() {
        return this._ms.getCurrentThreshold();
    }

    public MultiMarker(PApplet pApplet, int n, int n2, String string, NyAR4PsgConfig nyAR4PsgConfig) {
        try {
            NyARParam nyARParam = NyARParam.createFromARParamFile((InputStream)pApplet.createInput(string));
            nyARParam.changeScreenSize(n, n2);
            this.initInstance(pApplet, nyARParam, nyAR4PsgConfig);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            pApplet.die("Catch an exception!");
        }
    }

    public MultiMarker(PApplet pApplet, int n, int n2, String string) {
        try {
            NyARParam nyARParam = NyARParam.createFromARParamFile((InputStream)pApplet.createInput(string));
            nyARParam.changeScreenSize(n, n2);
            this.initInstance(pApplet, nyARParam, NyAR4PsgConfig.CONFIG_DEFAULT);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            pApplet.die("Catch an exception!");
        }
    }

    public MultiMarker(PApplet pApplet, int n, int n2, double[] dArray, double[] dArray2) {
        try {
            NyARParam nyARParam = NyARParam.createFromCvCalibrateCamera2Result((int)n, (int)n2, (double[])dArray, (double[])dArray2);
            nyARParam.changeScreenSize(n, n2);
            this.initInstance(pApplet, nyARParam, NyAR4PsgConfig.CONFIG_DEFAULT);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            pApplet.die("Catch an exception!");
        }
    }

    protected void initInstance(PApplet pApplet, NyARParam nyARParam, NyAR4PsgConfig nyAR4PsgConfig) throws NyARException {
        NyARIntSize nyARIntSize = nyARParam.getScreenSize();
        this._ss = new PImageSensor(new NyARIntSize(nyARIntSize.w, nyARIntSize.h));
        this._ms = new NyARMarkerSystem((INyARMarkerSystemConfig)new PsgMsCfg(nyARParam, nyAR4PsgConfig.env_transmat_mode));
        super.initInstance(pApplet, nyAR4PsgConfig);
    }

    @Override
    public PMatrix3D getProjectionMatrix() {
        return this._ps_projection;
    }

    @Override
    public PMatrix3D getProjectionMatrix(PMatrix3D pMatrix3D) {
        return new PMatrix3D((PMatrix)this._ps_projection);
    }

    @Override
    public void setARClipping(float f, float f2) {
        super.setARClipping(f, f2);
        this._ms.setProjectionMatrixClipping((double)f, (double)f2);
        NyARIntSize nyARIntSize = this._ms.getARParam().getScreenSize();
        NyARDoubleMatrix44 nyARDoubleMatrix44 = new NyARDoubleMatrix44();
        this._ms.getARParam().getPerspectiveProjectionMatrix().makeCameraFrustumRH((double)nyARIntSize.w, (double)nyARIntSize.h, (double)f, (double)f2, nyARDoubleMatrix44);
        MultiMarker.nyarMat2PsMat(nyARDoubleMatrix44, this._ps_projection);
    }

    public void beginTransform(int n) {
        if (this._is_in_begin_end_session) {
            this._ref_papplet.die("The function beginTransform is already called.", null);
        }
        this._is_in_begin_end_session = true;
        if (!(this._ref_papplet.g instanceof PGraphicsOpenGL)) {
            this._ref_papplet.die("NyAR4Psg require PGraphicsOpenGL instance.");
        }
        PGraphicsOpenGL pGraphicsOpenGL = (PGraphicsOpenGL)this._ref_papplet.g;
        pGraphicsOpenGL.pushProjection();
        this.setARPerspective();
        this._ref_papplet.pushMatrix();
        this._ref_papplet.setMatrix(this.getMarkerMatrix(n));
    }

    public void endTransform() {
        if (!this._is_in_begin_end_session) {
            this._ref_papplet.die("The function beginTransform is never called.", null);
        }
        this._is_in_begin_end_session = false;
        this._ref_papplet.popMatrix();
        PGraphicsOpenGL pGraphicsOpenGL = (PGraphicsOpenGL)this._ref_papplet.g;
        pGraphicsOpenGL.popProjection();
    }

    public void detect(PImage pImage) {
        pImage.loadPixels();
        this.detectWithoutLoadPixels(pImage);
    }

    public void detectWithoutLoadPixels(PImage pImage) {
        try {
            this._ss.update(pImage);
            this._ms.update((NyARSensor)this._ss);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this._ref_papplet.die("Catch an exception!");
        }
    }

    public int addARMarker(String string, int n, int n2, float f) {
        int n3 = -1;
        try {
            this._id_map.add(this._ms.addARMarker(this._ref_papplet.createInput(string), n, n2, (double)f));
            n3 = this._id_map.size() - 1;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this._ref_papplet.die("Catch an exception!");
        }
        return n3;
    }

    public int addARMarker(String string, int n, float f) {
        return this.addARMarker(string, n, 25, f);
    }

    public int addARMarker(PImage pImage, int n, int n2, float f) {
        int n3 = -1;
        try {
            pImage.loadPixels();
            PImageRaster pImageRaster = new PImageRaster(pImage);
            this._id_map.add(this._ms.addARMarker((INyARRgbRaster)pImageRaster, n, n2, (double)f));
            n3 = this._id_map.size() - 1;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this._ref_papplet.die("Catch an exception!");
        }
        return n3;
    }

    public int addARMarker(String string, float f) {
        return this.addARMarker(string, 16, 25, f);
    }

    public int addNyIdMarker(int n, int n2) {
        return this.addNyIdMarker(n, n, n2);
    }

    public int addNyIdMarker(int n, int n2, int n3) {
        int n4 = -1;
        try {
            this._id_map.add(this._ms.addNyIdMarker((long)n, (long)n2, (double)n3));
            n4 = this._id_map.size() - 1;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this._ref_papplet.die("Catch an exception!");
        }
        return n4;
    }

    public int addPsARPlayCard(int n, int n2) {
        int n3 = -1;
        try {
            this._id_map.add(this._ms.addPsARPlayCard(n, (double)n2));
            n3 = this._id_map.size() - 1;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this._ref_papplet.die("Catch an exception!");
        }
        return n3;
    }

    public PVector[] getMarkerVertex2D(int n) {
        int n2 = this._id_map.get(n);
        PVector[] pVectorArray = new PVector[4];
        try {
            NyARIntPoint2d[] nyARIntPoint2dArray = this._ms.getMarkerVertex2D(n2);
            for (int i = 0; i < 4; ++i) {
                pVectorArray[i] = new PVector((float)nyARIntPoint2dArray[i].x, (float)nyARIntPoint2dArray[i].y);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this._ref_papplet.die("Catch an exception!");
        }
        return pVectorArray;
    }

    public PMatrix3D getMarkerMatrix(int n) {
        PMatrix3D pMatrix3D = new PMatrix3D();
        if (!this.isExistMarker(n)) {
            this._ref_papplet.die("Marker id " + n + " is not exist on image.", null);
        }
        int n2 = this._id_map.get(n);
        try {
            MultiMarker.matResult2PMatrix3D(this._ms.getMarkerMatrix(n2), this._config._coordinate_system, pMatrix3D);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this._ref_papplet.die("Catch an exception!");
        }
        return pMatrix3D;
    }

    public double getConfidence(int n) {
        int n2 = this._id_map.get(n);
        try {
            return this._ms.getConfidence(n2);
        }
        catch (Exception exception) {
            this._ref_papplet.die("Marker id " + n + " is not AR Marker or not exist.", null);
            return Double.NaN;
        }
    }

    public long getNyId(int n) {
        int n2 = this._id_map.get(n);
        try {
            return this._ms.getNyId(n2);
        }
        catch (Exception exception) {
            this._ref_papplet.die("Marker id " + n + " is not NyId Marker or not exist.", null);
            return -1L;
        }
    }

    public boolean isExistMarker(int n) {
        int n2 = this._id_map.get(n);
        try {
            return this._ms.isExistMarker(n2);
        }
        catch (Exception exception) {
            this._ref_papplet.die("Catch an exception!", null);
            return false;
        }
    }

    public int getLostCount(int n) {
        if (!this.isExistMarker(n)) {
            this._ref_papplet.die("Marker id " + n + " is not on image.", null);
        }
        int n2 = this._id_map.get(n);
        try {
            return (int)this._ms.getLostCount(n2);
        }
        catch (Exception exception) {
            this._ref_papplet.die("Catch an exception!", null);
            return -1;
        }
    }

    public long getLife(int n) {
        try {
            if (!this.isExistMarker(n)) {
                this._ref_papplet.die("Marker id " + n + " is not on image.", null);
            }
            int n2 = this._id_map.get(n);
            return this._ms.getLife(n2);
        }
        catch (Exception exception) {
            this._ref_papplet.die("Catch an exception!", null);
            return -1L;
        }
    }

    public PVector marker2ScreenCoordSystem(int n, double d, double d2, double d3) {
        try {
            int n2 = this._id_map.get(n);
            NyARDoublePoint2d nyARDoublePoint2d = new NyARDoublePoint2d();
            this._ms.getScreenPos(n2, d, d2, d3, nyARDoublePoint2d);
            PVector pVector = new PVector();
            pVector.x = (float)nyARDoublePoint2d.x;
            pVector.y = (float)nyARDoublePoint2d.y;
            pVector.z = 0.0f;
            return pVector;
        }
        catch (Exception exception) {
            this._ref_papplet.die("Catch an exception!", null);
            return null;
        }
    }

    public PVector screen2MarkerCoordSystem(int n, int n2, int n3) {
        try {
            int n4 = this._id_map.get(n);
            PVector pVector = new PVector();
            NyARDoublePoint3d nyARDoublePoint3d = new NyARDoublePoint3d();
            this._ms.getMarkerPlanePos(n4, n2, n3, nyARDoublePoint3d);
            pVector.x = (float)nyARDoublePoint3d.x;
            pVector.y = (float)nyARDoublePoint3d.y;
            pVector.z = (float)nyARDoublePoint3d.z;
            if (this._config._coordinate_system == 1) {
                pVector.x *= -1.0f;
            }
            return pVector;
        }
        catch (Exception exception) {
            this._ref_papplet.die("Catch an exception!", null);
            return null;
        }
    }

    public PImage pickupMarkerImage(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11) {
        PImage pImage = new PImage(n10, n11);
        try {
            PImageRaster pImageRaster = new PImageRaster(pImage);
            int n12 = this._id_map.get(n);
            this._ms.getMarkerPlaneImage(n12, (NyARSensor)this._ss, (double)n2, (double)n3, (double)n4, (double)n5, (double)n6, (double)n7, (double)n8, (double)n9, (INyARRgbRaster)pImageRaster);
            pImage.updatePixels();
        }
        catch (Exception exception) {
            this._ref_papplet.die("pickupMarkerImage failed.", null);
        }
        return pImage;
    }

    public PImage pickupRectMarkerImage(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        return this.pickupMarkerImage(n, n2 + n4 - 1, n3 + n5 - 1, n2, n3 + n5 - 1, n2, n3, n2 + n4 - 1, n3, n6, n7);
    }

    class PImageSensor
    extends NyARSensor {
        private PImageRaster _src;

        public PImageSensor(NyARIntSize nyARIntSize) throws NyARException {
            super(nyARIntSize);
            this._src = new PImageRaster(nyARIntSize.w, nyARIntSize.h);
        }

        public void update(PImage pImage) throws NyARException {
            this._src.wrapBuffer(pImage);
            super.update((INyARRgbRaster)this._src);
        }
    }

    class PsgMsCfg
    extends NyARMarkerSystemConfig {
        private int _tmat_type;

        public PsgMsCfg(NyARParam nyARParam, int n) throws NyARException {
            super(nyARParam);
            this._tmat_type = n;
        }

        public INyARTransMat createTransmatAlgorism() throws NyARException {
            switch (this._tmat_type) {
                case 0: {
                    return new NyARTransMat_ARToolKit(this._param);
                }
                case 1: {
                    return new NyARTransMat(this._param);
                }
            }
            throw new NyARException("Invalid Transmat algolism type.");
        }
    }
}

