/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyar4psg;

import java.io.InputStream;
import jp.nyatla.nyar4psg.NyAR4PsgConfig;
import jp.nyatla.nyar4psg.SingleMarkerBaseClass;
import jp.nyatla.nyartoolkit.core.NyARCode;
import jp.nyatla.nyartoolkit.core.NyARException;
import jp.nyatla.nyartoolkit.core.param.NyARParam;
import jp.nyatla.nyartoolkit.core.raster.rgb.INyARRgbRaster;
import jp.nyatla.nyartoolkit.core.squaredetect.NyARSquare;
import jp.nyatla.nyartoolkit.core.types.matrix.NyARDoubleMatrix44;
import jp.nyatla.nyartoolkit.processor.SingleARMarkerProcesser;
import processing.core.PApplet;
import processing.core.PImage;

public class SingleARTKMarker
extends SingleMarkerBaseClass {
    public static final int ST_NOMARKER = 0;
    public static final int ST_NEWMARKER = 1;
    public static final int ST_UPDATEMARKER = 2;
    public static final int ST_REMOVEMARKER = 3;
    public int markerid;
    private MarkerProcessor _marker_proc;
    private boolean _registerd_marker = false;

    public int getMarkerId() {
        return this.markerid;
    }

    public SingleARTKMarker(PApplet pApplet, int n, int n2, String string, NyAR4PsgConfig nyAR4PsgConfig) {
        try {
            this.initInstance(pApplet, string, n, n2, nyAR4PsgConfig);
            this._marker_proc = new MarkerProcessor(this, this._ar_param, this._src_raster.getBufferType());
        }
        catch (NyARException nyARException) {
            this._ref_papplet.die("Error on SingleARTKMarker", (Exception)((Object)nyARException));
        }
    }

    public SingleARTKMarker(PApplet pApplet, int n, int n2, String string) {
        try {
            this.initInstance(pApplet, string, n, n2, NyAR4PsgConfig.CONFIG_DEFAULT);
            this._marker_proc = new MarkerProcessor(this, this._ar_param, this._src_raster.getBufferType());
        }
        catch (NyARException nyARException) {
            this._ref_papplet.die("Error on SingleARTKMarker", (Exception)((Object)nyARException));
        }
    }

    public void setARCodes(String string, int n) {
        if (this._registerd_marker) {
            this._ref_papplet.die("Error already called setARCodes.", (Exception)((Object)new NyARException()));
        }
        try {
            NyARCode[] nyARCodeArray = new NyARCode[]{NyARCode.createFromARPattFile((InputStream)this._ref_papplet.createInput(string), (int)16, (int)16)};
            this._marker_proc.setARCodeTable(nyARCodeArray, 16, n);
            this._registerd_marker = true;
        }
        catch (NyARException nyARException) {
            this._ref_papplet.die("Error on setARCodes", (Exception)((Object)nyARException));
        }
    }

    public void setARCodes(String[] stringArray, int n) {
        if (this._registerd_marker) {
            this._ref_papplet.die("Error already called setARCodes.", (Exception)((Object)new NyARException()));
        }
        try {
            NyARCode[] nyARCodeArray = new NyARCode[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                nyARCodeArray[i] = NyARCode.createFromARPattFile((InputStream)this._ref_papplet.createInput(stringArray[i]), (int)16, (int)16);
            }
            this._marker_proc.setARCodeTable(nyARCodeArray, 16, n);
            this._registerd_marker = true;
        }
        catch (NyARException nyARException) {
            this._ref_papplet.die("Error on setARCodes", (Exception)((Object)nyARException));
        }
    }

    public void setConfidenceThreshold(double d, double d2) {
        this._marker_proc.setConfidenceThreshold(d, d2);
    }

    public int detect(PImage pImage) {
        pImage.loadPixels();
        return this.detectWithoutLoadPixels(pImage);
    }

    public int detectWithoutLoadPixels(PImage pImage) {
        if (!this._registerd_marker) {
            this._ref_papplet.die("Must call setARCodes function in the first.");
        }
        try {
            this._src_raster.wrapBuffer(pImage);
            this._marker_proc.initSequence();
            this._marker_proc.detectMarker((INyARRgbRaster)this._src_raster);
            switch (this._marker_proc.status) {
                case 0: 
                case 3: {
                    this.markerid = -1;
                    break;
                }
                case 1: {
                    this.markerid = this._marker_proc.current_code;
                    break;
                }
                case 2: {
                    break;
                }
                default: {
                    throw new NyARException();
                }
            }
        }
        catch (NyARException nyARException) {
            this._ref_papplet.die("Error while marker detecting up NyARToolkit for java", (Exception)((Object)nyARException));
        }
        return this._marker_proc.status;
    }

    private class MarkerProcessor
    extends SingleARMarkerProcesser {
        private SingleMarkerBaseClass _parent;
        public int current_code = -1;
        public int status;
        private boolean _is_prev_onenter;

        public MarkerProcessor(SingleMarkerBaseClass singleMarkerBaseClass, NyARParam nyARParam, int n) throws NyARException {
            this._parent = singleMarkerBaseClass;
            this.initInstance(nyARParam);
            this.status = 0;
        }

        public void initSequence() {
            this.status = this.status == 3 ? 0 : this.status;
        }

        protected void onEnterHandler(int n) {
            this.current_code = n;
            this.status = 1;
            this._is_prev_onenter = true;
        }

        protected void onLeaveHandler() {
            this.current_code = -1;
            this.status = 3;
        }

        protected void onUpdateHandler(NyARSquare nyARSquare, NyARDoubleMatrix44 nyARDoubleMatrix44) {
            this._parent.updateTransmat(nyARSquare, nyARDoubleMatrix44);
            this.status = this._is_prev_onenter ? 1 : 2;
            this._is_prev_onenter = false;
        }
    }
}

