/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyar4psg;

import java.io.InputStream;
import jp.nyatla.nyar4psg.NyAR4PsgConfig;
import jp.nyatla.nyar4psg.NyARPsgBaseClass;
import jp.nyatla.nyar4psg.PImageRaster;
import jp.nyatla.nyartoolkit.core.NyARException;
import jp.nyatla.nyartoolkit.core.param.NyARFrustum;
import jp.nyatla.nyartoolkit.core.param.NyARParam;
import jp.nyatla.nyartoolkit.core.raster.rgb.INyARRgbRaster;
import jp.nyatla.nyartoolkit.core.rasterdriver.INyARPerspectiveCopy;
import jp.nyatla.nyartoolkit.core.squaredetect.NyARSquare;
import jp.nyatla.nyartoolkit.core.types.NyARDoublePoint2d;
import jp.nyatla.nyartoolkit.core.types.NyARDoublePoint3d;
import jp.nyatla.nyartoolkit.core.types.NyARIntSize;
import jp.nyatla.nyartoolkit.core.types.matrix.NyARDoubleMatrix44;
import processing.core.PApplet;
import processing.core.PImage;
import processing.core.PMatrix;
import processing.core.PMatrix3D;
import processing.core.PVector;
import processing.opengl.PGraphicsOpenGL;

class SingleMarkerBaseClass
extends NyARPsgBaseClass {
    protected final PMatrix3D _ps_projection = new PMatrix3D();
    protected NyARParam _ar_param;
    protected final NyARFrustum _frustum = new NyARFrustum();
    protected NyAR4PsgConfig _config;
    protected PImageRaster _src_raster;
    public final PVector angle = new PVector();
    public final PVector trans = new PVector();
    public final int[][] pos2d = new int[4][2];
    public final double[] transmat = new double[16];
    public final double[] projection = new double[16];
    private final NyARDoubleMatrix44 _result = new NyARDoubleMatrix44();
    private boolean _is_in_begin_end_session;
    private final NyARDoublePoint3d _tmp_d3p = new NyARDoublePoint3d();
    private INyARPerspectiveCopy _pcopy;

    @Override
    public PMatrix3D getProjectionMatrix() {
        return this._ps_projection;
    }

    @Override
    public PMatrix3D getProjectionMatrix(PMatrix3D pMatrix3D) {
        return new PMatrix3D((PMatrix)this._ps_projection);
    }

    @Override
    public void setARClipping(float f, float f2) {
        super.setARClipping(f, f2);
        NyARDoubleMatrix44 nyARDoubleMatrix44 = new NyARDoubleMatrix44();
        NyARIntSize nyARIntSize = this._ar_param.getScreenSize();
        this._ar_param.getPerspectiveProjectionMatrix().makeCameraFrustumRH((double)nyARIntSize.w, (double)nyARIntSize.h, (double)f, (double)f2, nyARDoubleMatrix44);
        SingleMarkerBaseClass.nyarMat2PsMat(nyARDoubleMatrix44, this._ps_projection);
        this._frustum.setValue(nyARDoubleMatrix44, nyARIntSize.w, nyARIntSize.h);
    }

    public PMatrix3D getMarkerMatrix() {
        PMatrix3D pMatrix3D = new PMatrix3D();
        SingleMarkerBaseClass.matResult2PMatrix3D(this._result, this._config._coordinate_system, pMatrix3D);
        return new PMatrix3D((PMatrix)pMatrix3D);
    }

    public PVector[] getMarkerVertex2D() {
        PVector[] pVectorArray = new PVector[4];
        for (int i = 0; i < 4; ++i) {
            pVectorArray[i] = new PVector((float)this.pos2d[i][0], (float)this.pos2d[i][1]);
        }
        return pVectorArray;
    }

    public void beginTransform(PGraphicsOpenGL pGraphicsOpenGL) {
        assert (pGraphicsOpenGL.equals(this._ref_papplet.g));
        this.beginTransform();
    }

    public void beginTransform() {
        if (this._is_in_begin_end_session) {
            this._ref_papplet.die("The function beginTransform is already called.", null);
        }
        this._is_in_begin_end_session = true;
        if (!(this._ref_papplet.g instanceof PGraphicsOpenGL)) {
            this._ref_papplet.die("NyAR4Psg require PGraphicsOpenGL instance.");
        }
        PGraphicsOpenGL pGraphicsOpenGL = (PGraphicsOpenGL)this._ref_papplet.g;
        pGraphicsOpenGL.pushProjection();
        this.setARPerspective();
        this._ref_papplet.pushMatrix();
        this._ref_papplet.setMatrix(this.getMarkerMatrix());
    }

    public void endTransform() {
        if (!this._is_in_begin_end_session) {
            this._ref_papplet.die("The function beginTransform is never called.", null);
        }
        this._is_in_begin_end_session = false;
        this._ref_papplet.popMatrix();
        PGraphicsOpenGL pGraphicsOpenGL = (PGraphicsOpenGL)this._ref_papplet.g;
        pGraphicsOpenGL.popProjection();
    }

    public PVector screen2MarkerCoordSystem(int n, int n2) {
        PVector pVector = new PVector();
        NyARDoublePoint3d nyARDoublePoint3d = new NyARDoublePoint3d();
        this._frustum.unProjectOnMatrix((double)n, (double)n2, this._result, nyARDoublePoint3d);
        pVector.x = (float)nyARDoublePoint3d.x;
        pVector.y = (float)nyARDoublePoint3d.y;
        pVector.z = (float)nyARDoublePoint3d.z;
        if (this._config._coordinate_system == 1) {
            pVector.x *= -1.0f;
        }
        return pVector;
    }

    public PImage pickupMarkerImage(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        return this.pickupMarkerImage(this._result, n, n2, n3, n4, n5, n6, n7, n8, n9, n10);
    }

    public PImage pickupRectMarkerImage(int n, int n2, int n3, int n4, int n5, int n6) {
        return this.pickupMarkerImage(n + n3 - 1, n2 + n4 - 1, n, n2 + n4 - 1, n, n2, n + n3 - 1, n2, n5, n6);
    }

    protected void updateTransmat(NyARSquare nyARSquare, NyARDoubleMatrix44 nyARDoubleMatrix44) {
        this._result.setValue(nyARDoubleMatrix44);
        SingleMarkerBaseClass.matResult2GLArray(nyARDoubleMatrix44, this.transmat);
        nyARDoubleMatrix44.getZXYAngle(this._tmp_d3p);
        this.angle.x = (float)this._tmp_d3p.x;
        this.angle.y = (float)this._tmp_d3p.y;
        this.angle.z = (float)this._tmp_d3p.z;
        this.trans.x = (float)nyARDoubleMatrix44.m03;
        this.trans.y = (float)nyARDoubleMatrix44.m13;
        this.trans.z = (float)nyARDoubleMatrix44.m23;
        NyARDoublePoint2d[] nyARDoublePoint2dArray = nyARSquare.sqvertex;
        for (int i = 0; i < 4; ++i) {
            this.pos2d[i][0] = (int)nyARDoublePoint2dArray[i].x;
            this.pos2d[i][1] = (int)nyARDoublePoint2dArray[i].y;
        }
    }

    protected void initInstance(PApplet pApplet, String string, int n, int n2, NyAR4PsgConfig nyAR4PsgConfig) throws NyARException {
        this._config = nyAR4PsgConfig;
        this._ar_param = NyARParam.createFromARParamFile((InputStream)pApplet.createInput(string));
        this._ar_param.changeScreenSize(n, n2);
        this._src_raster = new PImageRaster(n, n2);
        this._pcopy = (INyARPerspectiveCopy)this._src_raster.createInterface(INyARPerspectiveCopy.class);
        super.initInstance(pApplet, nyAR4PsgConfig);
        SingleMarkerBaseClass.PMatrix2GLProjection(this._ps_projection, this.transmat);
    }

    protected SingleMarkerBaseClass() {
    }

    protected PImage pickupMarkerImage(NyARDoubleMatrix44 nyARDoubleMatrix44, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        if (!this._src_raster.hasBuffer()) {
            this._ref_papplet.die("_rel_detector is null.(Function detect() was never called. )");
        }
        PImage pImage = new PImage(n9, n10);
        pImage.parent = this._ref_papplet;
        try {
            NyARDoublePoint3d[] nyARDoublePoint3dArray = NyARDoublePoint3d.createArray((int)4);
            nyARDoubleMatrix44.transform3d((double)n, (double)n2, 0.0, nyARDoublePoint3dArray[1]);
            nyARDoubleMatrix44.transform3d((double)n3, (double)n4, 0.0, nyARDoublePoint3dArray[0]);
            nyARDoubleMatrix44.transform3d((double)n5, (double)n6, 0.0, nyARDoublePoint3dArray[3]);
            nyARDoubleMatrix44.transform3d((double)n7, (double)n8, 0.0, nyARDoublePoint3dArray[2]);
            NyARDoublePoint2d[] nyARDoublePoint2dArray = NyARDoublePoint2d.createArray((int)4);
            for (int i = 3; i >= 0; --i) {
                this._frustum.project(nyARDoublePoint3dArray[i], nyARDoublePoint2dArray[i]);
            }
            PImageRaster pImageRaster = new PImageRaster(n9, n10);
            pImageRaster.wrapBuffer(pImage);
            if (!this._pcopy.copyPatt(nyARDoublePoint2dArray, 0, 0, 1, (INyARRgbRaster)pImageRaster)) {
                throw new Exception("this._pcopy.copyPatt failed.");
            }
            pImage.updatePixels();
            return pImage;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this._ref_papplet.die("Exception occurred at MultiARTookitMarker.pickupImage");
            return null;
        }
    }
}

