/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core;

import jp.nyatla.nyartoolkit.core.NyARException;

public class NyARVec {
    private int clm;
    private double[] v;

    public NyARVec(int i_clm) {
        this.v = new double[i_clm];
        this.clm = i_clm;
    }

    public void realloc(int i_clm) {
        if (i_clm > this.v.length) {
            this.v = new double[i_clm];
        }
        this.clm = i_clm;
    }

    public int getClm() {
        return this.clm;
    }

    public double[] getArray() {
        return this.v;
    }

    public double vecInnerproduct(NyARVec y, int i_start) throws NyARException {
        NyARException.trap("\u3053\u306e\u95a2\u6570\u306f\u52d5\u4f5c\u78ba\u8a8d\u3067\u304d\u3066\u3044\u307e\u305b\u3093\u3002");
        double result = 0.0;
        if (this.clm != y.clm) {
            throw new NyARException();
        }
        int i = i_start;
        while (i < this.clm) {
            NyARException.trap("\u672a\u30c1\u30a7\u30c3\u30af\u306e\u30d1\u30b9");
            result += this.v[i] * y.v[i];
            ++i;
        }
        return result;
    }

    public double vecHousehold(int i_start) throws NyARException {
        NyARException.trap("\u3053\u306e\u95a2\u6570\u306f\u52d5\u4f5c\u78ba\u8a8d\u3067\u304d\u3066\u3044\u307e\u305b\u3093\u3002");
        double s = Math.sqrt(this.vecInnerproduct(this, i_start));
        if (s != 0.0) {
            NyARException.trap("\u672a\u30c1\u30a7\u30c3\u30af\u306e\u30d1\u30b9");
            if (this.v[i_start] < 0.0) {
                s = -s;
            }
            NyARException.trap("\u672a\u30c1\u30a7\u30c3\u30af\u306e\u30d1\u30b9");
            int n = i_start;
            this.v[n] = this.v[n] + s;
            double t = 1.0 / Math.sqrt(this.v[i_start] * s);
            int i = i_start;
            while (i < this.clm) {
                NyARException.trap("\u672a\u30c1\u30a7\u30c3\u30af\u306e\u30d1\u30b9");
                int n2 = i++;
                this.v[n2] = this.v[n2] * t;
            }
        }
        return -s;
    }

    public void setNewArray(double[] i_array, int i_clm) {
        this.v = i_array;
        this.clm = i_clm;
    }
}

