/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.pixeldriver;

import jp.nyatla.nyartoolkit.core.NyARException;
import jp.nyatla.nyartoolkit.core.pixeldriver.INyARRgbPixelDriver;
import jp.nyatla.nyartoolkit.core.raster.rgb.INyARRgbRaster;
import jp.nyatla.nyartoolkit.core.types.NyARIntSize;

final class NyARRgbPixelDriver_INT1D_GRAY_8
implements INyARRgbPixelDriver {
    private int[] _ref_buf;
    private NyARIntSize _ref_size;

    NyARRgbPixelDriver_INT1D_GRAY_8() {
    }

    @Override
    public NyARIntSize getSize() {
        return this._ref_size;
    }

    @Override
    public void getPixel(int i_x, int i_y, int[] o_rgb) {
        o_rgb[1] = o_rgb[2] = this._ref_buf[i_x + i_y * this._ref_size.w];
        o_rgb[0] = o_rgb[2];
    }

    @Override
    public void getPixelSet(int[] i_x, int[] i_y, int i_num, int[] o_rgb) {
        int width = this._ref_size.w;
        int[] ref_buf = this._ref_buf;
        int i = i_num - 1;
        while (i >= 0) {
            int n = ref_buf[i_x[i] + i_y[i] * width];
            o_rgb[i * 3 + 2] = n;
            o_rgb[i * 3 + 1] = n;
            o_rgb[i * 3 + 0] = n;
            --i;
        }
    }

    @Override
    public void setPixel(int i_x, int i_y, int[] i_rgb) throws NyARException {
        NyARException.notImplement();
    }

    @Override
    public void setPixel(int i_x, int i_y, int i_r, int i_g, int i_b) throws NyARException {
        NyARException.notImplement();
    }

    @Override
    public void setPixels(int[] i_x, int[] i_y, int i_num, int[] i_intrgb) throws NyARException {
        NyARException.notImplement();
    }

    @Override
    public void switchRaster(INyARRgbRaster i_raster) throws NyARException {
        this._ref_buf = (int[])i_raster.getBuffer();
        this._ref_size = i_raster.getSize();
    }
}

