/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.transmat.rotmatrix;

import jp.nyatla.nyartoolkit.core.NyARException;
import jp.nyatla.nyartoolkit.core.param.NyARPerspectiveProjectionMatrix;
import jp.nyatla.nyartoolkit.core.transmat.rotmatrix.NyARRotVector;
import jp.nyatla.nyartoolkit.core.types.NyARDoublePoint2d;
import jp.nyatla.nyartoolkit.core.types.NyARLinear;
import jp.nyatla.nyartoolkit.core.types.matrix.NyARDoubleMatrix44;

public class NyARRotVectorV2
extends NyARRotVector {
    private NyARPerspectiveProjectionMatrix _projection_mat_ref;
    private NyARDoubleMatrix44 _inv_cpara = new NyARDoubleMatrix44();

    public NyARRotVectorV2(NyARPerspectiveProjectionMatrix i_cmat) throws NyARException {
        this._inv_cpara.inverse(i_cmat);
        this._projection_mat_ref = i_cmat;
    }

    public void exteriorProductFromLinear(NyARLinear i_linear1, NyARLinear i_linear2) {
        NyARPerspectiveProjectionMatrix cmat = this._projection_mat_ref;
        double w1 = i_linear1.a * i_linear2.b - i_linear2.a * i_linear1.b;
        double w2 = i_linear1.b * i_linear2.c - i_linear2.b * i_linear1.c;
        double w3 = i_linear1.c * i_linear2.a - i_linear2.c * i_linear1.a;
        double m0 = w1 * (cmat.m01 * cmat.m12 - cmat.m02 * cmat.m11) + w2 * cmat.m11 - w3 * cmat.m01;
        double m1 = -w1 * cmat.m00 * cmat.m12 + w3 * cmat.m00;
        double m2 = w1 * cmat.m00 * cmat.m11;
        double w = Math.sqrt(m0 * m0 + m1 * m1 + m2 * m2);
        this.v1 = m0 / w;
        this.v2 = m1 / w;
        this.v3 = m2 / w;
    }

    public boolean checkVectorByVertex(NyARDoublePoint2d i_start_vertex, NyARDoublePoint2d i_end_vertex) {
        NyARDoubleMatrix44 inv_cpara = this._inv_cpara;
        double world0 = inv_cpara.m00 * i_start_vertex.x * 10.0 + inv_cpara.m01 * i_start_vertex.y * 10.0 + inv_cpara.m02 * 10.0;
        double world1 = inv_cpara.m10 * i_start_vertex.x * 10.0 + inv_cpara.m11 * i_start_vertex.y * 10.0 + inv_cpara.m12 * 10.0;
        double world2 = inv_cpara.m20 * i_start_vertex.x * 10.0 + inv_cpara.m21 * i_start_vertex.y * 10.0 + inv_cpara.m22 * 10.0;
        double world3 = world0 + this.v1;
        double world4 = world1 + this.v2;
        double world5 = world2 + this.v3;
        NyARPerspectiveProjectionMatrix cmat = this._projection_mat_ref;
        double h = cmat.m20 * world0 + cmat.m21 * world1 + cmat.m22 * world2;
        if (h == 0.0) {
            return false;
        }
        double camera0 = (cmat.m00 * world0 + cmat.m01 * world1 + cmat.m02 * world2) / h;
        double camera1 = (cmat.m10 * world0 + cmat.m11 * world1 + cmat.m12 * world2) / h;
        h = cmat.m20 * world3 + cmat.m21 * world4 + cmat.m22 * world5;
        if (h == 0.0) {
            return false;
        }
        double camera2 = (cmat.m00 * world3 + cmat.m01 * world4 + cmat.m02 * world5) / h;
        double camera3 = (cmat.m10 * world3 + cmat.m11 * world4 + cmat.m12 * world5) / h;
        double v = (i_end_vertex.x - i_start_vertex.x) * (camera2 - camera0) + (i_end_vertex.y - i_start_vertex.y) * (camera3 - camera1);
        if (v < 0.0) {
            this.v1 = -this.v1;
            this.v2 = -this.v2;
            this.v3 = -this.v3;
        }
        return true;
    }
}

