/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.markersystem;

import jp.nyatla.nyartoolkit.core.NyARException;
import jp.nyatla.nyartoolkit.core.raster.INyARGrayscaleRaster;
import jp.nyatla.nyartoolkit.core.rasterdriver.INyARPerspectiveCopy;
import jp.nyatla.nyartoolkit.core.squaredetect.NyARCoord2Linear;
import jp.nyatla.nyartoolkit.core.squaredetect.NyARSquareContourDetector;
import jp.nyatla.nyartoolkit.core.types.NyARIntCoordinates;
import jp.nyatla.nyartoolkit.markersystem.INyARMarkerSystemConfig;
import jp.nyatla.nyartoolkit.markersystem.utils.ARMarkerList;
import jp.nyatla.nyartoolkit.markersystem.utils.ARPlayCardList;
import jp.nyatla.nyartoolkit.markersystem.utils.NyIdList;
import jp.nyatla.nyartoolkit.markersystem.utils.SquareStack;
import jp.nyatla.nyartoolkit.markersystem.utils.TrackingList;

class OnSquareDetect
implements NyARSquareContourDetector.CbHandler {
    private TrackingList _ref_tracking_list;
    private ARMarkerList _ref_armk_list;
    private NyIdList _ref_idmk_list;
    private ARPlayCardList _ref_psmk_list;
    public SquareStack _sq_stack;
    public INyARPerspectiveCopy _ref_input_rfb;
    public INyARGrayscaleRaster _ref_input_gs;
    public int _ref_th;
    private NyARCoord2Linear _coordline;

    public OnSquareDetect(INyARMarkerSystemConfig i_config, ARMarkerList i_armk_list, NyIdList i_idmk_list, ARPlayCardList i_psmk_list, TrackingList i_tracking_list, int i_initial_stack_size) throws NyARException {
        this._coordline = new NyARCoord2Linear(i_config.getNyARParam().getScreenSize(), i_config.getNyARParam().getDistortionFactor());
        this._ref_armk_list = i_armk_list;
        this._ref_idmk_list = i_idmk_list;
        this._ref_psmk_list = i_psmk_list;
        this._ref_tracking_list = i_tracking_list;
        this._sq_stack = new SquareStack(i_initial_stack_size);
    }

    public void setMaxDetectMarkerCapacity(int i_max_number_of_marker) throws NyARException {
        if (this._sq_stack.getArraySize() < i_max_number_of_marker) {
            this._sq_stack = new SquareStack(i_max_number_of_marker + 5);
        }
    }

    public void prepare(INyARPerspectiveCopy i_pcopy, INyARGrayscaleRaster i_gs, int th) {
        this._ref_input_rfb = i_pcopy;
        this._ref_input_gs = i_gs;
        this._ref_th = th;
        this._sq_stack.clear();
    }

    @Override
    public void detectMarkerCallback(NyARIntCoordinates i_coord, int[] i_vertex_index) throws NyARException {
        SquareStack.Item sq_tmp = (SquareStack.Item)this._sq_stack.prePush();
        if (sq_tmp == null) {
            return;
        }
        int i2 = 0;
        while (i2 < 4) {
            sq_tmp.ob_vertex[i2].setValue(i_coord.items[i_vertex_index[i2]]);
            ++i2;
        }
        sq_tmp.vertex_area.setAreaRect(sq_tmp.ob_vertex, 4);
        sq_tmp.center2d.setCenterPos(sq_tmp.ob_vertex, 4);
        sq_tmp.rect_area = sq_tmp.vertex_area.w * sq_tmp.vertex_area.h;
        boolean is_target_marker = false;
        if (this._ref_tracking_list.update(sq_tmp)) {
            is_target_marker = true;
        } else if (this._ref_idmk_list.size() > 0 && this._ref_idmk_list.update(this._ref_input_gs, sq_tmp)) {
            is_target_marker = true;
        } else if (this._ref_psmk_list.size() > 0 && this._ref_psmk_list.update(this._ref_input_gs, sq_tmp)) {
            is_target_marker = true;
        } else if (this._ref_armk_list.size() > 0 && this._ref_armk_list.update(this._ref_input_rfb, sq_tmp)) {
            is_target_marker = true;
        }
        if (is_target_marker) {
            int i22 = 0;
            while (i22 < 4) {
                this._coordline.coord2Line(i_vertex_index[i22], i_vertex_index[(i22 + 1) % 4], i_coord, sq_tmp.line[i22]);
                ++i22;
            }
            i22 = 0;
            while (i22 < 4) {
                if (!sq_tmp.line[i22].crossPos(sq_tmp.line[(i22 + 3) % 4], sq_tmp.sqvertex[i22])) {
                    throw new NyARException();
                }
                ++i22;
            }
        } else {
            this._sq_stack.pop();
        }
    }
}

