/*
 * Decompiled with CFR 0.152.
 */
package oaks;

import java.io.Closeable;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedList;
import oaks.ConnectionKey;
import oaks.analysis.SqlInformation;

public class DB
extends Thread
implements Closeable {
    private static volatile HashMap<ConnectionKey, LinkedList<DB>> wait_map = new HashMap();
    private static volatile HashMap<ConnectionKey, LinkedList<DB>> active_map = new HashMap();
    private LinkedList<DB> pool;
    private LinkedList<DB> lease;
    private Connection con;
    private ConnectionKey con_key;
    private volatile boolean open_f = false;
    private volatile int exe_count = 0;
    private volatile ArrayList<Resource> res = null;
    volatile java.util.Date open_time = null;
    volatile StackTraceElement[] open_locate = null;
    private static volatile LinkedList<DB> closed = new LinkedList();
    private static DB cleanner = new DB();
    private HashMap<String, PreparedStatement> pps = new HashMap();
    static final Calendar TIMEZONE;
    private HashMap<String, CallableStatement> cas = new HashMap();
    private String last_sql;
    private Object[] last_param;
    static final String LF;
    private HashMap<PreparedStatement, ResultSet> selecting = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DB(ConnectionKey key, LinkedList<DB> plist, LinkedList<DB> llist) throws DBException {
        this(key);
        LinkedList<DB> linkedList = llist;
        synchronized (linkedList) {
            if (llist.size() >= key.getMaxConnect()) {
                try {
                    llist.wait(key.getTimeout() * 1000);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (llist.size() >= key.getMaxConnect()) {
                throw new ConnectTimeoutException(llist);
            }
        }
        try {
            this.set(key.getConnection(), plist, llist);
        }
        catch (Exception e) {
            throw new DBException(e);
        }
    }

    private DB(DB old) {
        this(old.con_key);
        this.set(old.con, old.pool, old.lease);
        old.con = null;
        HashMap<String, PreparedStatement> tmp = this.cas;
        this.cas = old.cas;
        old.cas = tmp;
        tmp = this.pps;
        this.pps = old.pps;
        old.pps = tmp;
    }

    private void set(Connection c, LinkedList<DB> plist, LinkedList<DB> llist) {
        this.con = c;
        this.pool = plist;
        this.lease = llist;
    }

    private DB(ConnectionKey k) {
        this.con_key = k;
    }

    private DB() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DB open(ConnectionKey key) throws DBException {
        DB db = null;
        LinkedList<DB> plist = null;
        Cloneable cloneable = wait_map;
        synchronized (cloneable) {
            plist = wait_map.get(key);
            if (plist == null) {
                plist = new LinkedList();
                wait_map.put(key, plist);
            }
        }
        while (true) {
            cloneable = plist;
            synchronized (cloneable) {
                db = plist.poll();
            }
            if (db == null) break;
            try {
                db.con.rollback();
            }
            catch (SQLException e) {
                db.allClose();
                db = null;
                continue;
            }
            break;
        }
        LinkedList<DB> llist = null;
        Cloneable cloneable2 = active_map;
        synchronized (cloneable2) {
            llist = active_map.get(key);
            if (llist == null) {
                llist = new LinkedList();
                active_map.put(key, llist);
            }
        }
        if (db == null) {
            db = new DB(key, plist, llist);
        }
        cloneable2 = llist;
        synchronized (cloneable2) {
            llist.offer(db);
        }
        db.open_f = true;
        db.exe_count = 0;
        db.last_sql = "";
        db.last_param = new Object[0];
        db.res = new ArrayList();
        db.open_time = new java.util.Date();
        db.open_locate = DB.currentThread().getStackTrace();
        return db;
    }

    public DatabaseMetaData getMetaData() throws DBException {
        try {
            return this.con.getMetaData();
        }
        catch (SQLException e) {
            throw new DBException(e);
        }
    }

    void addResource(Resource r) {
        this.res.add(r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            DB db = null;
            LinkedList<DB> linkedList = closed;
            synchronized (linkedList) {
                try {
                    if (closed.size() < 1) {
                        closed.wait(1000L);
                    }
                    db = closed.poll();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (db == null) continue;
            for (Resource r : db.res) {
                try {
                    r.waitClose();
                }
                catch (DBException e) {}
            }
            db.res = null;
            try {
                int max = db.con_key.getMaxConnect();
                int cnt = 0;
                LinkedList<DB> linkedList2 = db.lease;
                synchronized (linkedList2) {
                    db.lease.remove(db);
                    cnt = db.lease.size();
                    db.lease.notify();
                }
                db.con.rollback();
                linkedList2 = db.pool;
                synchronized (linkedList2) {
                    if ((cnt += db.pool.size()) < max) {
                        db.pool.offer(new DB(db));
                    }
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            db.allClose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.open_f = false;
        LinkedList<DB> linkedList = closed;
        synchronized (linkedList) {
            closed.offer(this);
            closed.notifyAll();
        }
    }

    protected void finalize() throws Throwable {
        this.allClose();
    }

    private void checkOpen() throws DBClosedException {
        if (!this.open_f) {
            throw new DBClosedException();
        }
    }

    private void allClose() {
        for (String k : this.pps.keySet()) {
            try {
                this.pps.get(k).close();
            }
            catch (Exception e) {}
        }
        for (String k : this.cas.keySet()) {
            try {
                this.cas.get(k).close();
            }
            catch (Exception exception) {}
        }
        try {
            if (this.con != null) {
                this.con.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public PreparedStatement prepareStatement(String sql) throws DBException {
        this.checkOpen();
        PreparedStatement ret = this.pps.get(sql);
        try {
            if (ret == null) {
                ret = this.con.prepareStatement(sql);
                this.pps.put(sql, ret);
            }
            ret.clearParameters();
        }
        catch (SQLException e) {
            throw new DBException(e);
        }
        return ret;
    }

    private PreparedStatement prepareStatement(String sql, Object ... param) throws DBException {
        PreparedStatement ret = this.prepareStatement(sql);
        for (int i = 0; i < param.length; ++i) {
            try {
                if (param[i] instanceof Date) {
                    ret.setDate(i + 1, (Date)param[i], TIMEZONE);
                    continue;
                }
                if (param[i] instanceof Time) {
                    ret.setTime(i + 1, (Time)param[i], TIMEZONE);
                    continue;
                }
                if (param[i] instanceof Timestamp) {
                    ret.setTimestamp(i + 1, (Timestamp)param[i], TIMEZONE);
                    continue;
                }
                ret.setObject(i + 1, param[i]);
                continue;
            }
            catch (SQLException e) {
                throw new DBException(e);
            }
        }
        return ret;
    }

    public CallableStatement prepareCall(String sql) throws DBException {
        this.checkOpen();
        CallableStatement ret = this.cas.get(sql);
        try {
            if (ret == null) {
                ret = this.con.prepareCall(sql);
                this.cas.put(sql, ret);
            }
            ret.clearParameters();
        }
        catch (SQLException e) {
            throw new DBException(e);
        }
        return ret;
    }

    public String getLastSQL() {
        StringBuilder buf = new StringBuilder(this.last_sql);
        for (int i = 0; i < this.last_param.length; ++i) {
            buf = this.last_param[i] != null ? buf.append(LF).append(String.format("    No.%02d:[%s](%s)", i + 1, this.last_param[i].toString(), this.last_param[i].getClass().toString())) : buf.append(LF).append(String.format("    No.%02d:null", i + 1));
        }
        buf = buf.append(LF);
        return buf.toString();
    }

    public int executeUpdate(String sql, Object ... param) throws DBException {
        ++this.exe_count;
        if (sql == null) {
            sql = "";
        }
        if (param == null) {
            param = new Object[]{};
        }
        this.last_sql = sql;
        this.last_param = param;
        SqlInformation info = new SqlInformation(sql, param);
        try {
            int n = this.prepareStatement(sql, param).executeUpdate();
            return n;
        }
        catch (SQLException e) {
            info.close(e);
            throw new SQLExecException(this, e);
        }
        finally {
            info.close(null);
            this.con_key.put(info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet executeQuery(String sql, Object ... param) throws DBException {
        if (sql == null) {
            sql = "";
        }
        if (param == null) {
            param = new Object[]{};
        }
        this.last_sql = sql;
        this.last_param = param;
        SqlInformation info = new SqlInformation(sql, param);
        try {
            PreparedStatement st = this.prepareStatement(sql, param);
            ResultSet rs = null;
            Object object = this.selecting;
            synchronized (object) {
                rs = this.selecting.get(st);
                if (rs != null) {
                    ResultSet resultSet = rs;
                    synchronized (resultSet) {
                        while (!rs.isClosed()) {
                            try {
                                rs.wait(10L);
                            }
                            catch (Exception e) {}
                        }
                    }
                }
                info = new SqlInformation(sql, param);
                rs = st.executeQuery();
                info.close(null);
                this.selecting.put(st, rs);
            }
            object = rs;
            return object;
        }
        catch (SQLException e) {
            info.close(e);
            throw new SQLExecException(this, e);
        }
        finally {
            this.con_key.put(info);
        }
    }

    public void commit() throws DBException {
        this.checkOpen();
        try {
            this.con.commit();
        }
        catch (SQLException e) {
            throw new DBException(e);
        }
    }

    public void commit(int cnt) throws DBException {
        if (this.exe_count >= cnt) {
            this.commit();
            this.exe_count = 0;
        }
    }

    public void rollback() throws DBException {
        this.checkOpen();
        try {
            this.con.rollback();
        }
        catch (SQLException e) {
            throw new DBException(e);
        }
    }

    public Savepoint setSavepoint() throws DBException {
        this.checkOpen();
        try {
            return this.con.setSavepoint();
        }
        catch (SQLException e) {
            throw new DBException(e);
        }
    }

    public void rollback(Savepoint sp) throws DBException {
        this.checkOpen();
        try {
            this.con.rollback(sp);
        }
        catch (SQLException e) {
            throw new DBException(e);
        }
    }

    private static long getNow() {
        return new java.util.Date().getTime();
    }

    public static Date nowDate() {
        return new Date(DB.getNow());
    }

    public static Time nowTime() {
        return new Time(DB.getNow());
    }

    public static Timestamp nowTimestamp() {
        return new Timestamp(DB.getNow());
    }

    static {
        cleanner.setDaemon(true);
        cleanner.setPriority(1);
        cleanner.start();
        TIMEZONE = Calendar.getInstance();
        LF = System.getProperty("line.separator");
    }

    public static interface Resource {
        public void waitClose() throws DBException;
    }

    public static class ConnectTimeoutException
    extends DBException {
        private volatile java.util.Date now = new java.util.Date();
        private volatile Info[] info;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ConnectTimeoutException(LinkedList<DB> list) {
            super("connect timeout.");
            LinkedList<DB> linkedList = list;
            synchronized (linkedList) {
                this.info = new Info[list.size()];
                int i = 0;
                for (DB db : list) {
                    this.info[i] = new Info(db.open_time, db.open_locate);
                    ++i;
                }
            }
        }

        public java.util.Date getDate() {
            return this.now;
        }

        public Info[] getInfo() {
            return this.info;
        }

        @Override
        public String getLocalizedMessage() {
            StringBuilder buf = new StringBuilder(super.getLocalizedMessage());
            buf = buf.append(LF);
            buf = buf.append(this.now.toString());
            buf = buf.append(LF);
            for (Info i : this.info) {
                buf = buf.append(LF);
                buf = buf.append("-------------------------").append(LF);
                buf = buf.append(i.toString());
                buf = buf.append(LF);
            }
            return buf.toString();
        }

        public class Info {
            private volatile java.util.Date start;
            private volatile StackTraceElement[] locate;

            private Info(java.util.Date d, StackTraceElement[] l) {
                this.start = d;
                this.locate = l;
            }

            public java.util.Date getOpenTime() {
                return this.start;
            }

            public StackTraceElement[] getStackTrace() {
                return this.locate;
            }

            public String toString() {
                StringBuilder buf = new StringBuilder(this.start.toString());
                buf = buf.append(LF);
                for (StackTraceElement st : this.locate) {
                    buf = buf.append(st.toString()).append(LF);
                }
                return buf.toString();
            }
        }
    }

    public static class DBClosedException
    extends DBException {
        private DBClosedException() {
            super("DB is already closed and cannot be used.");
        }
    }

    public static class SQLExecException
    extends DBException {
        private volatile DB err;
        private volatile SQLException ex;

        SQLExecException(DB db, SQLException e) {
            super(e);
            this.err = db;
            this.ex = e;
        }

        @Override
        public String getLocalizedMessage() {
            StringBuilder buf = new StringBuilder(super.getLocalizedMessage());
            buf = buf.append(LF).append(this.err.getLastSQL());
            return buf.toString();
        }
    }

    public static class DBException
    extends Exception {
        DBException(Throwable e) {
            super(e);
        }

        DBException(String s) {
            super(s);
        }
    }
}

