/*
 * Decompiled with CFR 0.152.
 */
package oaks;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.util.ArrayList;
import oaks.DB;
import oaks.View;

class Record<E extends View>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String tail = null;
    private volatile int limit;
    private volatile int all_count = 0;
    private volatile int one_count = 0;
    private volatile transient Object[] write_data = null;
    private volatile transient ArrayList<File> tmp = new ArrayList();
    private volatile transient int read_no = -1;
    private volatile transient int write_no = -1;
    private volatile transient Object[] read_data = null;

    private void writeObject(ObjectOutputStream stream) throws IOException, DB.DBException {
        stream.defaultWriteObject();
        for (int i = 0; i < this.all_count; ++i) {
            stream.writeObject(this.get(Record.class, i));
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException, DB.DBException {
        stream.defaultReadObject();
        this.init();
        for (int i = 0; i < this.all_count; ++i) {
            this.add((View)stream.readObject());
        }
    }

    protected void finalize() throws Throwable {
        if (this.tmp == null) {
            return;
        }
        for (File f : this.tmp) {
            f.delete();
        }
    }

    private Record() {
        this.tail = Integer.toString(this.hashCode(), 36);
    }

    Record(int lim) {
        this();
        this.limit = lim;
    }

    private void init() {
        this.write_data = new Object[this.limit];
        this.tmp = new ArrayList();
        this.read_no = -1;
        this.write_no = -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void add(E v) throws DB.DBException {
        ObjectOutputStream out = null;
        try {
            ArrayList<File> arrayList = this.tmp;
            synchronized (arrayList) {
                if (this.one_count >= this.limit) {
                    File swap = File.createTempFile("oaks", this.tail);
                    swap.deleteOnExit();
                    out = new ObjectOutputStream(new FileOutputStream(swap));
                    out.writeObject(this.write_data);
                    this.write_data = new Object[this.limit];
                    this.one_count = 0;
                    this.tmp.add(swap);
                }
                this.write_data[this.one_count] = v;
                this.write_no = this.all_count / this.limit;
                ++this.one_count;
                ++this.all_count;
            }
        }
        catch (IOException e) {
            throw new DB.DBException(e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception e) {}
            }
        }
    }

    int size() {
        return this.all_count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    E get(Class<?> me, int index) throws DB.DBException {
        if (index < 0) {
            return null;
        }
        if (this.all_count <= index) {
            return null;
        }
        int grp = index / this.limit;
        int offset = index % this.limit;
        String string = this.tail;
        synchronized (string) {
            Serializable serializable;
            ObjectInputStream in;
            block25: {
                View view;
                block24: {
                    ArrayList<File> arrayList = this.tmp;
                    synchronized (arrayList) {
                        if (this.write_no == grp) {
                            return (E)((View)this.write_data[offset]);
                        }
                    }
                    in = null;
                    try {
                        if (this.read_no == grp && this.read_data != null) {
                            view = (View)this.read_data[offset];
                            break block24;
                        }
                        serializable = this.tmp;
                        synchronized (serializable) {
                            in = new InSt(me, new FileInputStream(this.tmp.get(grp)));
                        }
                        this.read_data = (Object[])in.readObject();
                        this.read_no = grp;
                        serializable = (View)this.read_data[offset];
                        break block25;
                    }
                    catch (ClassNotFoundException cnfe) {
                        throw new DB.DBException(cnfe);
                    }
                    catch (IOException ie) {
                        throw new DB.DBException(ie);
                    }
                }
                return (E)view;
            }
            return (E)serializable;
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Exception e) {}
                }
            }
        }
    }

    private class InSt
    extends ObjectInputStream {
        private ClassLoader cl;

        InSt(Class<?> c, InputStream s) throws ClassNotFoundException, IOException {
            super(s);
            this.cl = c.getClassLoader();
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) throws ClassNotFoundException, IOException {
            try {
                return super.resolveClass(desc);
            }
            catch (ClassNotFoundException e) {
                return this.cl.loadClass(desc.getName());
            }
        }
    }
}

