/*
 * Decompiled with CFR 0.152.
 */
package oaks;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import oaks.DB;
import oaks.Field;
import oaks.GroupBy;
import oaks.OrderBy;
import oaks.SelectGroup;
import oaks.SelectList;
import oaks.Where;

public abstract class View<E extends View>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    protected Field[] fields;
    static volatile int max_view_limit = 200;
    private static HashMap<Class<? extends View>, ViewHolder> map = new HashMap();
    private static ViewMake maker = new ViewMake(map);
    private transient SelectGroup sg;

    public String toString() {
        StringBuilder buf = new StringBuilder(this.name);
        buf = buf.append("{").append(DB.LF);
        for (Field f : this.fields) {
            buf = buf.append(f.toString()).append(DB.LF);
        }
        buf = buf.append("}");
        return buf.toString();
    }

    public static void setPreLoadViewLimitCount(int count) {
        max_view_limit = count;
    }

    public static int getPreLoadViewLimitCount() {
        return max_view_limit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void init(View v) {
        HashMap<Class<? extends View>, ViewHolder> hashMap = map;
        synchronized (hashMap) {
            map.put(v.getClass(), new ViewHolder(v));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static View newInstance(Class<? extends View> key) {
        ViewHolder vh = null;
        HashMap<Class<? extends View>, ViewHolder> hashMap = map;
        synchronized (hashMap) {
            vh = map.get(key);
        }
        return vh.get();
    }

    View() {
    }

    protected View(String n) {
        this.name = n;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String n) {
        this.name = n;
    }

    public Field[] getFields() {
        return this.fields;
    }

    protected abstract View getInstance();

    String makeSelect(SS2005With with, Where where, GroupBy group, Where have, OrderBy ... order) throws DB.DBException {
        String str;
        StringBuilder buf = new StringBuilder("select ");
        this.sg = new SelectGroup(this.fields, group, order);
        buf = buf.append(this.sg.getSelect());
        buf = buf.append(" from ").append(this.getName());
        if (with != null) {
            buf.append(" ").append(with.toString());
        }
        if (where != null && (str = where.getString(true)) != null) {
            buf = buf.append(str);
        }
        if (group != null && (str = group.toString()) != null) {
            buf = buf.append(" ").append(str);
        }
        if (have != null && (str = have.getString(false)) != null) {
            buf = buf.append(" ").append(str);
        }
        buf = buf.append(this.sg.getOrderBy());
        return buf.toString();
    }

    SelectList<E> select(DB db, String sql, Where where, Where have) throws DB.DBException {
        Object[] obj;
        SelectList list = new SelectList(db, this.sg);
        this.sg = null;
        ArrayList<Object> ol = new ArrayList<Object>();
        if (where != null) {
            for (Object o : obj = where.getParam()) {
                ol.add(o);
            }
        }
        if (have != null) {
            for (Object o : obj = have.getParam()) {
                ol.add(o);
            }
        }
        list.start(this, db.executeQuery(sql, ol.toArray(new Object[0])));
        return list;
    }

    public SelectList<E> select(DB db, Where where, OrderBy ... order) throws DB.DBException {
        return this.select(db, null, where, order);
    }

    public SelectList<E> select(DB db, SS2005With with, Where where, OrderBy ... order) throws DB.DBException {
        return this.select(db, this.makeSelect(with, where, null, null, order), where, null);
    }

    public SelectList<E> selectGroup(DB db, Where where, GroupBy group, Where having, OrderBy ... order) throws DB.DBException {
        return this.selectGroup(db, null, where, group, having, order);
    }

    public SelectList<E> selectGroup(DB db, SS2005With with, Where where, GroupBy group, Where having, OrderBy ... order) throws DB.DBException {
        if (group == null) {
            group = new GroupBy();
        }
        return this.select(db, this.makeSelect(with, where, group, having, order), where, having);
    }

    public static class SS2005With {
        private String top_hint;
        private ArrayList<String> hint = new ArrayList();

        public SS2005With(String table_hint, String ... table_hint_n) {
            this.top_hint = table_hint;
            for (String n : table_hint_n) {
                this.hint.add(n);
            }
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append("with(").append(this.top_hint);
            for (String n : this.hint) {
                buf.append(",").append(n);
            }
            buf.append(")");
            return buf.toString();
        }
    }

    private static class ViewMake
    extends Thread {
        private HashMap<Class<? extends View>, ViewHolder> map;

        private ViewMake(HashMap<Class<? extends View>, ViewHolder> m) {
            this.map = m;
            this.setDaemon(true);
            this.setPriority(1);
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                try {
                    block8: while (true) {
                        ViewMake.sleep(1000L);
                        ArrayList<ViewHolder> list = new ArrayList<ViewHolder>();
                        HashMap<Class<? extends View>, ViewHolder> hashMap = this.map;
                        synchronized (hashMap) {
                            for (Class<? extends View> key : this.map.keySet()) {
                                list.add(this.map.get(key));
                            }
                        }
                        Iterator i$ = list.iterator();
                        while (true) {
                            if (!i$.hasNext()) continue block8;
                            ViewHolder vh = (ViewHolder)i$.next();
                            try {
                                vh.make();
                            }
                            catch (Exception ie) {}
                        }
                        break;
                    }
                }
                catch (Exception exception) {
                    continue;
                }
                break;
            }
        }
    }

    private static class ViewHolder {
        private View parent;
        private LinkedList<View> list = new LinkedList();
        private volatile int max_count = 3;
        private volatile int once_count = 0;

        ViewHolder(View p) {
            this.parent = p;
            for (int i = 0; i < 5; ++i) {
                this.list.add(p.getInstance());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        View get() {
            View v = null;
            LinkedList<View> linkedList = this.list;
            synchronized (linkedList) {
                ++this.once_count;
                v = this.list.poll();
                if (v == null) {
                    v = this.parent.getInstance();
                }
            }
            return v;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void make() {
            if (this.once_count > this.max_count) {
                this.max_count = this.once_count;
            }
            int cnt = 0;
            LinkedList<View> linkedList = this.list;
            synchronized (linkedList) {
                this.once_count = 0;
                cnt = this.list.size();
            }
            if (cnt >= max_view_limit) {
                return;
            }
            cnt = (int)((double)this.max_count * 1.2) - cnt;
            for (int i = 0; i < cnt; ++i) {
                LinkedList<View> linkedList2 = this.list;
                synchronized (linkedList2) {
                    this.list.add(this.parent.getInstance());
                    continue;
                }
            }
        }
    }
}

