/*
 * Decompiled with CFR 0.152.
 */
package oaks.analysis;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;

public class SqlInformation {
    private static String CR = System.getProperty("line.separator");
    public String SQL;
    public Object[] BIND;
    public Date START = this.END = new Date();
    public Date END;
    public SQLException EXCEPTION = null;
    public Thread THREAD;
    public StackTraceElement[] STACK;

    public SqlInformation(String sql, Object ... obj) {
        this.SQL = sql;
        this.BIND = obj;
        if (this.BIND == null) {
            this.BIND = new Object[0];
        }
        this.THREAD = Thread.currentThread();
        ArrayList<StackTraceElement> list = new ArrayList<StackTraceElement>();
        boolean flag = false;
        for (StackTraceElement st : this.THREAD.getStackTrace()) {
            if (!flag) {
                String name = st.getClassName();
                if ("java.lang.Thread".equals(name)) continue;
                if (name.length() > 5 && !"oaks.".equals(name = name.substring(0, 5))) {
                    flag = true;
                }
            }
            if (!flag) continue;
            list.add(st);
        }
        this.STACK = list.toArray(new StackTraceElement[0]);
    }

    public void close(SQLException ex) {
        if (this.EXCEPTION != null) {
            return;
        }
        this.END = new Date();
        this.EXCEPTION = ex;
    }

    public long getExecMsec() {
        return this.END.getTime() - this.START.getTime();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("-- SqlInformation ---------------------------------------------------");
        buf = buf.append(CR);
        buf = buf.append(this.START.toString()).append(" ~ ").append(this.END.toString()).append("  [").append(this.getExecMsec()).append("ms]").append(CR);
        buf = buf.append(this.SQL).append(CR);
        if (this.BIND.length > 0) {
            buf = buf.append("<BIND>").append(CR);
            for (Object o : this.BIND) {
                buf = o == null ? buf.append("NULL") : buf.append(o.getClass().toString()).append(" / ").append(o.toString());
                buf = buf.append(CR);
            }
        }
        buf = buf.append("<").append(this.THREAD.toString()).append(">").append(CR);
        for (StackTraceElement st : this.STACK) {
            buf = buf.append(st.toString()).append(CR);
        }
        if (this.EXCEPTION != null) {
            buf = buf.append("<SqlException>").append(CR);
            buf = buf.append(this.EXCEPTION.toString()).append(CR);
        }
        return buf.toString();
    }
}

