/*
 * Decompiled with CFR 0.152.
 */
package oaks.make;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.HashMap;
import java.util.Locale;
import oaks.make.DAO;
import oaks.make.DefField;
import oaks.make.DefTable;
import oaks.make.Farm;
import oaks.make.Line;

class AtomTable {
    private static HashMap<String, File> entry = new HashMap();
    private HashMap<String, DefField> fld = new HashMap();
    private DefTable table;
    private File out;
    private static String head = "";

    static String getHead() {
        return head;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void headRead(String filename) {
        if (filename == null) {
            return;
        }
        System.out.print("read:  ");
        System.out.println(filename);
        StringBuilder buf = new StringBuilder();
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(filename));
            String s = null;
            while ((s = br.readLine()) != null) {
                buf = buf.append(s).append(DAO.LF);
            }
            head = buf.toString();
        }
        catch (Exception e) {
            System.out.println("\u30d5\u30a1\u30a4\u30eb\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
            System.exit(1);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    AtomTable(Line l, String p, String r, String c, boolean v) {
        if (c == null) {
            c = r.toUpperCase(Locale.ENGLISH);
        }
        this.table = new DefTable(l, p, r, c, v);
        Farm.getFarm(p).add(this.table);
        this.out = new File(Farm.getFarm(p).getDir(), c + ".java");
        if (entry.put(this.out.toString(), this.out) != null) {
            System.out.print(this.out.toString());
            System.out.println(" \u4e8c\u91cd\u5b9a\u7fa9\u3055\u308c\u3066\u3044\u307e\u3059\u3002");
            System.exit(1);
        }
    }

    void add(DefField f) {
        this.fld.put(f.getFieldName().toUpperCase(Locale.ENGLISH), f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void output() {
        ResultSet rs = null;
        System.out.print(this.table.getName());
        System.out.println(" access");
        try {
            StringBuilder buf = new StringBuilder("select * from ");
            buf = buf.append(this.table.getName());
            buf = buf.append(" where 1=2");
            rs = DAO.db.executeQuery(buf.toString(), new Object[0]);
            ResultSetMetaData meta = rs.getMetaData();
            int cnt = meta.getColumnCount();
            for (int i = 0; i < cnt; ++i) {
                String name = meta.getColumnName(i + 1);
                DefField f = this.fld.remove(name.toUpperCase(Locale.ENGLISH));
                if (f == null) {
                    f = new DefField(name);
                }
                f.setIO(meta.getColumnClassName(i + 1), meta.getPrecision(i + 1), meta.getScale(i + 1));
                this.table.add(f);
            }
            rs.close();
            rs = null;
            boolean flag = false;
            for (String n : this.fld.keySet()) {
                flag = true;
                DefField f = this.fld.get(n);
                System.out.println(f.getLine().toString(f.getFieldName() + " \u304c\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u4e0a\u306b\u5b58\u5728\u3057\u307e\u305b\u3093\u3002"));
            }
            if (flag) {
                System.exit(1);
            }
        }
        catch (Exception e) {
            System.out.println(e.toString());
            System.out.println(this.table.getLine().toString(this.table.getName() + " \u306e\u60c5\u5831\u304c\u53d6\u5f97\u3067\u304d\u307e\u305b\u3093\u3002"));
            System.exit(1);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception e) {}
            }
        }
        PrintWriter pw = null;
        System.out.print("write: ");
        System.out.println(this.out.toString());
        try {
            pw = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.out), DAO.Cmd.SRC_ENC.get())));
            pw.print(head);
            pw.print(this.table.toString());
        }
        catch (Exception e) {
            System.out.println("\u30d5\u30a1\u30a4\u30eb\u66f8\u304d\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
            System.exit(1);
        }
        finally {
            if (pw != null) {
                try {
                    pw.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

