/*
 * Decompiled with CFR 0.152.
 */
package oaks.make;

import java.io.File;
import java.sql.DatabaseMetaData;
import java.util.ArrayList;
import oaks.ConnectionKey;
import oaks.DB;
import oaks.make.AllLine;
import oaks.make.AtomSeq;
import oaks.make.AtomTable;
import oaks.make.DefEnum;
import oaks.make.Version;

public class DAO {
    static final String LF = System.getProperty("line.separator");
    static DB db;
    static File out_dir;

    static String toString(String ... str) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < str.length; ++i) {
            buf = buf.append(str[i]);
        }
        return buf.toString();
    }

    public static void main(String[] argv) {
        System.out.println(Version.getTitle());
        System.out.println(Version.getCopyRight());
        System.out.println("");
        if (argv.length == 0) {
            Cmd.help();
        }
        try {
            for (int i = 0; i < argv.length; ++i) {
                Cmd.append(argv[i]);
            }
            Cmd.check();
        }
        catch (Exception e) {
            Cmd.help();
        }
        try {
            String d = Cmd.DRIVER.get();
            ConnectionKey key = d == null ? new ConnectionKey(Cmd.URL.get(), Cmd.USER.get(), Cmd.PASS.get()) : new ConnectionKey(d, Cmd.URL.get(), Cmd.USER.get(), Cmd.PASS.get());
            db = DB.open(key);
        }
        catch (Exception e) {
            System.err.println("DB\u63a5\u7d9a\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
            System.exit(1);
        }
        try {
            DatabaseMetaData dmd = db.getMetaData();
            StringBuilder buf = new StringBuilder(dmd.getDatabaseProductName());
            buf = buf.append("  ").append(dmd.getDatabaseProductVersion()).append(LF);
            buf = buf.append(dmd.getDriverName()).append(LF);
            buf = buf.append(dmd.getDriverVersion());
            System.out.println(buf.toString());
            System.out.println("");
        }
        catch (Exception e) {
            // empty catch block
        }
        AtomTable.headRead(Cmd.HEAD.get());
        out_dir = new File(Cmd.OUT.get());
        out_dir.mkdirs();
        if (!out_dir.isDirectory()) {
            System.out.println("\u51fa\u529b\u5148\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u304c\u4f5c\u6210\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
            System.exit(1);
        }
        for (String in : Cmd.IN.gets()) {
            AtomSeq atom = new AtomSeq(new AllLine(in));
        }
        AtomSeq.output();
        DefEnum.lastSeek();
        System.out.println("complete.");
    }

    static enum Cmd {
        DRIVER("-driver", false, false, "JDBC\u30c9\u30e9\u30a4\u30d0\u30af\u30e9\u30b9\u540d\u3092\u6307\u5b9a\u3057\u307e\u3059\u3002JDBC4.0\u4ee5\u4e0a\u306e\u5834\u5408\u3001\u4e0d\u8981\u3067\u3059\u3002", new String[0]),
        URL("-url", false, true, "DB\u63a5\u7d9a\u5148URL\u3092\u6307\u5b9a\u3057\u307e\u3059\u3002", new String[0]),
        USER("-user", false, true, "DB\u63a5\u7d9a\u30e6\u30fc\u30b6\u30fc\u540d\u3092\u6307\u5b9a\u3057\u307e\u3059\u3002", ""),
        PASS("-password", false, true, "DB\u63a5\u7d9a\u30d1\u30b9\u30ef\u30fc\u30c9\u3092\u6307\u5b9a\u3057\u307e\u3059\u3002", ""),
        IN("-dao", false, true, "DAO\u5b9a\u7fa9\u30d5\u30a1\u30a4\u30eb\u3092\u6307\u5b9a\u3057\u307e\u3059\u3002", new String[0]),
        SRC_ENC("-src_encode", false, true, "\u51fa\u529b\u30bd\u30fc\u30b9\u30d5\u30a1\u30a4\u30eb\u306e\u6587\u5b57\u30b3\u30fc\u30c9\u3092\u6307\u5b9a\u3057\u307e\u3059\u3002\u30c7\u30d5\u30a9\u30eb\u30c8\u306fUTF-8\u3067\u3059\u3002", "UTF-8"),
        OUT("-out", false, true, "Java\u30bd\u30fc\u30b9\u30d5\u30a1\u30a4\u30eb\u306e\u51fa\u529b\u5148\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u3092\u6307\u5b9a\u3057\u307e\u3059\u3002", "."),
        HEAD("-head", false, false, "\u51fa\u529b\u3059\u308bJava\u30bd\u30fc\u30b9\u30d5\u30a1\u30a4\u30eb\u306e\u5148\u982d\u306b\u633f\u5165\u3059\u308b\u30c6\u30ad\u30b9\u30c8\u30d5\u30a1\u30a4\u30eb\u3092\u6307\u5b9a\u3057\u307e\u3059\u3002\u7701\u7565\u53ef\u80fd\u3067\u3059\u3002", new String[0]);

        private String param;
        private boolean multi_f;
        private boolean must_f;
        private String help;
        private ArrayList<String> data = new ArrayList();
        private static Cmd last;

        private Cmd(String s, boolean f, boolean must, String h, String ... init) {
            this.param = s;
            this.multi_f = f;
            this.must_f = must;
            this.help = h;
            for (int i = 0; i < init.length; ++i) {
                this.data.add(init[i]);
            }
        }

        private void add(String s) {
            this.data.add(s);
        }

        static void append(String s) throws Exception {
            Cmd[] cmd = Cmd.values();
            for (int i = 0; i < cmd.length; ++i) {
                if (!cmd[i].param.equals(s)) continue;
                last = cmd[i];
                return;
            }
            if (last == null) {
                throw new Exception();
            }
            Cmd.last.data.add(s);
        }

        static void help() {
            Cmd[] cmd = Cmd.values();
            System.out.println("java oaks.make.DAO \u30d1\u30e9\u30e1\u30fc\u30bf ...");
            for (int i = 0; i < cmd.length; ++i) {
                System.out.print("  ");
                System.out.println(cmd[i].param);
                System.out.print("    ");
                System.out.println(cmd[i].help);
            }
            System.exit(0);
        }

        static void check() throws Exception {
            Cmd[] cmd = Cmd.values();
            for (int i = 0; i < cmd.length; ++i) {
                if (!cmd[i].must_f || cmd[i].data.size() != 0) continue;
                throw new Exception();
            }
        }

        String get() {
            if (this.data.size() == 0) {
                return null;
            }
            return this.data.get(this.data.size() - 1);
        }

        String[] gets() {
            return this.data.toArray(new String[0]);
        }

        static {
            last = null;
        }
    }
}

