/*
 * Decompiled with CFR 0.152.
 */
package oaks.make;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Locale;
import oaks.ConnectionKey;
import oaks.DB;
import oaks.make.DAO;
import oaks.make.Version;

public class Info {
    public static void main(String[] argv) {
        System.err.println(Version.getTitle());
        System.err.println(Version.getCopyRight());
        System.err.println("");
        if (argv.length == 0) {
            Cmd.help();
        }
        try {
            for (int i = 0; i < argv.length; ++i) {
                Cmd.append(argv[i]);
            }
            Cmd.check();
        }
        catch (Exception e) {
            Cmd.help();
        }
        DB db = null;
        try {
            String d = Cmd.DRIVER.get();
            ConnectionKey key = d == null ? new ConnectionKey(Cmd.URL.get(), Cmd.USER.get(), Cmd.PASS.get()) : new ConnectionKey(d, Cmd.URL.get(), Cmd.USER.get(), Cmd.PASS.get());
            db = DB.open(key);
        }
        catch (Exception e) {
            System.err.println("DB\u63a5\u7d9a\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
            System.exit(1);
        }
        try {
            DatabaseMetaData dmd = db.getMetaData();
            StringBuilder buf = new StringBuilder(dmd.getDatabaseProductName());
            buf = buf.append("  ").append(dmd.getDatabaseProductVersion()).append(DAO.LF);
            buf = buf.append(dmd.getDriverName()).append(DAO.LF);
            buf = buf.append(dmd.getDriverVersion());
            System.err.println(buf.toString());
            System.err.println("");
            Info.getTable(dmd);
        }
        catch (Exception e) {
            System.err.println("DB\u60c5\u5831\u304c\u53d6\u5f97\u3067\u304d\u307e\u305b\u3093\u3002");
            System.exit(1);
        }
    }

    private static void getTable(DatabaseMetaData dmd) throws SQLException {
        ResultSet rs = dmd.getTables(Cmd.CATALOG.get(), "%", "%", null);
        while (rs.next()) {
            String tbl = rs.getString("TABLE_NAME");
            String type = rs.getString("TABLE_TYPE");
            if ("VIEW".equals(type)) {
                System.out.print("view ");
            } else {
                System.out.print("table ");
            }
            System.out.print(tbl);
            System.out.print("\t");
            System.out.print(tbl.toUpperCase(Locale.ENGLISH));
            System.out.println("{");
            Info.getColmun(dmd, tbl);
            System.out.println("}");
            System.out.println("");
        }
        rs.close();
    }

    private static void getColmun(DatabaseMetaData dmd, String name) throws SQLException {
        ResultSet rs = dmd.getColumns(Cmd.CATALOG.get(), null, name, "%");
        while (rs.next()) {
            String fld = rs.getString("COLUMN_NAME");
            System.out.print("\t");
            System.out.print(fld);
            System.out.print("\t");
            System.out.print(fld.toUpperCase(Locale.ENGLISH));
            System.out.println(";");
        }
    }

    private static enum Cmd {
        DRIVER("-driver", false, false, "JDBC\u30c9\u30e9\u30a4\u30d0\u30af\u30e9\u30b9\u540d\u3092\u6307\u5b9a\u3057\u307e\u3059\u3002JDBC4.0\u4ee5\u4e0a\u306e\u5834\u5408\u3001\u4e0d\u8981\u3067\u3059\u3002", new String[0]),
        URL("-url", false, true, "DB\u63a5\u7d9a\u5148URL\u3092\u6307\u5b9a\u3057\u307e\u3059\u3002", new String[0]),
        USER("-user", false, true, "DB\u63a5\u7d9a\u30e6\u30fc\u30b6\u30fc\u540d\u3092\u6307\u5b9a\u3057\u307e\u3059\u3002", ""),
        PASS("-password", false, true, "DB\u63a5\u7d9a\u30d1\u30b9\u30ef\u30fc\u30c9\u3092\u6307\u5b9a\u3057\u307e\u3059\u3002", ""),
        CATALOG("-catalog", false, true, "\u30ab\u30bf\u30ed\u30b0\u540d\u3092\u6307\u5b9a\u3057\u307e\u3059\u3002RDBMS\u88fd\u54c1\u306b\u3088\u308a\u547c\u79f0\u304c\u7570\u306a\u308a\u307e\u3059(DB\u540d\u3001\u30a4\u30f3\u30b9\u30bf\u30f3\u30b9\u540d\u306a\u3069)\u3002", new String[0]);

        private String param;
        private boolean multi_f;
        private boolean must_f;
        private String help;
        private ArrayList<String> data = new ArrayList();
        private static Cmd last;

        private Cmd(String s, boolean f, boolean must, String h, String ... init) {
            this.param = s;
            this.multi_f = f;
            this.must_f = must;
            this.help = h;
            for (int i = 0; i < init.length; ++i) {
                this.data.add(init[i]);
            }
        }

        private void add(String s) {
            this.data.add(s);
        }

        static void append(String s) throws Exception {
            Cmd[] cmd = Cmd.values();
            for (int i = 0; i < cmd.length; ++i) {
                if (!cmd[i].param.equals(s)) continue;
                last = cmd[i];
                return;
            }
            if (last == null) {
                throw new Exception();
            }
            Cmd.last.data.add(s);
        }

        static void help() {
            Cmd[] cmd = Cmd.values();
            System.err.println("java oaks.make.Info \u30d1\u30e9\u30e1\u30fc\u30bf ...");
            for (int i = 0; i < cmd.length; ++i) {
                System.err.print("  ");
                System.err.println(cmd[i].param);
                System.err.print("    ");
                System.err.println(cmd[i].help);
            }
            System.exit(0);
        }

        static void check() throws Exception {
            Cmd[] cmd = Cmd.values();
            for (int i = 0; i < cmd.length; ++i) {
                if (!cmd[i].must_f || cmd[i].data.size() != 0) continue;
                throw new Exception();
            }
        }

        String get() {
            if (this.data.size() == 0) {
                return null;
            }
            return this.data.get(this.data.size() - 1);
        }

        String[] gets() {
            return this.data.toArray(new String[0]);
        }

        static {
            last = null;
        }
    }
}

