/*
 * Oaks
 * Copyright (c) 2012  Akira Terasaki
 * このファイルは同梱されているLicense.txtに定めた条件に
 * 同意できる場合にのみ利用可能です。
 */
package oaks;

import java.text.*;

public abstract class NumberField<E extends Number>  extends Field<E> {
	private static final long serialVersionUID = 1;

	protected NumberField( String n ) {
		super( n );
	}

	/**
	 * 設定値を文字列にして返します。
	 * @param format フォーマット。&quot;#,##0.00&quot;のようなフォーマット。
	 * @return 設定値の文字列表現。
	 */
	public String getString( String format ) {
		Object	val = get();
		if ( val == null )	return null;
		return new DecimalFormat( format ).format( val );
	}

	/**
	 * 文字列を数値に変換して設定します。
	 * @param v 文字列。
	 */
	public abstract void set( String v ) throws NumberFormatException;
}

