/*
 * Oaks
 * Copyright (c) 2012  Akira Terasaki
 * このファイルは同梱されているLicense.txtに定めた条件に
 * 同意できる場合にのみ利用可能です。
 */
package oaks.analysis;

/**
 * SQLログ出力。Collecterの具象クラスです。<br>
 * 単純に、SqlInformationをtoStringしたものを、printlnします。<br>
 * 必要に応じて{@link Collecter#setLogProperty(String,int,int)}して下さい。
 */
public class SqlLog extends Collecter {
	private long ms;

	/**
	 * コンストラクタ。<br>
	 * 全てのSQLを出力対象とします。
	 */
	public SqlLog() {
		this( 0 );
	}
	/**
	 * コンストラクタ。<br>
	 * 指定ミリ秒を超える時間の間、応答が無かったSQLのみを出力対象とします。
	 * @param exec_ms 実行時間。ミリ秒。
	 */
	public SqlLog( long exec_ms ) {
		super();
		ms = exec_ms;
	}

	public void post( SqlInformation info ) {
		if ( info.getExecMsec() < ms )	return;
		println( info.toString() );
	}
}

