/*
 * Oaks
 * Copyright (c) 2012-2014  Akira Terasaki
 * このファイルは同梱されているLicense.txtに定めた条件に
 * 同意できる場合にのみ利用可能です。
 */
package oaks.make;

import java.util.*;
import java.io.*;
import java.sql.*;

class AtomTable {
	private static HashMap<String, File>	entry = new HashMap<String, File>();
	private HashMap<String, DefField>	fld = new HashMap<String, DefField>();
	private DefTable	table;
	private File	out;
	private static String	head = "";

	static String getHead() { return head; }

	static void headRead( String filename ) {
		if ( filename == null )	return;
		System.out.print( "read:  " );
		System.out.println( filename );
		StringBuilder	buf = new StringBuilder();
		BufferedReader	br = null;
		try {
			br = new BufferedReader( new FileReader( filename ) );
			String	s = null;
			while( (s = br.readLine()) != null ) {
				buf = buf.append( s ).append( DAO.LF );
			}
			head = buf.toString();
		}
		catch( Exception e ) {
			System.out.println( "ファイル読み込みに失敗しました。" );
			System.exit( 1 );
		}
		finally {
			if ( br != null ) {
				try {
					br.close();
				}
				catch( Exception e ) {}
			}
		}
	}

	AtomTable( Line l, String p, String r, String c, boolean v ) {
		if ( c == null )	c = r.toUpperCase( Locale.ENGLISH );

		table = new DefTable( l, p, r, c, v );
		Farm.getFarm( p ).add( table );
		out = new File( Farm.getFarm( p ).getDir(),  c + ".java" );
		if ( entry.put( out.toString(), out ) != null ) {
			System.out.print( out.toString() );
			System.out.println( " 二重定義されています。" );
			System.exit( 1 );
		}
	}

	void add( DefField f ) {
		fld.put( f.getFieldName().toUpperCase( Locale.ENGLISH ), f );
	}

	void output() {
		ResultSet	rs = null;
		System.out.print( table.getName() );
		System.out.println( " access" );
		try {
			StringBuilder	buf = new StringBuilder( "select * from " );
			buf = buf.append( table.getName() );
			buf = buf.append( " where 1=2" );
			rs = DAO.db.executeQuery( buf.toString() );
			ResultSetMetaData	meta = rs.getMetaData();
			int	cnt = meta.getColumnCount();
			for ( int i = 0; i < cnt; i++ ) {
				String	name = meta.getColumnName( i + 1 );
				DefField	f = fld.remove( name.toUpperCase( Locale.ENGLISH ) );
				if ( f == null ) {
					f = new DefField( name );
				}
				f.setIO(
					meta.getColumnClassName( i + 1 ),
					meta.getPrecision( i + 1 ),
					meta.getScale( i + 1 )
				);
				table.add( f );
			}
			rs.close();
			rs = null;
			boolean	flag = false;
			for ( String n: fld.keySet() ) {
				flag = true;
				DefField	f = fld.get( n );
				System.out.println( f.getLine().toString( f.getFieldName() + " がデータベース上に存在しません。" ) );
			}
			if ( flag ) System.exit( 1 );
		}
		catch( Exception e ) {
			System.out.println( e.toString() );
			System.out.println( table.getLine().toString( table.getName() + " の情報が取得できません。" ) );
			System.exit( 1 );
		}
		finally {
			if ( rs != null ) {
				try {
					rs.close();
				}
				catch( Exception e ){}
			}
		}

		PrintWriter	pw = null;
		System.out.print( "write: " );
		System.out.println( out.toString() );
		try {
			pw = new PrintWriter( new BufferedWriter(
				new OutputStreamWriter(new FileOutputStream(out), DAO.Cmd.SRC_ENC.get())
			));
			pw.print( head );
			pw.print( table.toString() );
		}
		catch( Exception e ) {
			System.out.println( "ファイル書き込みに失敗しました。" );
			System.exit( 1 );
		}
		finally {
			if ( pw != null ) {
				try {
					pw.close();
				}
				catch( Exception e ) {}
			}
		}
	}
}


class AtomSeq {
	private static ArrayList<AtomTable>	fin = new ArrayList<AtomTable>();

	private String	pack = null;
	private AllLine	all;
	private AtomTable	table = null;
	private DefEnum	def_enum = null;

	void error() {
		Line	l = all.getLine();
		System.out.println( l.toString( "文法が不正です。" ) );
		System.exit( 1 );
	}

	AtomSeq( AllLine al ) {
		String	s = null;
		all = al;
		while( true ) {
			if ( table == null && def_enum == null ) {
				if ( top() )	break;
				continue;
			}
			if ( table != null )	nest();
			else	enum_nest();
		}
		if ( table != null || def_enum != null ) {
			System.out.println( all.getLine().toString( "{}が閉じていません。" ) );
		}
	}

	private boolean top() {
		String	s = all.getWord();
		if ( s == null )	return true;
		if ( "package".equals( s ) ) {
			String[]	str = new String[]{ all.getWord(), all.getWord() };
			if ( str[0] == null || !";".equals( str[1] ) )	error();
			pack = str[0];
			String[]	p = pack.split( "\\." );
			for ( String ss: p ) {
				if ( JavaDefine.isDefine( ss, true ) ) {
					System.out.println( all.getLine().toString( pack + " はパッケージ名に使用できません。" ) );
					System.exit( 1 );
				}
			}
			return false;
		}
		boolean	view_f = false;
		if ( "table".equals( s ) )	view_f = false;
		else if ( "view".equals( s ) )	view_f = true;
		else if ( "enum".equals( s ) )	return enumer();
		else	error();
		String[]	str = new String[] { all.getWord(), all.getWord() };
		if ( str[0] == null || str[1] == null )	error();
		if ( "{".equals( str[1] ) ) {
			table = new AtomTable( all.getLine(), pack, str[0], null, view_f );
			return false;
		}
		if ( !"{".equals( all.getWord() ) )	error();
		table = new AtomTable( all.getLine(), pack, str[0], str[1], view_f );
		return false;
	}

	private boolean enumer() {
		String[]	str = new String[] { all.getWord(), all.getWord() };
		if ( str[0] == null || str[1] == null )	error();
		if ( "{".equals( str[1] ) ) {
			def_enum = new DefEnum( all.getLine(), str[0], null );
			Farm.getFarm( pack ).add( def_enum );
			return false;
		}
		if ( !"{".equals( all.getWord() ) )	error();
		def_enum = new DefEnum( all.getLine(), str[0], str[1] );
		Farm.getFarm( pack ).add( def_enum );
		return false;
	}

	private void nest() {
		String	s = all.getWord();
		if ( "}".equals( s ) ) {
			fin.add( table );
			table = null;
			return;
		}
		String[]	next = new String[]{ all.getWord(), all.getWord() };
		if ( !";".equals( next[1] ) )	error();
		table.add( new DefField( all.getLine(), s, next[0] ) );
	}

	private void enum_nest() {
		String	s = all.getWord();
		if ( "}".equals( s ) ) {
			if ( def_enum.getCount() == 0 ) {
				System.out.println( all.getLine().toString( "メンバ定義がありません。" ) );
				System.exit( 1 );
			}
			def_enum = null;
			return;
		}
		if ( JavaDefine.isDefine( s, true ) ) {
			System.out.println( all.getLine().toString( s +
				" は定数名に使用できません。"
			) );
			System.exit( 1 );
		}
		String[]	next = new String[]{ all.getWord(), all.getWord() };
		if ( !";".equals( next[1] ) )	error();
		def_enum.add( all.getLine(), s, next[0] );
	}

	static void output() {
		for ( AtomTable t: fin ) {
			t.output();
		}
		Farm.output();
	}
}


