/*
 * Oaks
 * Copyright (c) 2012-2014  Akira Terasaki
 * このファイルは同梱されているLicense.txtに定めた条件に
 * 同意できる場合にのみ利用可能です。
 */
package oaks.make;

import oaks.*;
import java.util.*;
import java.io.*;
import java.sql.*;

public class DAO {
	enum Cmd {
		DRIVER( "-driver", false, false,
			"JDBCドライバクラス名を指定します。JDBC4.0以上の場合、不要です。"
		),
		URL( "-url", false, true,
			"DB接続先URLを指定します。"
		),
		USER( "-user", false, true,
			"DB接続ユーザー名を指定します。",
			""
		),
		PASS( "-password", false, true,
			"DB接続パスワードを指定します。",
			""
		),
		IN( "-dao", false, true,
			"DAO定義ファイルを指定します。"
		),
		SRC_ENC( "-src_encode", false, true,
			"出力ソースファイルの文字コードを指定します。デフォルトはUTF-8です。",
			"UTF-8"
		),
		OUT( "-out", false, true,
			"Javaソースファイルの出力先ディレクトリを指定します。",
			"."
		),
		HEAD( "-head", false, false,
			"出力するJavaソースファイルの先頭に挿入するテキストファイルを指定します。省略可能です。"
		);

		private String param;
		private boolean multi_f;
		private boolean must_f;
		private String	help;
		private ArrayList<String>	data = new ArrayList<String>();
		private static Cmd	last = null;

		private Cmd( String s, boolean f, boolean must, String h, String ... init ) {
			param = s;
			multi_f = f;
			must_f = must;
			help = h;
			for ( int i = 0; i < init.length; i++ ) {
				data.add( init[i] );
			}
		}
		private void add( String s ) {
			data.add( s );
		}
		static void append( String s ) throws Exception {
			Cmd[]	cmd = values();
			for ( int i = 0; i < cmd.length; i++ ) {
				if ( cmd[i].param.equals( s ) ) {
					last = cmd[i];
					return;
				}
			}
			if ( last == null )	throw new Exception();
			last.data.add( s );
		}
		static void help() {
			Cmd[]	cmd = values();
			System.out.println( "java oaks.make.DAO パラメータ ..." );
			for ( int i = 0; i < cmd.length; i++ ) {
				System.out.print( "  " );
				System.out.println( cmd[i].param );
				System.out.print( "    " );
				System.out.println( cmd[i].help );
				
			}
			System.exit( 0 );
		}
		static void check() throws Exception {
			Cmd[]	cmd = values();
			for ( int i = 0; i < cmd.length; i++ ) {
				if ( !cmd[i].must_f )	continue;
				if ( cmd[i].data.size() == 0 )	throw new Exception();
			}
		}
		String	get() {
			if ( data.size() == 0 )	return null;
			return data.get( data.size() - 1 );
		}
		String[] gets() {
			return data.toArray( new String[0] );
		}
	}

	static final String	LF = System.getProperty( "line.separator" );
	static String toString( String ... str ) {
		StringBuilder	buf = new StringBuilder();
		for ( int i = 0; i < str.length; i++ ) {
			buf = buf.append( str[i] );
		}
		return buf.toString();
	}

	static DB	db;
	static File	out_dir;

	public static void main( String[] argv ) {
		System.out.println( Version.getTitle() );
		System.out.println( Version.getCopyRight() );
		System.out.println( "" );
		if ( argv.length == 0 )	Cmd.help();
		try {
			for ( int i = 0; i <  argv.length; i++ ) {
				Cmd.append( argv[i] );
			}
			Cmd.check();
		}
		catch( Exception e ) {
			Cmd.help();
		}

		try {
			String	d = Cmd.DRIVER.get();
			ConnectionKey	key = ( d == null )?
				new ConnectionKey( Cmd.URL.get(), Cmd.USER.get(), Cmd.PASS.get() ):
				new ConnectionKey( d, Cmd.URL.get(), Cmd.USER.get(), Cmd.PASS.get() );
			db = DB.open( key );
		}
		catch( Exception e ) {
			System.err.println( "DB接続に失敗しました。" );
			System.exit( 1 );
		}
		try {
			DatabaseMetaData	dmd = db.getMetaData();
			StringBuilder	buf = new StringBuilder( dmd.getDatabaseProductName() );
			buf = buf.append( "  " ).append( dmd.getDatabaseProductVersion() ).append( DAO.LF );
			buf = buf.append( dmd.getDriverName() ).append( DAO.LF );
			buf = buf.append( dmd.getDriverVersion() );
			System.out.println( buf.toString() );
			System.out.println( "" );
		}
		catch( Exception e ){}

		AtomTable.headRead( Cmd.HEAD.get() );

		out_dir = new File( Cmd.OUT.get() );
		out_dir.mkdirs();
		if ( !out_dir.isDirectory() ) {
			System.out.println( "出力先ディレクトリが作成できませんでした。" );
			System.exit( 1 );
		}

		for ( String in: Cmd.IN.gets() ) {
			AtomSeq atom = new AtomSeq( new AllLine( in ) );
		}
		AtomSeq.output();
		DefEnum.lastSeek();
		System.out.println( "complete." );
	}
}

