/*
 * Oaks
 * Copyright (c) 2012  Akira Terasaki
 * このファイルは同梱されているLicense.txtに定めた条件に
 * 同意できる場合にのみ利用可能です。
 */
package oaks.make;

import oaks.*;
import java.sql.*;
import java.util.*;


public class Info {
	private enum Cmd {
		DRIVER( "-driver", false, false,
			"JDBCドライバクラス名を指定します。JDBC4.0以上の場合、不要です。"
		),
		URL( "-url", false, true,
			"DB接続先URLを指定します。"
		),
		USER( "-user", false, true,
			"DB接続ユーザー名を指定します。",
			""
		),
		PASS( "-password", false, true,
			"DB接続パスワードを指定します。",
			""
		),
		CATALOG( "-catalog", false, true,
			"カタログ名を指定します。RDBMS製品により呼称が異なります(DB名、インスタンス名など)。"
		);

		private String param;
		private boolean multi_f;
		private boolean must_f;
		private String	help;
		private ArrayList<String>	data = new ArrayList<String>();
		private static Cmd	last = null;

		private Cmd( String s, boolean f, boolean must, String h, String ... init ) {
			param = s;
			multi_f = f;
			must_f = must;
			help = h;
			for ( int i = 0; i < init.length; i++ ) {
				data.add( init[i] );
			}
		}
		private void add( String s ) {
			data.add( s );
		}
		static void append( String s ) throws Exception {
			Cmd[]	cmd = values();
			for ( int i = 0; i < cmd.length; i++ ) {
				if ( cmd[i].param.equals( s ) ) {
					last = cmd[i];
					return;
				}
			}
			if ( last == null )	throw new Exception();
			last.data.add( s );
		}
		static void help() {
			Cmd[]	cmd = values();
			System.err.println( "java oaks.make.Info パラメータ ..." );
			for ( int i = 0; i < cmd.length; i++ ) {
				System.err.print( "  " );
				System.err.println( cmd[i].param );
				System.err.print( "    " );
				System.err.println( cmd[i].help );
				
			}
			System.exit( 0 );
		}
		static void check() throws Exception {
			Cmd[]	cmd = values();
			for ( int i = 0; i < cmd.length; i++ ) {
				if ( !cmd[i].must_f )	continue;
				if ( cmd[i].data.size() == 0 )	throw new Exception();
			}
		}
		String	get() {
			if ( data.size() == 0 )	return null;
			return data.get( data.size() - 1 );
		}
		String[] gets() {
			return data.toArray( new String[0] );
		}
	}

	public static void main( String[] argv ) {
		System.err.println( Version.getTitle() );
		System.err.println( Version.getCopyRight() );
		System.err.println( "" );
		if ( argv.length == 0 )	Cmd.help();
		try {
			for ( int i = 0; i <  argv.length; i++ ) {
				Cmd.append( argv[i] );
			}
			Cmd.check();
		}
		catch( Exception e ) {
			Cmd.help();
		}

		DB	db = null;
		try {
			String	d = Cmd.DRIVER.get();
			ConnectionKey	key = ( d == null )?
				new ConnectionKey( Cmd.URL.get(), Cmd.USER.get(), Cmd.PASS.get() ):
				new ConnectionKey( d, Cmd.URL.get(), Cmd.USER.get(), Cmd.PASS.get() );
			db = DB.open( key );
		}
		catch( Exception e ) {
			System.err.println( "DB接続に失敗しました。" );
			System.exit( 1 );
		}
		try {
			DatabaseMetaData	dmd = db.getMetaData();
			StringBuilder	buf = new StringBuilder( dmd.getDatabaseProductName() );
			buf = buf.append( "  " ).append( dmd.getDatabaseProductVersion() ).append( DAO.LF );
			buf = buf.append( dmd.getDriverName() ).append( DAO.LF );
			buf = buf.append( dmd.getDriverVersion() );
			System.err.println( buf.toString() );
			System.err.println( "" );
			getTable( dmd );
		}
		catch( Exception e ){
			System.err.println( "DB情報が取得できません。" );
			System.exit( 1 );
		}
	}

	private static void getTable( DatabaseMetaData dmd ) throws SQLException {
		ResultSet	rs = dmd.getTables( Cmd.CATALOG.get(), "%", "%", null );
		while( rs.next() ) {
			String	tbl = rs.getString( "TABLE_NAME" );
			String	type = rs.getString( "TABLE_TYPE" );
			if ( "VIEW".equals( type ) )	System.out.print( "view " );
			else	System.out.print( "table " );
			System.out.print( tbl );
			System.out.print( "\t" );
			System.out.print( tbl.toUpperCase( Locale.ENGLISH ) );
			System.out.println( "{" );
			getColmun( dmd, tbl );
			System.out.println( "}" );
			System.out.println( "" );
		}
		rs.close();
	}

	private static void getColmun( DatabaseMetaData dmd, String name ) throws SQLException {
		ResultSet	rs = dmd.getColumns( Cmd.CATALOG.get(), null, name, "%" );
		while( rs.next() ) {
			String	fld = rs.getString( "COLUMN_NAME" );
			System.out.print( "\t" );
			System.out.print( fld );
			System.out.print( "\t" );
			System.out.print( fld.toUpperCase( Locale.ENGLISH ) );
			System.out.println( ";" );
		}
	}
}

