/*
 * Copyright (c) 2003 The Ochusha Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: main.c,v 1.8 2003/12/05 08:45:58 fuyu Exp $
 */

#include "config.h"

#include "ochusha_private.h"
#include "ochusha.h"
#include "htmlutils.h"
#include "worker.h"
#include "utils.h"

#include "ochusha_ui.h"

#include <glib.h>
#include <gtk/gtk.h>
#include <libxml/parser.h>

#include <stdio.h>
#include <stdlib.h>


#define INITIAL_NUM_THREADS	2
#define MAXIMUM_NUM_THREADS	32



int
main(int argc, char *argv[])
{
  gchar *resource_file;
  OchushaApplication *application;

#if TRACE_MEMORY_USAGE
  init_memory_trace();
#endif

  application = G_NEW0(OchushaApplication, 1);
  ochusha_config_prepare_home(&application->config);
  gtk_rc_add_default_file(PKGDATADIR "/" OCHUSHA_GTKRC);

  g_thread_init(NULL);
  gdk_threads_init();
  gtk_set_locale();
  gtk_init(&argc, &argv);
  bindtextdomain(PACKAGE_NAME, LOCALEDIR);
  textdomain(PACKAGE_NAME);

  bind_textdomain_codeset(PACKAGE_NAME, "UTF-8");

  xmlInitParser();

  initialize_default_entity_dictionary();
  initialize_common_converters();
  initialize_worker(INITIAL_NUM_THREADS, MAXIMUM_NUM_THREADS);

  resource_file = ochusha_config_find_file(&application->config,
					   OCHUSHA_GTKRC);
  if (resource_file != NULL)
    {
      gtk_rc_parse(resource_file);
      G_FREE(resource_file);
    }

  ochusha_init_application(application);

  gdk_threads_enter();
  gtk_main();

#if TRACE_MEMORY_USAGE
  if (application->top_level != NULL)
    gtk_widget_destroy(GTK_WIDGET(application->top_level));
#endif

  gdk_threads_leave();

  terminate_workers();
  xmlCleanupParser();

#if TRACE_MEMORY_USAGE
  g_object_unref(G_OBJECT(application->table));
  application->table = NULL;
  g_object_unref(G_OBJECT(application->broker));
  application->broker = NULL;

  G_FREE(application->threadlist_view_contents);
  application->threadlist_view_contents = NULL;
  G_FREE(application->user_default_filter.rule);
  application->user_default_filter.rule = NULL;
  G_FREE(application->web_browser_template);
  application->web_browser_template = NULL;
  G_FREE(application->config.home);
  application->config.home = NULL;
  G_FREE(application->config.bbsmenu_url);
  application->config.bbsmenu_url = NULL;
  G_FREE(application->config.proxy_url);
  application->config.proxy_url = NULL;
  G_FREE(application->config.proxy_user);
  application->config.proxy_user = NULL;
  G_FREE(application->config.proxy_password);
  application->config.proxy_password = NULL;

  if (application->last_name != NULL)
    {
      G_FREE(application->last_name);
      application->last_name = NULL;
    }

  if (application->last_mail != NULL)
    {
      G_FREE(application->last_mail);
      application->last_mail = NULL;
    }

  G_FREE(application);

  dump_pointers();
#endif

  return 0;
}
