/*
 * Copyright (c) 2003-2004 The Ochusha Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: icon_label.h,v 1.5 2004/01/15 02:18:05 fuyu Exp $
 */

#ifndef _ICON_LABEL_H_
#define _ICON_LABEL_H_

#include <gtk/gtk.h>
#include <glib.h>

#ifdef __cplusplus
extern "C" {
#endif


#define ICON_LABEL_TYPE			(icon_label_get_type())
#define ICON_LABEL(obj)			(G_TYPE_CHECK_INSTANCE_CAST((obj), ICON_LABEL_TYPE, IconLabel))
#define ICON_LABEL_CLASS(klass)		(G_TYPE_CHECK_CLASS_CAST((klass), ICON_LABEL_TYPE, IconLabelClass))
#define IS_ICON_LABEL(obj)		(G_TYPE_CHECK_INSTANCE_TYPE((obj), ICON_LABEL_TYPE))
#define IS_ICON_LABEL_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE((klass), ICON_LABEL_TYPE))
#define ICON_LABEL_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS((obj), ICON_LABEL_TYPE, IconLabelClass))


typedef struct _IconLabel IconLabel;
typedef struct _IconLabelClass IconLabelClass;

struct _IconLabel
{
  GtkLabel label;
  GtkAllocation fake_allocation;

  GdkPixbuf *icon;
  int icon_y_adjustment;
};


struct _IconLabelClass
{
  GtkLabelClass parent_class;
};


GType icon_label_get_type(void);

GtkWidget *icon_label_new(const gchar *label_text, GdkPixbuf *icon);
void icon_label_set_icon(IconLabel *icon_label, GdkPixbuf *icon);


#ifdef __cplusplus
} // extern "C"
#endif

#endif	/* _ICON_LABEL_H_ */
