/*
 * Copyright (c) 2003-2004 The Ochusha Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: regex_utils.h,v 1.3 2004/01/15 02:18:05 fuyu Exp $
 */

#ifndef _REGEX_UTILS_H_
#define _REGEX_UTILS_H_

#include "config.h"

#include <gtk/gtk.h>

#ifdef __cplusplus
extern "C" {
#endif

#define REGEX_EDITOR_TYPE		(regex_editor_get_type())
#define REGEX_EDITOR(obj)		(G_TYPE_CHECK_INSTANCE_CAST((obj), REGEX_EDITOR_TYPE, RegexEditor))
#define REGEX_EDITOR_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST((klass), REGEX_EDITOR_TYPE, RegexEditorClass))
#define IS_REGEX_EDITOR(obj)		(G_TYPE_CHECK_INSTANCE_TYPE((obj), REGEX_EDITOR_TYPE))
#define IS_REGEX_EDITOR_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE((klass), REGEX_EDITOR_TYPE))
#define REGEX_EDITOR_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS((obj), REGEX_EDITOR_TYPE, RegexEditorClass))


typedef struct _RegexEditor RegexEditor;
typedef struct _RegexEditorClass RegexEditorClass;


struct _RegexEditor
{
  GtkVBox vbox;

  GtkTextBuffer *regex_buffer;
  GtkLabel *message;

  gpointer expression;	/* ΤȤ̤ */
};


struct _RegexEditorClass
{
  GtkVBoxClass parent_class;
};


GType regex_editor_get_type(void);
GtkWidget *regex_editor_new(const gchar *regex_text);
void regex_editor_set_regex_text(RegexEditor *editor, const gchar *text);
gchar *regex_editor_get_regex_text(RegexEditor *editor);

/*
 * onigurumaPOSIX APInative APIƱפǤ϶¸ǤʤΤǡ
 * ǤgpointerˤƤ롣谷ա
 */
gpointer oniguruma_regex_new(const gchar *pattern, const char *encoding);
void oniguruma_regex_free(gpointer oniguruma_regex);
gboolean oniguruma_regex_match(gpointer oniguruma_regex, const char *text);


#ifdef __cplusplus
} // extern "C"
#endif

#endif	/* _REGEX_UTILS_H_ */
