﻿using System;
using System.Text;
using System.Linq;
using System.Windows.Forms;
using System.Collections.Generic;
using System.Text.RegularExpressions;
using System.ComponentModel.Composition;

/** \brief ゲームオンのプラグインの名前空間 */
namespace OGSNET.Plugins.GameOn
{
    using OGSNET.Plugin;

    /** \brief GameOnの運営プラグイン */
    [Export(typeof(IPlugin))]
    [Export(typeof(IOperationPlugin))]
    [ExportMetadata("PluginId", "GameOn")]
    public class Operation : OperationPluginBase
    {
        /** \brief 基本情報の初期化 */
        public Operation()
        {
            this.PluginInfo =
                new PluginInfo(new Version(1), "ゲームオン運営プラグイン", "pine",
                    "ゲームオンが運営しているゲームの開始に使用されます。");

            this.OperationInfo =
                new OperationInfo("ゲームオン", "http://www.gamechu.jp/");
        }

        /** \brief ログイン処理をを開始する */
        protected override void StartPlugin()
        {
            // トップページを読み込む
            this.LoadTopPage();
        }

        /** \brief トップページを読み込む */
        private void LoadTopPage()
        {
            this.StartCallback(CallbackStatus.Notice, "ゲームチュートップページにアクセスしています");
            this.Navigate(this.OperationInfo.Url, this.LoginOrLogout);
        }

        /** ログインフォームの存在をチェックし、ログインまたはログアウトする */
        private void LoginOrLogout()
        {
            this.RemoveAction(this.OperationInfo.Url);

            var forms = this.Document.All.GetElementsByName("fo_login");

            // 未ログイン
            if (forms.Count > 0)
            {
                this.StartCallback(CallbackStatus.Notice, "ゲームチューへログインしています。");

                var elements = forms[0].GetElementsByTagName("input").Cast<HtmlElement>();

                foreach (var element in elements)
                {
                    if (element.Name == "accountid")
                    {
                        element.SetAttribute("value", this.UserName);
                    }
                    else if (element.Name == "passwd")
                    {
                        element.SetAttribute("value", this.Password);
                    }
                }

                this.AddAction(new Regex("^http://www.gamechu.jp/immortal/login/otkinfo"), this.EndLogin);

                object [] arg = { false };
                this.Document.InvokeScript("fo_finish", arg); // submit
            }
            else
            {
                this.StartCallback(CallbackStatus.Notice, "ゲームチューからログアウトしています。");
                this.Navigate("http://www.gamechu.jp/immortal/login/logout", this.EndLogout);
            }
        }

        /** \brief ログイン処理を終了する */
        private void EndLogin()
        {
            this.ClearAction();
            this.StartCallback(CallbackStatus.Finish, "ゲームチューへのログインに成功しました。");   
        }

        /** \brief ログアウト後の処理を行う */
        private void EndLogout()
        {
            this.RemoveAction("http://www.gamechu.jp/immortal/login/logout");
            this.StartCallback(CallbackStatus.Notice, "ゲームチューからのログアウトに成功しました。");
            this.LoadTopPage();
        }
    }
}
