﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ComponentModel.Composition;

namespace OGSNET.Plugins.Hangame
{
    using OGSNET.Plugin;

    /** \brief アラド戦記のプラグイン */
    [Export(typeof(IPlugin))]
    [Export(typeof(IGamePlugin))]
    [ExportMetadata("PluginId", "Hangame.Arad")]
    public class Arad : GamePluginBase
    {
        /** \brief 基本情報の初期化 */
        public Arad()
        {
            this.PluginInfo =
                new PluginInfo(new Version(1), "アラド戦記 (ハンゲーム) 起動プラグイン", "pine",
                    "アラド戦記 (ハンゲーム) の起動に使用されます。");

            this.GameInfo =
                new GameInfo("ハンゲーム", "Hangame", "アラド戦記", "http://arad.hangame.co.jp/");
        }

        /** \brief ログインを開始する */
        protected override void StartPlugin()
        {
            this.CallPlugin("Hangame", this.GameStartPage);
        }

        /** \brief ゲーム開始ページへ移動 */
        private void GameStartPage()
        {
            this.StartCallback(CallbackStatus.Notice, "ゲーム開始ページへ移動しています。");
            this.Navigate("http://arad.hangame.co.jp/externalStartGame.nhn", this.GameStart,
                "http://www.arad.jp/channeling/nhn/game_start.asp");
        }

        /** \brief ゲームを開始する */
        private void GameStart()
        {
            this.StartCallback(CallbackStatus.Notice, "ゲームを開始しています。");
            this.Navigate("http://www.arad.jp/channeling/launcher/game/game_start.asp", this.Finish,
                "http://www.arad.jp/module/common/_blank.asp");
        }

        /** \brief 終了処理 */
        private void Finish()
        {
            this.StartCallback(CallbackStatus.Finish, "アラド戦記の起動に成功しました。");
        }
    }

    /** \brief エルソードのプラグイン */
    [Export(typeof(IPlugin))]
    [Export(typeof(IGamePlugin))]
    [ExportMetadata("PluginId", "Hangame.Elsword")]
    public class Elsword : GamePluginBase
    {
        /** \brief 基本情報の初期化 */
        public Elsword()
        {
            this.PluginInfo =
                new PluginInfo(new Version(1), "エルソード 起動プラグイン", "pine",
                    "エルソードの起動に使用されます。");

            this.GameInfo =
                new GameInfo("ハンゲーム", "Hangame", "エルソード", "http://elsword.hangame.co.jp/");
        }

        /** \brief ログインを開始する */
        protected override void StartPlugin()
        {
            this.CallPlugin("Hangame", new Action(this.GameStart));
        }

        /** \brief ゲームを開始する */
        private void GameStart()
        {
            this.StartCallback(CallbackStatus.Notice, "ゲームを開始しています。");
            this.Navigate("http://elsword.hangame.co.jp/gamestart.nhn", new Action(this.Finish));
        }

        /** \brief 終了処理 */
        private void Finish()
        {
            this.StartCallback(CallbackStatus.Finish, "ゲームの起動に成功しました。");
        }

    }

}
