﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ComponentModel.Composition;

namespace OGSNET.Plugins.Mgame
{
    using OGSNET.Plugin;

    /** \brief エムゲーム ゲームプラグイン ベースクラス */
    public class MgameBase : GamePluginBase
    {
        /** \brief プラグインを開始する */
        protected override void StartPlugin()
        {
            // ログイン
            this.CallPlugin("Mgame", this.LoadTopPage);
        }

        /** \brief トップページを読み込む */
        private void LoadTopPage()
        {
            this.Notice("トップページを読み込んでいます。");
            this.Navigate(this.GameInfo.Url, this.GameStart);
        }

        /** \brief ゲームを開始する */
        private void GameStart()
        {
            // アクションをクリア
            this.ClearAction();

            this.EndPlugin("ゲームを開始します。");

            // 開始関数を呼ぶ
            this.Document.InvokeScript(this.GameStartFunction);
        }

        /** \brief ゲーム開始関数名 */
        protected string GameStartFunction
        {
            get;
            set;
        }
    }

    /** \brief KNIGHT ONLINE Xross 起動プラグイン */
    [Export(typeof(IPlugin))]
    [Export(typeof(IGamePlugin))]
    [ExportMetadata("PluginId", "Mgame.KnightOnline")]
    public class KnightOnline : MgameBase
    {
        public KnightOnline()
        {
            this.PluginInfo =
                new PluginInfo(new Version(1), "KNIGHT ONLINE Xross (エムゲーム) 起動プラグイン", "pine",
                    "KNIGHT ONLINE Xross (エムゲーム) を起動するプラグインです。");

            this.GameInfo =
                new GameInfo("エムゲーム", "Mgame", "KNIGHT ONLINE Xross", "http://knight.mgame.jp/member/");

            this.GameStartFunction = "LaunchKnight";
        }
    }

    /** \brief LOST ONLINE REBIRTH 起動プラグイン */
    [Export(typeof(IPlugin))]
    [Export(typeof(IGamePlugin))]
    [ExportMetadata("PluginId", "Mgame.LostOnlineRebirth")]
    public class LostOnlineRebirth : MgameBase
    {
        public LostOnlineRebirth()
        {
            this.PluginInfo =
                new PluginInfo(new Version(1), "LOST ONLINE REBIRTH (エムゲーム) 起動プラグイン", "pine",
                    "LOST ONLINE REBIRTH (エムゲーム) を起動するプラグインです。");

            this.GameInfo =
                new GameInfo("エムゲーム", "Mgame", "LOST ONLINE REBIRTH", "http://lostonline.mgame.jp/");

            this.GameStartFunction = "LaunchLostOnline";
        }
    }

    /** \brief 英雄 起動プラグイン */
    [Export(typeof(IPlugin))]
    [Export(typeof(IGamePlugin))]
    [ExportMetadata("PluginId", "Mgame.Hero")]
    public class Hero : MgameBase
    {
        public Hero()
        {
            this.PluginInfo =
                new PluginInfo(new Version(1), "英雄 (エムゲーム) 起動プラグイン", "pine",
                    "英雄 (エムゲーム) を起動するプラグインです。");

            this.GameInfo =
                new GameInfo("エムゲーム", "Mgame", "英雄", "http://hero.mgame.jp/");

            this.GameStartFunction = "LaunchHero";
        }
    }

    /** \brief OPERATION 7 起動プラグイン */
    [Export(typeof(IPlugin))]
    [Export(typeof(IGamePlugin))]
    [ExportMetadata("PluginId", "Mgame.Operation7")]
    public class Operation7 : MgameBase
    {
        public Operation7()
        {
            this.PluginInfo =
                new PluginInfo(new Version(1), "OPERATION 7 (エムゲーム) 起動プラグイン", "pine",
                    "OPERATION 7 (エムゲーム) を起動するプラグインです。");

            this.GameInfo =
                new GameInfo("エムゲーム", "Mgame", "OPERATION 7", "http://op7.mgame.jp/");

            this.GameStartFunction = "LaunchOP7";
        }
    }

    /** \brief ルナティア 起動プラグイン */
    [Export(typeof(IPlugin))]
    [Export(typeof(IGamePlugin))]
    [ExportMetadata("PluginId", "Mgame.Lunatia")]
    public class Lunatia : MgameBase
    {
        public Lunatia()
        {
            this.PluginInfo =
                new PluginInfo(new Version(1), "ルナティア (エムゲーム) 起動プラグイン", "pine",
                    "ルナティア (エムゲーム) を起動するプラグインです。");

            this.GameInfo =
                new GameInfo("エムゲーム", "Mgame", "ルナティア", "http://lunatia.mgame.jp/");

            this.GameStartFunction = "LaunchLunatia";
        }
    }

    /** \brief 熱血江湖オンライン 起動プラグイン */
    [Export(typeof(IPlugin))]
    [Export(typeof(IGamePlugin))]
    [ExportMetadata("PluginId", "Mgame.Yulgang")]
    public class Yulgang : MgameBase
    {
        public Yulgang()
        {
            this.PluginInfo =
                new PluginInfo(new Version(1), "熱血江湖オンライン (エムゲーム) 起動プラグイン", "pine",
                    "熱血江湖オンライン (エムゲーム) を起動するプラグインです。");

            this.GameInfo =
                new GameInfo("エムゲーム", "Mgame", "熱血江湖オンライン", "http://nkonline.mgame.jp/");

            this.GameStartFunction = "LaunchYulgang";
        }
    }

    /** \brief 鬼魂 起動プラグイン */
    [Export(typeof(IPlugin))]
    [Export(typeof(IGamePlugin))]
    [ExportMetadata("PluginId", "Mgame.Onidama")]
    public class Onidama : MgameBase
    {
        public Onidama()
        {
            this.PluginInfo =
                new PluginInfo(new Version(1), "鬼魂 (エムゲーム) 起動プラグイン", "pine",
                    "鬼魂 (エムゲーム) を起動するプラグインです。");

            this.GameInfo =
                new GameInfo("エムゲーム", "Mgame", "鬼魂", "http://onidama.mgame.jp/");

            this.GameStartFunction = "LaunchOnidama";
        }
    }

    /** \brief ラピスオンライン 起動プラグイン */
    [Export(typeof(IPlugin))]
    [Export(typeof(IGamePlugin))]
    [ExportMetadata("PluginId", "Mgame.Lapis")]
    public class Lapis : MgameBase
    {
        public Lapis()
        {
            this.PluginInfo =
                new PluginInfo(new Version(1), "ラピスオンライン (エムゲーム) 起動プラグイン", "pine",
                    "ラピスオンライン (エムゲーム) を起動するプラグインです。");

            this.GameInfo =
                new GameInfo("エムゲーム", "Mgame", "ラピスオンライン", "http://lapis.mgame.jp/");

            this.GameStartFunction = "LaunchLapis";
        }
    }
}