﻿using System;
using System.Collections.Generic;
using System.ComponentModel.Composition;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace OGSNET.Plugins.Nexon
{
    using OGSNET.Plugin;

    /** \brief アラド戦記のプラグイン */
    [Export(typeof(IPlugin))]
    [Export(typeof(IGamePlugin))]
    [ExportMetadata("PluginId", "Nexon.Arad")]
    public class Arad : GamePluginBase
    {
        public Arad() {
            this.PluginInfo =
                new PluginInfo(new Version(1), "アラド戦記 (ネクソン) 起動プラグイン",
                    "アラド戦記 (ネクソン) を起動するプラグインです。ハンゲームの ID を用いる場合には利用できません。");

            this.GameInfo =
                new GameInfo("ネクソン", "Nexon", "アラド戦記", "http://www.arad.jp/");
        }

        /** \brief プラグインを開始する */
        protected override void StartPlugin()
        {
            this.LoadLoginPage();
        }

        /** \brief ログインページを読み込む */
        private void LoadLoginPage()
        {
            this.ClearAction();
            this.Notice("アラド戦記公式サイトへ接続しています。");
            this.Navigate("http://www.arad.jp/guide/about.asp", this.LoginPage);
        }

        /** \brief ログインページへ移動した後の処理 */
        private void LoginPage()
        {
            this.ClearAction();

            // ログインフォームを取得
            var form = this.Document.GetElementById("frmLogin");

            // ログイン済み
            if (form == null)
            {
                this.Notice("ログアウトしています。");

                var logoutBtn = this.Document.GetElementById("frmLogout");

                if (logoutBtn == null)
                {
                    this.Error("ネクソンからのログアウトに失敗しました。");
                    return;
                }

                // ログアウトフォームを送信
                this.AddAction("http://www.arad.jp/guide/about.asp", this.EndLogout);
                logoutBtn.InvokeMember("submit");
            }
            else // 未ログイン
            {
                this.Notice("ネクソンにログインしています。");

                var userWrap = this.Document.GetElementById("login-id-input");
                var passWrap = this.Document.GetElementById("login-pw-input");

                if (userWrap == null || passWrap == null)
                {
                    this.Error("ネクソンへのログインに失敗しました。");
                    return;
                }

                var userInputs = userWrap.GetElementsByTagName("input");
                var passInputs = passWrap.GetElementsByTagName("input");

                if (userInputs.Count == 0 || passInputs.Count == 0)
                {
                    this.Error("ネクソンへのログインに失敗しました。");
                    return;
                }

                userInputs[0].SetAttribute("value", this.UserName);
                passInputs[0].SetAttribute("value", this.Password);

                // ログイン元のページへ戻ってくる
                this.AddAction("http://www.arad.jp/guide/about.asp", this.GameStart);

                this.Document.InvokeScript("checkLoginFrm");
            }
        }

        /** \brief ゲームの起動処理 */
        private void GameStart()
        {
            this.Notice("ゲームを開始しています。");
            this.Navigate("http://www.arad.jp/launcher/game/game_start.asp", this.End);
        }

        /** \brief ゲーム起動成功 */
        private void End()
        {
            this.EndPlugin("ゲーム開始に成功しました。");
        }

        /** \brief ログアウト成功 */
        private void EndLogout()
        {
            this.Notice("ネクソンからのログアウトに成功しました。");
            this.LoginPage();
        }
    }

    /** \brief カウンターストライクオンラインのプラグイン */
    [Export(typeof(IPlugin))]
    [Export(typeof(IGamePlugin))]
    [ExportMetadata("PluginId", "Nexon.CounterStrike")]
    public class CounterStrike : GamePluginBase
    {
        /** \brief プラグインの基本情報の初期化 */
        public CounterStrike()
        {

            this.PluginInfo =
                new PluginInfo("1", "カウンターストライク (ネクソン) 起動プラグイン", "pine",
                    "カウンターストライク (ネクソン) を起動するためのプラグインです。");

            this.GameInfo =
                new GameInfo("ネクソン", "Nexon", "カウンターストライク", "http://cso.nexon.co.jp/top.aspx");
        }

        /** \brief プラグインの開始処理 */
        protected override void StartPlugin()
        {
            this.LoadTopPage();
        }

        /** \brief トップページを読み込む */
        private void LoadTopPage()
        {
            this.Notice("トップページを読み込んでいます。");
            this.Navigate(this.GameInfo.Url, this.LoginOrLogout);
        }

        /** \brief ログインもしくはログアウトの処理 */
        private void LoginOrLogout()
        {
            // アクションをクリア
            this.ClearAction();

            // ユーザー名入力欄
            var user = this.Document.GetElementById("nx_id");

            // ログイン済み
            if (user == null)
            {
                // ログアウトの処理
                this.Notice("ログアウトしています。");

                // ログアウトボタン
                var button = this.Document.GetElementById("ctl00_LoginView_ctl00_LogOut");

                // ログアウト処理
                this.Navigate(button.GetAttribute("href"), this.EndLogout,
                    "http://cso.nexon.co.jp/top.aspx");
            }

            // 未ログイン
            else
            {
                // ログインの処理
                this.Notice("ログインしています。");

                // パスワード入力欄
                var pass = this.Document.GetElementById("nx_pw");

                // 値を入力
                user.SetAttribute("value", this.UserName);
                pass.SetAttribute("value", this.Password);

                // 送信
                this.AddAction("http://cso.nexon.co.jp/top.aspx", this.GameStart);
                this.Document.InvokeScript("CSO_Login");
            }
        }

        /** \brief ゲーム開始処理 */
        private void GameStart()
        {
            this.EndPlugin("ゲームを開始しています。");

            // 起動関数を呼ぶ
            this.Document.InvokeScript("LaunchGame");
        }

        /** \brief ログアウトの終了処理 */
        private void EndLogout()
        {
            // アクションをクリア
            this.ClearAction();

            this.Notice("ログアウトに成功しました。");

            // ログイン処理
            this.LoginOrLogout();
        }
    }

    /** \brief アトランティカのプラグイン */
    [Export(typeof(IPlugin))]
    [Export(typeof(IGamePlugin))]
    [ExportMetadata("PluginId", "Nexon.Atlantica")]
    public class Atlantica : GamePluginBase
    {
        /** \brief プラグインの基本情報の初期化 */
        public Atlantica()
        {
            this.PluginInfo =
                new PluginInfo("1", "アトランティカ (ネクソン) 起動プラグイン", "pine",
                    "アトランティカ (ネクソン) を起動するためのプラグインです。");

            this.GameInfo =
                new GameInfo("ネクソン", "Nexon", "アトランティカ", "http://atlantica.nexon.co.jp/main.asp");
        }

        /** \brief プラグインの開始処理 */
        protected override void StartPlugin()
        {
            this.LoadTopPage();
        }

        /** \brief トップページを読み込む */
        private void LoadTopPage()
        {
            this.Notice("トップページを読み込んでいます。");

            // トップページを読み込む
            this.AddAction("http://atlantica.nexon.co.jp/custom/charactor.asp", this.LoginOrLogout);
            this.Navigate("http://atlantica.nexon.co.jp/BChk.asp?BChk=NO", this.LoginOrLogout);
        }

        /** \brief ログインとログアウトの処理 */
        private void LoginOrLogout()
        {
            // アクションをクリア
            this.ClearAction();

            // ログインフォームを取得
            var forms = this.Document.All.GetElementsByName("loginfrm");

            // 未ログイン
            if (forms.Count > 0)
            {
                // ログイン処理
                this.Notice("ネクソンにログインしています。");

                // ログインフォーム
                var form = forms[0];

                // input 要素を取得
                var inputs = form.GetElementsByTagName("input").Cast<HtmlElement>();

                // フォーム内のすべての input 要素に対してループ
                foreach (var input in inputs)
                {
                    // 入力要素だったら、値を入力
                    if (input.GetAttribute("className") == "login-txtarea")
                    {
                        if (input.GetAttribute("type") == "text")
                        {
                            input.SetAttribute("value", this.UserName);
                        }
                        else
                        {
                            input.SetAttribute("value", this.Password);
                        }
                    }
                }

                // 送信
                this.AddAction("http://atlantica.nexon.co.jp/main.asp", this.GameStart);
                this.AddAction("http://atlantica.nexon.co.jp/custom/charactor.asp", this.GameStart);
                this.Document.InvokeScript("checkFrmLoginForm");
            }

            // ログイン済み
            else
            {
                // ログアウトの処理
                this.Notice("ネクソンからログアウトしています。");

                // ログアウト関数の実行
                this.AddAction("http://atlantica.nexon.co.jp/main.asp", this.EndLogout);
                this.Document.InvokeScript("checkFrmLogout");
            }
        }

        /** \brief ゲームを開始する */
        private void GameStart()
        {
            this.EndPlugin("ゲームを開始しています。");
            this.Document.InvokeScript("LaunchGame");
        }

        /** \brief ログアウト完了 */
        private void EndLogout()
        {
            // アクションをクリア
            this.ClearAction();

            this.Notice("ログアウトに成功しました。");

            // ログイン処理
            this.LoginOrLogout();
        }
    }

    /** \brief DIVINAのプラグイン */
    [Export(typeof(IPlugin))]
    [Export(typeof(IGamePlugin))]
    [ExportMetadata("PluginId", "Nexon.Divina")]
    public class Divina : GamePluginBase
    {
        /** \brief プラグインの基本情報の初期化 */
        public Divina()
        {
            this.PluginInfo =
                new PluginInfo("1", "DIVINA (ネクソン) 起動プラグイン", "pine",
                    "DIVINA (ネクソン) を起動するためのプラグインです。");

            this.GameInfo =
                new GameInfo("ネクソン", "Nexon", "DIVINA", "http://divina.nexon.co.jp/"); 
        }

        /** \brief プラグインの開始処理 */
        protected override void StartPlugin()
        {
            this.LoadLoginPage();
        }

        /** \brief ログインページを読み込む */
        private void LoadLoginPage()
        {
            this.Notice("ログインページを読み込んでいます。");

            // ログインページを読み込む
            this.Navigate("http://divina.nexon.co.jp/login/index.aspx", this.Login);
        }

        /** \brief ログイン処理 */
        private void Login()
        {
            this.Notice("ネクソンにログインしています。");

            // 送信フォーム
            var form = this.Document.GetElementById("aspnetForm");

            // ユーザー名とパスワードの入力欄を取得
            var user = this.Document.GetElementById("tbAct");
            var pass = this.Document.GetElementById("tbPwd");

            // 値を入力
            user.SetAttribute("value", this.UserName);
            pass.SetAttribute("value", this.Password);

            // 送信
            this.AddAction("http://divina.nexon.co.jp/", this.GameStart);
            this.AddAction("http://divina.nexon.co.jp/index.aspx", this.GameStart);
            form.InvokeMember("submit");
        }

        /** \brief ゲームを開始 */
        private void GameStart()
        {
            this.EndPlugin("ゲームを開始しています。");

            // 起動関数を呼ぶ
            this.Document.InvokeScript("OnGameStart");
        }

    }

}
