﻿using System;
using System.Linq;
using System.Windows.Forms;
using System.ComponentModel.Composition;
using System.Diagnostics;

/** \brief ネクソンのプラグインの名前空間 */
namespace OGSNET.Plugins.Nexon
{
    using OGSNET.Plugin;

    /** \brief ネクソンの運営プラグイン */
    [Export(typeof(IPlugin))]
    [Export(typeof(IOperationPlugin))]
    [ExportMetadata("PluginId", "Nexon")]
    public class Operation : OperationPluginBase
    {
        /** \brief 基本情報の初期化 */
        public Operation()
        {
            this.PluginInfo =
                new PluginInfo(new Version(1), "ネクソン 運営プラグイン", "pine",
                    "ネクソンが運営しているゲームを識別するためのプラグイン。");

            this.OperationInfo =
                new OperationInfo("ネクソン", "http://www.nexon.co.jp/");
        }

        /**
         * \brief ログイン処理をを開始する
         * 
         * ダミープラグインのため、実際に処理をするわけではない。
         * 未実装例外を投げる
         */
        protected override void StartPlugin()
        {
            throw new NotImplementedException();
        }

    }
}
