﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ComponentModel.Composition;
using System.Windows.Forms;

/** \brief plaync の名前空間 */
namespace OGSNET.Plugins.Plaync
{
    using OGSNET.Plugin;

    /** \brief plaync の運営プラグイン */
    [Export(typeof(IPlugin))]
    [Export(typeof(IOperationPlugin))]
    [ExportMetadata("PluginId", "Plaync")]
    public class Operation : OperationPluginBase
    {
        /** \brief プラグインの基本情報の初期化 */
        public Operation()
        {
            this.PluginInfo =
                new PluginInfo(new Version(1), "plaync 運営プラグイン", "pine",
                    "plaync が運営するゲームの起動に利用されます。");

            this.OperationInfo =
                new OperationInfo("plaync", "http://www.plaync.jp/");
        }

        /** \brief プラグインの開始処理 */
        protected override void StartPlugin()
        {
            // トップページを読み込む
            this.LoadTopPage();
        }

        /** \brief トップページを読み込む */
        private void LoadTopPage()
        {
            this.Notice("トップページを読み込んでいます。");
            this.Navigate("http://www.plaync.jp/index.nc", this.LoginOrLogout);
        }

        /** \brief ログインもしくはログアウトの処理 */
        private void LoginOrLogout()
        {
            // アクションをクリア
            this.ClearAction();

            // ログインフォームを取得
            var form = this.Document.GetElementById("LoginFrm");

            // ログイン済み
            if (form == null)
            {
                // ログアウト処理
                this.Notice("plaync からログアウトしています。");

                // 関数を実行
                this.AddAction("http://www.plaync.jp/index.nc", this.EndLogout);
                this.Document.InvokeScript("eval", new object [] { "playncLogin.goLogout()" });
            }

            // 未ログイン
            else
            {
                // ログイン処理
                this.Notice("plaync へログインしています。");

                // ユーザー名、パスワード入力欄の取得
                var user = this.Document.GetElementById("account");
                var pass = this.Document.GetElementById("password");

                if (user == null || pass == null)
                {
                    this.Error("plaync へのログインに失敗しました。");
                    return;
                }

                // 値の入力
                user.SetAttribute("value", this.UserName);
                pass.SetAttribute("value", this.Password);

                // 送信
                this.AddAction("http://www.plaync.jp/index.nc", this.EndLogin);
                this.AddAction("https://ssl.plaync.jp/login/login.aspx", this.LoginError);
                form.InvokeMember("submit");
            }
        }

        /** \brief ログイン成功 */
        private void EndLogin()
        {
            this.EndPlugin("plaync へのログインに成功しました。");
        }

        /** \brief ログイン失敗 */
        private void LoginError()
        {
            this.Error("plaync へのログインに失敗しました。ユーザー名もしくはパスワードが間違っています。");
        }

        /** \brief ログアウト成功 */
        private void EndLogout()
        {
            // アクションをクリア
            this.ClearAction();

            this.Notice("plaync からのログアウトに成功しました。");

            // ログイン
            this.LoginOrLogout();
        }
    }
}