﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ComponentModel.Composition;
using System.Windows.Forms;

/** \brief テトリスオンラインの名前空間 */
namespace OGSNET.Plugins.TetrisOnline
{
    using OGSNET.Plugin;

    /** \brief テトリスオンラインのプラグイン */
    [Export(typeof(IPlugin))]
    [Export(typeof(IGamePlugin))]
    [ExportMetadata("PluginId", "TetrisOnline.TetrisOnline")]
    public class TetrisOnline : GamePluginBase
    {
        /** \brief プラグインの初期化処理 */
        public TetrisOnline()
        {
            this.PluginInfo =
                new PluginInfo(new Version(1), "テトリスオンライン 起動プラグイン", "pine",
                    "テトリスオンラインを起動するためのプラグインです");

            this.GameInfo =
                new GameInfo("テトリスオンライン", null, 
                    "テトリスオンライン", "http://www.tetrisonline.jp/toj/gmain/teco_top.aspx");
        }

        /** \brief プラグインの開始処理 */
        protected override void StartPlugin()
        {
            this.LoadTopPage();
        }

        /** \brief トップページを読み込む */
        private void LoadTopPage()
        {
            this.Notice("トップページを読み込んでいます。");
            this.Navigate("http://www.tetrisonline.jp/toj/gmain/teco_top.aspx", this.LoginOrLogout);
        }

        /** \brief ログインもしくはログアウトの処理 */
        private void LoginOrLogout()
        {
            // アクションをクリア
            this.ClearAction();

            // ユーザー名入力欄を取得
            var user = this.Document.GetElementById("LoginID");

            // ログイン済み
            if (user == null)
            {
                // ログアウトの処理
                this.Notice("ログアウトしています。");

                // ログアウトページへ飛ぶ
                this.Navigate("http://www.tetrisonline.jp/toj/acc/tacc_logout.aspx", this.EndLogout,
                    "http://www.tetrisonline.jp/toj/gmain/teco_top.aspx");
            }
            else
            {
                // ログインの処理
                this.Notice("ログインしています。");

                // パスワード入力欄
                var pass = this.Document.GetElementById("LoginPW");

                if (pass == null)
                {
                    this.Error("ログインに失敗しました。");
                    return;
                }

                // 値を設定
                user.SetAttribute("value", this.UserName);
                pass.SetAttribute("value", this.Password);

                // 送信
                this.AddAction("http://www.tetrisonline.jp/toj/gmain/teco_top.aspx", this.GameStart);
                this.AddAction("http://www.tetrisonline.jp/toj/acc/tacc_login.aspx", this.LoginError);
                this.Document.InvokeScript("loginCheck");
            }
        }

        /** \brief ゲームを開始する */
        private void GameStart()
        {
            // アクションをクリア
            this.ClearAction();

            this.Notice("ログインに成功しました。");
            this.EndPlugin("ゲームを開始します。");

            // 開始関数を呼ぶ
            this.Document.InvokeScript("LcGame");
        }

        /**
         * \brief ログインエラー
         * 
         * ユーザー名もしくはパスワードが違う場合の処理
         */
        private void LoginError()
        {
            this.Error("ログインに失敗しました。ユーザー名もしくはパスワードが違います。");
        }

        /** \brief ログアウト成功 */
        private void EndLogout()
        {
            // アクションをクリア
            this.ClearAction();

            this.Notice("ログアウトに成功しました。");

            // ログイン処理
            this.LoginOrLogout();
        }
    }
}
