/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.input;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.EntityRef;
import org.jdom.Namespace;
import org.jdom.input.DefaultJDOMFactory;
import org.jdom.input.JDOMFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public class SAXHandler
extends DefaultHandler
implements LexicalHandler,
DeclHandler {
    private static final String CVS_ID = "@(#) $RCSfile: SAXHandler.java,v $ $Revision: 1.18 $ $Date: 2001/06/22 09:00:27 $ $Name: jdom_1_0_b7_rc4 $";
    private Document document;
    private Stack stack;
    private boolean atRoot;
    private boolean inDTD = false;
    private boolean inCDATA = false;
    private boolean expand = true;
    private boolean suppress = false;
    private int entityDepth = 0;
    private LinkedList declaredNamespaces;
    private LinkedList availableNamespaces;
    private Map externalEntities;
    private JDOMFactory factory;
    private boolean ignoringWhite = false;

    public SAXHandler() throws IOException {
        this((JDOMFactory)null);
    }

    public SAXHandler(Document document) throws IOException {
        this(new DefaultJDOMFactory());
        this.document = document;
    }

    public SAXHandler(JDOMFactory factory) throws IOException {
        this.factory = factory != null ? factory : new DefaultJDOMFactory();
        this.atRoot = true;
        this.stack = new Stack();
        this.declaredNamespaces = new LinkedList();
        this.availableNamespaces = new LinkedList();
        this.availableNamespaces.add(Namespace.XML_NAMESPACE);
        this.externalEntities = new HashMap();
        this.document = this.factory.document(null);
    }

    public void attributeDecl(String eName, String aName, String type, String valueDefault, String value) {
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.suppress) {
            return;
        }
        String data = new String(ch, start, length);
        if (this.inCDATA) {
            ((Element)this.stack.peek()).addContent(this.factory.cdata(data));
        } else {
            Element e = (Element)this.stack.peek();
            e.addContent(data);
        }
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
        if (this.suppress) {
            return;
        }
        String commentText = new String(ch, start, length);
        if (!this.inDTD && !commentText.equals("")) {
            if (this.stack.empty()) {
                this.document.addContent(this.factory.comment(commentText));
            } else {
                ((Element)this.stack.peek()).addContent(this.factory.comment(commentText));
            }
        }
    }

    public void elementDecl(String name, String model) {
    }

    public void endCDATA() throws SAXException {
        if (this.suppress) {
            return;
        }
        this.inCDATA = false;
    }

    public void endDTD() throws SAXException {
        this.inDTD = false;
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        List addl;
        if (this.suppress) {
            return;
        }
        Element element = (Element)this.stack.pop();
        if (this.stack.empty()) {
            this.atRoot = true;
        }
        if ((addl = element.getAdditionalNamespaces()).size() > 0) {
            this.availableNamespaces.removeAll(addl);
        }
    }

    public void endEntity(String name) throws SAXException {
        --this.entityDepth;
        if (this.entityDepth == 0) {
            this.suppress = false;
        }
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        if (this.suppress) {
            return;
        }
        Iterator itr = this.availableNamespaces.iterator();
        while (itr.hasNext()) {
            Namespace ns = (Namespace)itr.next();
            if (!prefix.equals(ns.getPrefix())) continue;
            itr.remove();
            return;
        }
    }

    public void externalEntityDecl(String name, String publicId, String systemId) throws SAXException {
        this.externalEntities.put(name, new String[]{publicId, systemId});
    }

    public Document getDocument() {
        return this.document;
    }

    private Namespace getNamespace(String prefix) {
        Iterator i = this.availableNamespaces.iterator();
        while (i.hasNext()) {
            Namespace ns = (Namespace)i.next();
            if (!prefix.equals(ns.getPrefix())) continue;
            return ns;
        }
        return Namespace.NO_NAMESPACE;
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (this.suppress) {
            return;
        }
        if (this.ignoringWhite) {
            return;
        }
        ((Element)this.stack.peek()).addContent(new String(ch, start, length));
    }

    public void internalEntityDecl(String name, String value) {
    }

    public void processingInstruction(String target, String data) throws SAXException {
        if (this.suppress) {
            return;
        }
        if (this.atRoot) {
            this.document.addContent(this.factory.processingInstruction(target, data));
        } else {
            ((Element)this.stack.peek()).addContent(this.factory.processingInstruction(target, data));
        }
    }

    public void setExpandEntities(boolean expand) {
        this.expand = expand;
    }

    public void setIgnoringElementContentWhitespace(boolean ignoringWhite) {
        this.ignoringWhite = ignoringWhite;
    }

    public void startCDATA() throws SAXException {
        if (this.suppress) {
            return;
        }
        this.inCDATA = true;
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        this.document.setDocType(this.factory.docType(name, publicId, systemId));
        this.inDTD = true;
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (this.suppress) {
            return;
        }
        Element element = null;
        if (namespaceURI != null && !namespaceURI.equals("")) {
            String prefix = "";
            if (localName != qName) {
                int split = qName.indexOf(":");
                prefix = qName.substring(0, split);
            }
            Namespace elementNamespace = Namespace.getNamespace(prefix, namespaceURI);
            element = this.factory.element(localName, elementNamespace);
            if (this.declaredNamespaces.size() > 0) {
                this.declaredNamespaces.remove(elementNamespace);
            }
        } else {
            element = this.factory.element(localName);
        }
        if (this.declaredNamespaces.size() > 0) {
            this.transferNamespaces(element);
        }
        int i = 0;
        int len = atts.getLength();
        while (i < len) {
            Attribute attribute = null;
            String attLocalName = atts.getLocalName(i);
            String attQName = atts.getQName(i);
            if (!attQName.startsWith("xmlns:") && !attQName.equals("xmlns")) {
                if (attLocalName != attQName) {
                    String attPrefix = attQName.substring(0, attQName.indexOf(":"));
                    attribute = this.factory.attribute(attLocalName, atts.getValue(i), this.getNamespace(attPrefix));
                } else {
                    attribute = this.factory.attribute(attLocalName, atts.getValue(i));
                }
                element.setAttribute(attribute);
            }
            ++i;
        }
        if (this.atRoot) {
            this.document.setRootElement(element);
            this.stack.push(element);
            this.atRoot = false;
        } else {
            ((Element)this.stack.peek()).addContent(element);
            this.stack.push(element);
        }
    }

    public void startEntity(String name) throws SAXException {
        ++this.entityDepth;
        if (this.expand || this.entityDepth > 1) {
            return;
        }
        if (!(this.inDTD || name.equals("amp") || name.equals("lt") || name.equals("gt") || name.equals("apos") || name.equals("quot") || this.expand)) {
            String pub = null;
            String sys = null;
            String[] ids = (String[])this.externalEntities.get(name);
            if (ids != null) {
                pub = ids[0];
                sys = ids[1];
            }
            EntityRef entity = this.factory.entityRef(name, pub, sys);
            ((Element)this.stack.peek()).addContent(entity);
            this.suppress = true;
        }
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (this.suppress) {
            return;
        }
        Namespace ns = Namespace.getNamespace(prefix, uri);
        this.declaredNamespaces.add(ns);
    }

    private void transferNamespaces(Element element) {
        Iterator i = this.declaredNamespaces.iterator();
        while (i.hasNext()) {
            Namespace ns = (Namespace)i.next();
            this.availableNamespaces.addFirst(ns);
            element.addNamespaceDeclaration(ns);
        }
        this.declaredNamespaces.clear();
    }
}

