/*
 * Decompiled with CFR 0.152.
 */
package org.kxml.wap;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.kxml.wap.SyncML;
import org.kxml.wap.WbxmlWriter;

public class SyncMLWriter
extends WbxmlWriter {
    private String dtd;
    private String version;

    public SyncMLWriter(String version) throws IOException {
        this("syncml", version);
    }

    public SyncMLWriter(String namespace, String version) throws IOException {
        super(new ByteArrayOutputStream());
        if ("syncml:devinf".equals(namespace)) {
            if ("1.2".equals(version)) {
                this.dtd = "-//SYNCML//DTD DevInf 1.2//EN";
                this.setTagTable(0, SyncML.tagTableDevInf12);
            } else if ("1.1".equals(version)) {
                this.dtd = "-//SYNCML//DTD DevInf 1.1//EN";
                this.setTagTable(0, SyncML.tagTableDevInf);
            } else {
                this.dtd = "-//SYNCML//DTD DevInf 1.0//EN";
                this.setTagTable(0, SyncML.tagTableDevInf);
            }
        } else if ("syncml:dmddf1.2".equals(namespace)) {
            this.dtd = "-//OMA//DTD-DM-DDF 1.2//EN";
            this.setTagTable(0, SyncML.tagTableDMDDF);
        } else {
            this.dtd = "1.2".equals(version) ? "-//SYNCML//DTD SyncML 1.2//EN" : ("1.1".equals(version) ? "-//SYNCML//DTD SyncML 1.1//EN" : "-//SYNCML//DTD SyncML 1.0//EN");
            this.setTagTable(0, SyncML.tagTableSyncml);
            this.setTagTable(1, SyncML.tagTableMetainf);
        }
    }

    @Override
    protected void writeHeader() throws IOException {
        this.out.write(2);
        this.out.write(0);
        this.out.write(0);
        this.out.write(106);
    }

    public void writeOpaque(String str) throws IOException {
        char[] chars = new char[str.length()];
        str.getChars(0, chars.length, chars, 0);
        this.write(chars, 0, chars.length, true);
    }

    @Override
    public void close() throws IOException {
        this.writeHeader();
        SyncMLWriter.writeInt(this.out, this.dtd.length());
        this.out.write(this.dtd.getBytes());
        this.out.write(this.buf.toByteArray());
        this.out.flush();
    }

    public byte[] getBytes() {
        return ((ByteArrayOutputStream)this.out).toByteArray();
    }
}

